package mc.recraftors.unruled_api.utils;

import com.mojang.brigadier.arguments.ArgumentType;
import mc.recraftors.unruled_api.impl.FullRegistryWrapperLookup;
import net.minecraft.command.CommandRegistryAccess;
import net.minecraft.command.argument.RegistryEntryArgumentType;
import net.minecraft.command.argument.RegistryEntryReferenceArgumentType;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;

import java.util.function.Supplier;

public final class RegArgBuilder <T> implements Supplier<ArgumentType<?>> {
    public final RegistryKey<? extends Registry<T>> regKey;

    public RegArgBuilder(RegistryKey<? extends Registry<T>> regKey) {
        this.regKey = regKey;
    }

    @Override
    public ArgumentType<?> get() {
        return null;
    }

    public RegistryEntryReferenceArgumentType<T> build(CommandRegistryAccess access) {
        return RegistryEntryReferenceArgumentType.registryEntry(
                new FullRegistryWrapperLookup(access).toCommandRegAccessAccess(), this.regKey
        );
    }
}
