/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.api.proxy;

import io.github.kosmx.emotes.api.proxy.EmotesProxyManager;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.common.network.EmotePacket;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNetworkInstance
implements INetworkInstance {
    private final HashMap<Byte, Byte> versions = new HashMap<Byte, Byte>(EmotePacket.defaultVersions);

    protected void sendMessage(byte[] bytes, @Nullable UUID target) {
        throw new UnsupportedOperationException("You should have implemented send emote feature");
    }

    public void sendMessage(ByteBuffer byteBuffer, @Nullable UUID target) {
        this.sendMessage(AbstractNetworkInstance.safeGetBytesFromBuffer(byteBuffer), target);
    }

    @Override
    public void sendMessage(EmotePacket.Builder builder, @Nullable UUID target) throws IOException {
        this.sendMessage(builder.build().write(), target);
    }

    public void receiveMessage(byte[] bytes) {
        this.receiveMessage(bytes, null);
    }

    public void receiveMessage(byte[] bytes, UUID player) {
        this.receiveMessage(ByteBuffer.wrap(bytes), player);
    }

    protected void disconnect() {
        EmotesProxyManager.disconnectInstance(this);
    }

    public static byte[] safeGetBytesFromBuffer(ByteBuffer byteBuffer) {
        return INetworkInstance.safeGetBytesFromBuffer(byteBuffer);
    }

    @Override
    public void setVersions(HashMap<Byte, Byte> map) {
        this.versions.clear();
        this.versions.putAll(map);
    }

    @Override
    public HashMap<Byte, Byte> getRemoteVersions() {
        return this.versions;
    }

    @Override
    public boolean isServerTrackingPlayState() {
        return this.versions.containsKey((byte)-128) && this.versions.get((byte)-128) != 0;
    }

    @Override
    public void sendC2SConfig(Consumer<EmotePacket.Builder> consumer) {
        EmotePacket.Builder packetBuilder = new EmotePacket.Builder();
        packetBuilder.configureToConfigExchange(true);
        try {
            consumer.accept(packetBuilder);
        }
        catch (Exception e) {
            CommonData.LOGGER.warn("Error while writing packet!", (Throwable)e);
        }
    }
}

