/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.mixin;

import com.zigythebird.playeranim.accessors.IAnimatedAvatar;
import com.zigythebird.playeranim.util.ClientUtil;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import com.zigythebird.playeranimcore.animation.layered.IAnimation;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.api.events.client.ClientEmoteEvents;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.emotePlay.EmotePlayer;
import io.github.kosmx.emotes.main.mixinFunctions.IPlayerEntity;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Avatar.class})
public abstract class EmoteAvatarMixin
extends LivingEntity
implements IPlayerEntity {
    @Unique
    private int emotecraft$age = 0;
    @Unique
    private final EmotePlayer emotecraft$container = new EmotePlayer((Avatar)this);
    @Unique
    private boolean emotecraft$isForced = false;

    protected EmoteAvatarMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="TAIL")})
    private void init(EntityType<? extends LivingEntity> entityType, Level level, CallbackInfo ci) {
        ((IAnimatedAvatar)this).playerAnimLib$getAnimManager().addAnimLayer(1000, (IAnimation)this.emotecraft$container);
    }

    @Override
    public void emotecraft$playEmote(@Nullable Animation emote, Animation.LoopType loopType, float tick, boolean isForced) {
        this.stopEmote();
        if (emote != null) {
            this.emotecraft$container.triggerAnimation(RawAnimation.begin().then(emote, loopType), tick);
            this.initEmotePerspective();
            if (this.isMainAvatar()) {
                this.emotecraft$isForced = isForced;
            }
        }
    }

    @Override
    @NotNull
    public EmotePlayer emotecraft$getEmote() {
        return this.emotecraft$container;
    }

    @Inject(method={"tick", "method_5773"}, at={@At(value="TAIL")}, remap=false)
    public void tick(CallbackInfo ci) {
        if (this.emotecraft$age <= 1 && this.emotecraft$age++ == 1) {
            Pair<Animation, Float> p = ClientEmotePlay.getEmoteForUUID(this.getUUID());
            if (p != null) {
                ((ClientEmoteEvents.EmotePlayEvent)ClientEmoteEvents.EMOTE_PLAY.invoker()).onEmotePlay((Animation)p.left(), ((Float)p.right()).floatValue(), this.getUUID());
                this.emotecraft$playEmote((Animation)p.left(), ((Float)p.right()).floatValue(), false);
            }
            if (!this.isMainAvatar() && ClientUtil.getClientPlayer() != null && ClientUtil.getClientPlayer().isPlayingEmote()) {
                LocalPlayer playerEntity = ClientUtil.getClientPlayer();
                ClientEmotePlay.clientRepeatLocalEmote(playerEntity.emotecraft$getEmote().getCurrentAnimationInstance(), playerEntity.emotecraft$getEmote().getAnimationTicks(), this.getUUID());
            }
        }
        if (this.isPlayingEmote() && this.isMainAvatar()) {
            AbstractClientPlayer player;
            EmoteAvatarMixin emoteAvatarMixin;
            if (this.emotecraft$getEmote().perspective && PlatformTools.getPerspective() != PlatformTools.getConfig().getCameraType()) {
                this.emotecraft$getEmote().perspective = false;
            }
            if ((emoteAvatarMixin = this) instanceof AbstractClientPlayer && !EmoteHolder.canRunEmote(player = (AbstractClientPlayer)emoteAvatarMixin)) {
                ClientEmotePlay.clientStopLocalEmote(player.emotecraft$getEmote().getCurrentAnimationInstance());
            }
        }
    }

    @Override
    public boolean emotecraft$isForcedEmote() {
        return this.isPlayingEmote() && this.emotecraft$isForced;
    }
}

