/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.neoforge.network;

import io.github.kosmx.emotes.arch.network.CommonServerNetworkHandler;
import io.github.kosmx.emotes.arch.network.ConfigTask;
import io.github.kosmx.emotes.arch.network.EmotePacketPayload;
import io.github.kosmx.emotes.arch.network.EmotesMixinConnection;
import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.arch.network.client.ClientNetwork;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.PacketTask;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.io.IOException;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.server.network.ConfigurationTask;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.extensions.ICommonPacketListener;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

@EventBusSubscriber(modid="emotecraft")
public class ForgeNetwork {
    @SubscribeEvent
    public static void registerPlay(RegisterPayloadHandlersEvent event) {
        event.registrar("emotecraft").optional().playBidirectional(NetworkPlatformTools.EMOTE_CHANNEL_ID, EmotePacketPayload.EMOTE_CHANNEL_READER, (arg, playPayloadContext) -> CommonServerNetworkHandler.getInstance().receiveMessage(arg.unwrapBytes(), playPayloadContext.player()), (arg, playPayloadContext) -> ClientNetwork.INSTANCE.receiveMessage(arg.unwrapBytes())).optional().playBidirectional(NetworkPlatformTools.STREAM_CHANNEL_ID, EmotePacketPayload.STREAM_CHANNEL_READER, (arg, playPayloadContext) -> CommonServerNetworkHandler.getInstance().receiveStreamMessage(arg.unwrapBytes(), playPayloadContext.player()), (arg, playPayloadContext) -> {
            try {
                ClientNetwork.INSTANCE.receiveStreamMessage(arg.bytes(), arg_0 -> ((ICommonPacketListener)playPayloadContext.listener()).send(arg_0));
            }
            catch (IOException e) {
                CommonData.LOGGER.error("", (Throwable)e);
            }
        }).optional().configurationBidirectional(NetworkPlatformTools.EMOTE_CHANNEL_ID, EmotePacketPayload.EMOTE_CHANNEL_READER, (arg, configurationPayloadContext) -> {
            try {
                NetData message = new EmotePacket.Builder().build().read(arg.bytes());
                if (message.purpose != PacketTask.CONFIG) {
                    throw new IOException("Wrong packet type for config task");
                }
                ((EmotesMixinConnection)configurationPayloadContext.connection()).emotecraft$setVersions(message.versions);
                UniversalEmoteSerializer.preparePackets(message.versions).map(NetworkPlatformTools::playPacket).forEach(arg_0 -> ((Connection)configurationPayloadContext.connection()).send(arg_0));
                configurationPayloadContext.finishCurrentTask(ConfigTask.TYPE);
            }
            catch (IOException e) {
                CommonData.LOGGER.error("", (Throwable)e);
                configurationPayloadContext.disconnect((Component)Component.literal((String)("emotecraft: " + e.getMessage())));
            }
        }, (arg, configurationPayloadContext) -> {
            try {
                ClientNetwork.INSTANCE.receiveConfigMessage(arg.bytes(), arg_0 -> ((ICommonPacketListener)configurationPayloadContext.listener()).send(arg_0));
            }
            catch (IOException e) {
                CommonData.LOGGER.error("", (Throwable)e);
            }
        }).optional().configurationToClient(NetworkPlatformTools.STREAM_CHANNEL_ID, EmotePacketPayload.STREAM_CHANNEL_READER, (arg, configurationPayloadContext) -> {
            try {
                ClientNetwork.INSTANCE.receiveStreamMessage(arg.bytes(), arg_0 -> ((ICommonPacketListener)configurationPayloadContext.listener()).send(arg_0));
            }
            catch (IOException e) {
                CommonData.LOGGER.error("", (Throwable)e);
            }
        });
    }

    @SubscribeEvent
    public static void registerNetworkConfigTask(RegisterConfigurationTasksEvent event) {
        if (event.getListener().hasChannel(NetworkPlatformTools.EMOTE_CHANNEL_ID)) {
            event.register((ConfigurationTask)new ConfigTask());
        } else {
            CommonData.LOGGER.debug("Client doesn't support emotes, ignoring");
        }
    }
}

