/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network;

import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;

public record EmotePacketPayload(@NotNull CustomPacketPayload.Type<?> id, @NotNull EmotePacket packet) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, EmotePacketPayload> EMOTE_CHANNEL_READER = EmotePacketPayload.reader(NetworkPlatformTools.EMOTE_CHANNEL_ID);
    public static final StreamCodec<FriendlyByteBuf, EmotePacketPayload> STREAM_CHANNEL_READER = EmotePacketPayload.reader(NetworkPlatformTools.STREAM_CHANNEL_ID);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return this.id;
    }

    @NotNull
    public static CustomPacketPayload playPacket(@NotNull EmotePacket packet) {
        return new EmotePacketPayload(NetworkPlatformTools.EMOTE_CHANNEL_ID, packet);
    }

    @NotNull
    public static CustomPacketPayload streamPacket(@NotNull EmotePacket packet) {
        return new EmotePacketPayload(NetworkPlatformTools.STREAM_CHANNEL_ID, packet);
    }

    @NotNull
    public static StreamCodec<FriendlyByteBuf, EmotePacketPayload> reader(@NotNull CustomPacketPayload.Type<?> channel) {
        return CustomPacketPayload.codec((payload, buf) -> payload.packet().write((ByteBuf)buf, buf.alloc()), buf -> new EmotePacketPayload(channel, new EmotePacket((ByteBuf)buf)));
    }
}

