/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.utils;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.Nullable;

public class BageUtils {
    private static final int SPACE = 3;

    public static int drawBadges(GuiGraphics guiGraphics, Font font, List<Component> text, int x, int y, int width, boolean right) {
        int bageX = right ? 3 : x;
        for (Component bage : text) {
            int tagWidth = font.width((FormattedText)bage) + 6;
            if (bageX + tagWidth + 3 >= width) continue;
            BageUtils.drawBadge(guiGraphics, font, bage, right ? x - tagWidth - bageX : bageX, y, tagWidth, -1);
            bageX += tagWidth + 3;
        }
        return bageX;
    }

    public static void drawBadge(GuiGraphics guiGraphics, Font font, Component text, int x, int y, int color) {
        BageUtils.drawBadge(guiGraphics, font, text, x, y, font.width((FormattedText)text) + 6, color);
    }

    public static void drawBadge(GuiGraphics guiGraphics, Font font, Component text, int x, int y, int tagWidth, int color) {
        TextColor textColor = text.getStyle().getColor();
        int outlineColor = BageUtils.getTextColor(textColor, color);
        int fillColor = BageUtils.getShadowColor(text.getStyle(), outlineColor);
        guiGraphics.fill(x + 1, y - 1, x + tagWidth, y, outlineColor);
        Objects.requireNonNull(font);
        guiGraphics.fill(x, y, x + 1, y + 9, outlineColor);
        Objects.requireNonNull(font);
        Objects.requireNonNull(font);
        guiGraphics.fill(x + 1, y + 1 + 9 - 1, x + tagWidth, y + 9 + 1, outlineColor);
        Objects.requireNonNull(font);
        guiGraphics.fill(x + tagWidth, y, x + tagWidth + 1, y + 9, outlineColor);
        Objects.requireNonNull(font);
        guiGraphics.fill(x + 1, y, x + tagWidth, y + 9, fillColor);
        guiGraphics.drawString(font, text, (int)((float)(x + 1) + (float)(tagWidth - font.width((FormattedText)text)) / 2.0f), y + 1, color, false);
    }

    private static int getTextColor(@Nullable TextColor textColor, int color) {
        if (textColor != null) {
            int i = ARGB.alpha((int)color);
            int j = textColor.getValue();
            return ARGB.color((int)i, (int)j);
        }
        return color;
    }

    private static int getShadowColor(Style style, int textColor) {
        Integer integer = style.getShadowColor();
        if (integer != null) {
            float f = ARGB.alphaFloat((int)textColor);
            float g = ARGB.alphaFloat((int)integer);
            return f != 1.0f ? ARGB.color((int)ARGB.as8BitChannel((float)(f * g)), (int)integer) : integer;
        }
        return ARGB.scaleRGB((int)textColor, (float)0.25f);
    }
}

