/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.gui.widgets.search;

import com.blamejared.searchables.api.SearchableComponent;
import com.blamejared.searchables.api.SearchableType;
import com.blamejared.searchables.api.autcomplete.AutoCompletingEditBox;
import com.blamejared.searchables.api.context.ContextVisitor;
import com.blamejared.searchables.lang.StringSearcher;
import com.blamejared.searchables.lang.expression.visitor.Visitor;
import io.github.kosmx.emotes.arch.gui.widgets.EmoteListWidget;
import io.github.kosmx.emotes.arch.gui.widgets.search.ISearchEngine;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public class SearchablesSearch
implements ISearchEngine {
    public static final SearchableType<EmoteListWidget.ListEntry> SEARCHABLE = new SearchableType.Builder().defaultComponent(SearchableComponent.create((String)"default", holder -> Optional.ofNullable(holder.name).map(Component::getString).filter(str -> !str.isEmpty()), EmoteListWidget.ListEntry::matches)).component(SearchableComponent.create((String)"name", holder -> Optional.ofNullable(holder.name).map(Component::getString).filter(str -> !str.isEmpty()))).component(SearchableComponent.create((String)"description", holder -> Optional.ofNullable(holder.description).map(Component::getString).filter(str -> !str.isEmpty()))).component(SearchableComponent.create((String)"author", entry -> {
        Optional<Object> optional;
        if (entry instanceof EmoteListWidget.EmoteEntry) {
            EmoteListWidget.EmoteEntry holder = (EmoteListWidget.EmoteEntry)entry;
            optional = Optional.ofNullable(holder.emote.author).map(Component::getString).filter(str -> !str.isEmpty());
        } else {
            optional = Optional.empty();
        }
        return optional;
    })).component(SearchableComponent.create((String)"fileName", entry -> {
        Optional<Object> optional;
        if (entry instanceof EmoteListWidget.EmoteEntry) {
            EmoteListWidget.EmoteEntry holder = (EmoteListWidget.EmoteEntry)entry;
            optional = Optional.ofNullable(holder.emote.fileName).map(Component::getString).filter(str -> !str.isEmpty());
        } else {
            optional = Optional.empty();
        }
        return optional;
    })).build();
    protected AutoCompletingEditBox<EmoteListWidget.ListEntry> search;

    @Override
    public EditBox createEditBox(Font font, Component message, Supplier<List<EmoteListWidget.ListEntry>> entries) {
        this.search = new FixedAutoCompletingEditBox<EmoteListWidget.ListEntry>(font, 0, 0, 200, 20, message, SEARCHABLE, entries);
        return this.search;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.search == null) {
            return false;
        }
        return this.search.autoComplete().mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.search != null) {
            this.search.autoComplete().render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public Stream<EmoteListWidget.ListEntry> filter(Stream<EmoteListWidget.ListEntry> entries, String search) {
        Optional context = StringSearcher.search((String)search, (Visitor)new ContextVisitor());
        return entries.filter(context.map(tSearchContext -> tSearchContext.createPredicate(SEARCHABLE)).orElse(t -> true));
    }

    public static class FixedAutoCompletingEditBox<T>
    extends AutoCompletingEditBox<T> {
        public FixedAutoCompletingEditBox(Font font, int x, int y, int width, int height, Component message, SearchableType<T> type, Supplier<List<T>> entries) {
            super(font, x, y, width, height, message, type, entries);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            if (!this.isHoveredOrFocused()) {
                return false;
            }
            return super.mouseClicked(event, doubleClick);
        }

        public void setX(int x) {
            this.autoComplete().setX(x);
            super.setX(x);
        }

        public void setY(int y) {
            super.setY(y);
            this.autoComplete().setY(this.getY() + 2 + this.getHeight());
        }

        public void setWidth(int width) {
            this.autoComplete().setWidth(width);
            super.setWidth(width);
        }

        public void setHeight(int height) {
            this.autoComplete().setHeight(height);
            super.setHeight(height);
            this.autoComplete().setY(this.getY() + 2 + this.getHeight());
        }

        public void setSize(int width, int height) {
            this.autoComplete().setSize(width, height);
            super.setSize(width, height);
            this.autoComplete().setY(this.getY() + 2 + this.getHeight());
        }
    }
}

