/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.utils;

import com.google.gson.internal.UnsafeAllocator;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.IdMapper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.Strategy;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnsafeClientLevel
extends ClientLevel
implements LevelEntityGetter<Entity> {
    public static final UnsafeClientLevel INSTANCE;
    private static final ClientLevel.ClientLevelData CLIENT_LEVEL_DATA;
    private static final PalettedContainerFactory PALETTED_CONTAINER_FACTORY;

    private UnsafeClientLevel(ClientPacketListener connection, ClientLevel.ClientLevelData levelData, ResourceKey<Level> dimension, Holder<DimensionType> dimensionTypeRegistration, int viewDistance, int serverSimulationDistance, LevelRenderer levelRenderer, boolean isDebug, long biomeZoomSeed, int seaLevel) {
        super(connection, levelData, dimension, dimensionTypeRegistration, viewDistance, serverSimulationDistance, levelRenderer, isDebug, biomeZoomSeed, seaLevel);
    }

    public int getBrightness(LightLayer lightType, BlockPos blockPos) {
        return 0;
    }

    @NotNull
    public Scoreboard getScoreboard() {
        return new Scoreboard();
    }

    public boolean isOutsideBuildHeight(int y) {
        return true;
    }

    public int getMinY() {
        return 1;
    }

    public int getHeight() {
        return 1;
    }

    public boolean isRaining() {
        return false;
    }

    @NotNull
    protected LevelEntityGetter<Entity> getEntities() {
        return this;
    }

    @Nullable
    public Entity get(int id) {
        return null;
    }

    @Nullable
    public Entity get(UUID uuid) {
        return null;
    }

    @NotNull
    public Iterable<Entity> getAll() {
        return Collections.emptyList();
    }

    public <U extends Entity> void get(EntityTypeTest<Entity, U> test, AbortableIterationConsumer<U> consumer) {
    }

    public void get(AABB boundingBox, Consumer<Entity> consumer) {
    }

    public <U extends Entity> void get(EntityTypeTest<Entity, U> test, AABB bounds, AbortableIterationConsumer<U> consumer) {
    }

    public ChunkAccess getChunk(int x, int z, ChunkStatus chunkStatus, boolean requireChunk) {
        return new EmptyLevelChunk((Level)this, new ChunkPos(x, z), Holder.direct(null));
    }

    @NotNull
    public BlockState getBlockState(BlockPos pos) {
        return Blocks.VOID_AIR.defaultBlockState();
    }

    public long getGameTime() {
        return 0L;
    }

    public long getDayTime() {
        return 0L;
    }

    @NotNull
    public ClientLevel.ClientLevelData getLevelData() {
        return CLIENT_LEVEL_DATA;
    }

    @NotNull
    public List<Entity> getPushableEntities(Entity entity, AABB boundingBox) {
        return Collections.emptyList();
    }

    @NotNull
    public PalettedContainerFactory palettedContainerFactory() {
        return PALETTED_CONTAINER_FACTORY;
    }

    static {
        try {
            INSTANCE = (UnsafeClientLevel)((Object)UnsafeAllocator.INSTANCE.newInstance(UnsafeClientLevel.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CLIENT_LEVEL_DATA = new ClientLevel.ClientLevelData(Difficulty.PEACEFUL, false, true);
        PALETTED_CONTAINER_FACTORY = new PalettedContainerFactory(Strategy.createForBlockStates((IdMap)new IdMapper()), Blocks.AIR.defaultBlockState(), null, Strategy.createForBiomes((IdMap)new IdMapper()), Holder.direct(null), null);
    }
}

