/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network.objects;

import io.github.kosmx.emotes.common.nbsplayer.LegacyNBSPacket;
import io.github.kosmx.emotes.common.network.objects.AbstractNetworkPacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.common.tools.ByteBufferInputStream;
import io.github.kosmx.emotes.common.tools.ByteBufferOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.raphimc.noteblocklib.NoteBlockLib;
import net.raphimc.noteblocklib.format.SongFormat;
import net.raphimc.noteblocklib.format.nbs.model.NbsSong;
import net.raphimc.noteblocklib.model.Song;

public class SongPacket
extends AbstractNetworkPacket {
    @Override
    public byte getID() {
        return 3;
    }

    @Override
    public byte getVer() {
        return 2;
    }

    @Override
    public void read(ByteBuffer byteBuffer, NetData config, int version) throws IOException {
        NbsSong nbsSong;
        switch (version) {
            case 2: {
                NbsSong nbsSong2;
                try {
                    nbsSong = nbsSong2 = NoteBlockLib.readSong((InputStream)new ByteBufferInputStream(byteBuffer), (SongFormat)SongFormat.NBS);
                    break;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            case 1: {
                NbsSong nbsSong2;
                nbsSong = nbsSong2 = LegacyNBSPacket.read(byteBuffer);
                break;
            }
            default: {
                NbsSong nbsSong2;
                nbsSong = nbsSong2 = null;
            }
        }
        NbsSong song = nbsSong;
        config.extraData.put("song", song);
    }

    @Override
    public void write(ByteBuffer byteBuffer, NetData config) throws IOException {
        assert (config.emoteData != null);
        Song song = (Song)config.emoteData.data().getRaw("song");
        byte version = this.getVer(config.versions);
        if (version > 1) {
            try {
                NoteBlockLib.writeSong((Song)song, (OutputStream)new ByteBufferOutputStream(byteBuffer));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } else {
            LegacyNBSPacket.write((NbsSong)song, byteBuffer);
        }
    }

    @Override
    public boolean doWrite(NetData config) {
        return config.versions.get(this.getID()) != 0 && config.emoteData != null && config.emoteData.data().has("song") && config.writeSong;
    }

    @Override
    public int calculateSize(NetData config) {
        if (config.emoteData == null || config.emoteData.data().getRaw("song") == null) {
            return 0;
        }
        Song song = (Song)config.emoteData.data().getRaw("song");
        if (this.getVer(config.versions) > 1) {
            return SongPacket.calculateSongSize(song);
        }
        return LegacyNBSPacket.calculateMessageSize((NbsSong)song);
    }

    public static int calculateSongSize(Song song) {
        int n;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            NoteBlockLib.writeSong((Song)song, (OutputStream)os);
            n = os.size();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        os.close();
        return n;
    }
}

