/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.zigythebird.playeranim.util.ClientUtil;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.ExtraAnimationData;
import com.zigythebird.playeranimcore.loading.UniversalAnimLoader;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.common.tools.UUIDMap;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import io.github.kosmx.emotes.mc.McUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmoteHolder
implements Supplier<UUID> {
    public final Animation emote;
    public final Component name;
    public final Component description;
    public final Component author;
    public final List<Component> folder;
    public final List<Component> bages;
    @Nullable
    public final Component fileName;
    public AtomicInteger hash = null;
    public static UUIDMap<EmoteHolder> list = new UUIDMap();
    @Nullable
    private ResourceLocation iconIdentifier = null;
    @Nullable
    private INetworkInstance fromInstance = null;

    public EmoteHolder(Animation emote) {
        this.emote = emote;
        this.name = emote.data().get("name").map(McUtils::fromJson).orElseThrow();
        this.description = emote.data().get("description").map(McUtils::fromJson).orElse(CommonComponents.EMPTY);
        this.author = emote.data().get("author").map(McUtils::fromJson).orElse(CommonComponents.EMPTY);
        this.folder = EmoteHolder.computeFolderPath((String)emote.data().getRaw("folderpath"));
        this.bages = EmoteHolder.computeBages((List)emote.data().getRaw("bages"));
        this.fileName = emote.data().get("fileName").map(McUtils::fromJson).orElse(null);
    }

    private static List<Component> computeFolderPath(String folderPath) {
        if (StringUtils.isBlank((CharSequence)folderPath)) {
            return Collections.emptyList();
        }
        return Arrays.stream(folderPath.split("/")).map(Component::literal).collect(Collectors.toUnmodifiableList());
    }

    private static List<Component> computeBages(List<String> bages) {
        if (bages == null || bages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Component> components = new ArrayList<Component>(bages.size());
        for (String element : bages) {
            try {
                components.add(McUtils.fromJson(element, (HolderLookup.Provider)RegistryAccess.EMPTY));
            }
            catch (Throwable th) {
                CommonData.LOGGER.warn("Failed to serialize bage!", th);
            }
        }
        return Collections.unmodifiableList(components);
    }

    public static void clearEmotes() {
        EmoteHolder.clearEmotes(null);
    }

    public static void clearEmotes(INetworkInstance networkInstance) {
        list.removeIf(emoteHolder -> {
            if (emoteHolder.fromInstance != networkInstance) {
                return false;
            }
            emoteHolder.closeIcon();
            return true;
        });
    }

    @Nullable
    public ResourceLocation getIconIdentifier() {
        Object object = this.emote.data().getRaw("iconData");
        if (object instanceof ByteBuffer) {
            ByteBuffer buff = (ByteBuffer)object;
            if (this.iconIdentifier == null) {
                this.registerIcon(buff);
            }
        }
        return this.iconIdentifier;
    }

    private void registerIcon(ByteBuffer buffer) {
        RenderSystem.assertOnRenderThread();
        try (ByteArrayInputStream stream = new ByteArrayInputStream(AbstractNetworkInstance.safeGetBytesFromBuffer(buffer));){
            this.iconIdentifier = McUtils.newIdentifier("icon" + this.hashCode());
            Minecraft.getInstance().getTextureManager().register(this.iconIdentifier, (AbstractTexture)new DynamicTexture(() -> ((ResourceLocation)this.iconIdentifier).toString(), NativeImage.read((InputStream)stream)));
        }
        catch (Throwable th) {
            CommonData.LOGGER.warn("Can't open emote {} icon!", (Object)this.emote, (Object)th);
        }
    }

    private void closeIcon() {
        if (this.iconIdentifier == null) {
            return;
        }
        if (RenderSystem.isOnRenderThread()) {
            Minecraft.getInstance().getTextureManager().release(this.iconIdentifier);
        } else {
            ResourceLocation iconIdentifier = this.iconIdentifier;
            Minecraft.getInstance().executeBlocking(() -> Minecraft.getInstance().getTextureManager().release(iconIdentifier));
        }
        this.iconIdentifier = null;
    }

    public Animation getEmote() {
        return this.emote;
    }

    public static EmoteHolder getEmoteFromUuid(UUID uuid) {
        return (EmoteHolder)list.get(uuid);
    }

    public static EmoteHolder findIfPresent(Animation animation) {
        if (animation == null) {
            return null;
        }
        EmoteHolder fast = EmoteHolder.getEmoteFromUuid(animation.uuid());
        if (fast != null && fast.emote != null && fast.emote.equals((Object)animation)) {
            return fast;
        }
        for (EmoteHolder holder : list) {
            if (holder.emote == null || !holder.emote.equals((Object)animation)) continue;
            return holder;
        }
        return null;
    }

    public static void addEmoteToList(Iterable<Animation> emotes, @Nullable INetworkInstance fromInstance) {
        for (Animation emote : emotes) {
            EmoteHolder.addEmoteToList(emote, fromInstance);
        }
    }

    public static EmoteHolder addEmoteToList(Animation emote, @Nullable INetworkInstance fromInstance) {
        EmoteHolder old = EmoteHolder.findIfPresent(emote);
        if (old != null) {
            return old;
        }
        EmoteHolder newEmote = new EmoteHolder(emote);
        newEmote.fromInstance = fromInstance;
        list.add(newEmote);
        return newEmote;
    }

    public static boolean playEmote(AbstractClientPlayer player, Animation emote) {
        return EmoteHolder.canPlayEmote(player) && ClientEmotePlay.clientStartLocalEmote(emote);
    }

    private static boolean canPlayEmote(AbstractClientPlayer entity) {
        if (!EmoteHolder.canRunEmote(entity)) {
            return false;
        }
        return entity.isMainAvatar();
    }

    public static boolean canRunEmote(AbstractClientPlayer player) {
        return !(new Vec3(player.getX(), player.getY(), player.getZ()).distanceTo(new Vec3(player.xo, Mth.lerp((double)PlatformTools.getConfig().yRatio.get().floatValue(), (double)player.yo, (double)player.getY()), player.zo)) > (double)PlatformTools.getConfig().stopThreshold.get().floatValue());
    }

    public boolean playEmote() {
        return EmoteHolder.playEmote((AbstractClientPlayer)ClientUtil.getClientPlayer(), this.emote);
    }

    public int hashCode() {
        if (this.hash == null) {
            this.hash = new AtomicInteger(this.emote.hashCode());
        }
        return this.hash.get();
    }

    public UUID getUuid() {
        return this.emote.uuid();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof EmoteHolder)) return false;
        EmoteHolder other = (EmoteHolder)o;
        if (!this.emote.equals((Object)other.emote)) return false;
        return true;
    }

    @Override
    public UUID get() {
        return this.emote.get();
    }

    public static void handleKeyPress(InputConstants.Key key) {
        EmoteHolder emoteHolder;
        UUID uuid;
        if (EmoteHolder.canRunEmote((AbstractClientPlayer)ClientUtil.getClientPlayer()) && (uuid = PlatformTools.getConfig().emoteKeyMap.getL(key)) != null && (emoteHolder = (EmoteHolder)list.get(uuid)) != null) {
            emoteHolder.playEmote();
        }
    }

    public static EmoteHolder getNonNull(@NotNull UUID emote) {
        EmoteHolder emoteHolder = (EmoteHolder)list.get(emote);
        if (emoteHolder == null) {
            return new Empty(emote);
        }
        return emoteHolder;
    }

    public static class Empty
    extends EmoteHolder {
        public Empty(UUID uuid) {
            super(new Animation(new ExtraAnimationData("name", (Object)"{\"color\":\"red\",\"text\":\"INVALID\"}"), 0.0f, Animation.LoopType.PLAY_ONCE, Collections.emptyMap(), UniversalAnimLoader.NO_KEYFRAMES, new HashMap(), new HashMap()));
            this.emote.data().put("uuid", (Object)uuid);
        }
    }
}

