/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.nbsplayer;

import io.github.kosmx.emotes.common.network.CommonNetwork;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Map;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.nbs.NbsDefinitions;
import net.raphimc.noteblocklib.format.nbs.model.NbsLayer;
import net.raphimc.noteblocklib.format.nbs.model.NbsNote;
import net.raphimc.noteblocklib.format.nbs.model.NbsSong;
import net.raphimc.noteblocklib.model.Note;

@Deprecated
public class LegacyNBSPacket {
    public static void write(NbsSong song, ByteBuf buf) {
        buf.writeInt(1);
        buf.writeByte(0);
        buf.writeByte((int)((byte)song.getVanillaInstrumentCount()));
        buf.writeShort((int)song.getTempo());
        buf.writeByte((int)song.getTimeSignature());
        CommonNetwork.writeBoolean(buf, song.isLoop());
        buf.writeByte((int)song.getMaxLoopCount());
        buf.writeShort((int)song.getLoopStartTick());
        buf.writeShort((int)((short)song.getLayers().size()));
        LegacyNBSPacket.writeLayersAndNotes(song, buf);
    }

    private static void writeLayersAndNotes(NbsSong song, ByteBuf buf) {
        for (Map.Entry<Integer, NbsLayer> layerEntry : song.getLayers().entrySet()) {
            NbsLayer layer = layerEntry.getValue();
            buf.writeByte((int)layer.getVolume());
            buf.writeByte((int)((byte)layer.getPanning()));
            int tick = -1;
            for (Map.Entry<Integer, NbsNote> noteEntry : layer.getNotes().entrySet()) {
                NbsNote note = noteEntry.getValue();
                buf.writeShort((int)((short)(noteEntry.getKey() - tick)));
                tick = noteEntry.getKey();
                buf.writeByte((int)((byte)note.getInstrument()));
                buf.writeByte((int)note.getKey());
                buf.writeByte((int)note.getVelocity());
                buf.writeByte((int)((byte)note.getPanning()));
                buf.writeShort((int)note.getPitch());
            }
            buf.writeShort(0);
        }
    }

    public static NbsSong read(ByteBuf buf) throws IOException {
        buf.readInt();
        buf.readByte();
        NbsSong builder = new NbsSong();
        builder.setVersion((byte)5);
        builder.setVanillaInstrumentCount(buf.readByte());
        builder.setTempo(buf.readShort());
        builder.setTimeSignature(buf.readByte());
        builder.setLoop(CommonNetwork.readBoolean(buf));
        builder.setMaxLoopCount(buf.readByte());
        builder.setLoopStartTick(buf.readShort());
        builder.setLayerCount(buf.readShort());
        LegacyNBSPacket.readLayersAndNotes(builder, buf);
        return builder;
    }

    private static void readLayersAndNotes(NbsSong song, ByteBuf buf) {
        Object note;
        Map<Integer, NbsLayer> layers = song.getLayers();
        if (song.getLayerCount() != layers.size()) {
            if (!layers.isEmpty()) {
                return;
            }
            for (int i = 0; i < song.getLayerCount(); ++i) {
                layers.put(i, new NbsLayer());
            }
        }
        int length = 0;
        for (Map.Entry<Integer, NbsLayer> layerEntry : layers.entrySet()) {
            NbsLayer layer = layerEntry.getValue();
            layer.setVolume(buf.readByte());
            layer.setPanning(buf.readByte());
            int tick = -1;
            short step = buf.readShort();
            while (step != 0) {
                tick += step;
                note = new NbsNote();
                ((NbsNote)note).setInstrument(buf.readByte());
                ((NbsNote)note).setKey(buf.readByte());
                ((NbsNote)note).setVelocity(buf.readByte());
                ((NbsNote)note).setPanning(buf.readByte());
                ((NbsNote)note).setPitch(buf.readShort());
                layer.getNotes().put(tick, (NbsNote)note);
                length = Math.max(length, tick);
                step = buf.readShort();
            }
        }
        song.setLength((short)length);
        song.getTempoEvents().set(0, (float)song.getTempo() / 100.0f);
        for (NbsLayer layer : layers.values()) {
            for (Map.Entry<Integer, NbsNote> noteEntry : layer.getNotes().entrySet()) {
                NbsNote nbsNote = noteEntry.getValue();
                note = new Note();
                ((Note)note).setNbsKey((float)NbsDefinitions.getEffectivePitch(nbsNote) / 100.0f);
                ((Note)note).setVolume((float)layer.getVolume() / 100.0f * ((float)nbsNote.getVelocity() / 100.0f));
                if (layer.getPanning() == 100) {
                    ((Note)note).setPanning((float)(nbsNote.getPanning() - 100) / 100.0f);
                } else {
                    ((Note)note).setPanning((float)(layer.getPanning() - 100 + (nbsNote.getPanning() - 100)) / 200.0f);
                }
                if (nbsNote.getInstrument() < song.getVanillaInstrumentCount()) {
                    ((Note)note).setInstrument(MinecraftInstrument.fromNbsId((byte)nbsNote.getInstrument()));
                }
                song.getNotes().add((int)noteEntry.getKey(), (Note)note);
            }
        }
    }
}

