/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network.objects;

import io.github.kosmx.emotes.common.nbsplayer.LegacyNBSPacket;
import io.github.kosmx.emotes.common.network.objects.AbstractNetworkPacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.raphimc.noteblocklib.NoteBlockLib;
import net.raphimc.noteblocklib.format.SongFormat;
import net.raphimc.noteblocklib.format.nbs.model.NbsSong;
import net.raphimc.noteblocklib.model.Song;

public class SongPacket
extends AbstractNetworkPacket {
    @Override
    public byte getID() {
        return 3;
    }

    @Override
    public byte getVer() {
        return 2;
    }

    @Override
    public void read(ByteBuf buf, NetData config, byte version) throws IOException {
        NbsSong song = switch (version) {
            case 2 -> {
                Song var5_6;
                ByteBufInputStream is = new ByteBufInputStream(buf);
                try {
                    var5_6 = NoteBlockLib.readSong((InputStream)is, SongFormat.NBS);
                }
                catch (Throwable var7_7) {
                    try {
                        try {
                            is.close();
                        }
                        catch (Throwable var8_8) {
                            var7_7.addSuppressed(var8_8);
                        }
                        throw var7_7;
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
                is.close();
                yield var5_6;
            }
            case 1 -> {
                Song var5_6;
                yield var5_6 = LegacyNBSPacket.read(buf);
            }
            default -> {
                Song var5_6;
                yield var5_6 = null;
            }
        };
        config.extraData.put("song", song);
    }

    @Override
    public void write(ByteBuf buf, NetData config, byte version) throws IOException {
        block9: {
            assert (config.emoteData != null);
            Song song = (Song)config.emoteData.data().getRaw("song");
            if (version > 1) {
                try (ByteBufOutputStream os = new ByteBufOutputStream(buf);){
                    NoteBlockLib.writeSong(song, (OutputStream)os);
                    break block9;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            LegacyNBSPacket.write((NbsSong)song, buf);
        }
    }

    @Override
    public boolean doWrite(NetData config) {
        return config.versions.get(this.getID()) != 0 && config.emoteData != null && config.emoteData.data().has("song");
    }

    @Override
    public boolean isOptional() {
        return true;
    }
}

