/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.data;

import net.raphimc.noteblocklib.model.instrument.Instrument;

public enum MinecraftInstrument implements Instrument
{
    HARP(0, 0, "block.note_block.harp"),
    BASS(1, 4, "block.note_block.bass"),
    BASS_DRUM(2, 1, "block.note_block.basedrum"),
    SNARE(3, 2, "block.note_block.snare"),
    HAT(4, 3, "block.note_block.hat"),
    GUITAR(5, 7, "block.note_block.guitar"),
    FLUTE(6, 5, "block.note_block.flute"),
    BELL(7, 6, "block.note_block.bell"),
    CHIME(8, 8, "block.note_block.chime"),
    XYLOPHONE(9, 9, "block.note_block.xylophone"),
    IRON_XYLOPHONE(10, 10, "block.note_block.iron_xylophone"),
    COW_BELL(11, 11, "block.note_block.cow_bell"),
    DIDGERIDOO(12, 12, "block.note_block.didgeridoo"),
    BIT(13, 13, "block.note_block.bit"),
    BANJO(14, 14, "block.note_block.banjo"),
    PLING(15, 15, "block.note_block.pling");

    private final byte nbsId;
    private final byte mcId;
    private final String mcSoundName;

    private MinecraftInstrument(int nbsId, int mcId, String mcSoundName) {
        this.nbsId = (byte)nbsId;
        this.mcId = (byte)mcId;
        this.mcSoundName = mcSoundName;
    }

    public static MinecraftInstrument fromNbsId(byte nbsId) {
        for (MinecraftInstrument instrument : MinecraftInstrument.values()) {
            if (instrument.nbsId != nbsId) continue;
            return instrument;
        }
        return null;
    }

    public static MinecraftInstrument fromMcId(byte mcId) {
        for (MinecraftInstrument instrument : MinecraftInstrument.values()) {
            if (instrument.mcId != mcId) continue;
            return instrument;
        }
        return null;
    }

    public static MinecraftInstrument fromMcSoundName(String mcSoundName) {
        for (MinecraftInstrument instrument : MinecraftInstrument.values()) {
            if (!instrument.mcSoundName.equals(mcSoundName)) continue;
            return instrument;
        }
        return null;
    }

    public byte nbsId() {
        return this.nbsId;
    }

    public byte mcId() {
        return this.mcId;
    }

    public String mcSoundName() {
        return this.mcSoundName;
    }

    @Override
    public MinecraftInstrument copy() {
        return this;
    }
}

