/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimcore.loading;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.Expression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.FloatExpression;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.ExtraAnimationData;
import com.zigythebird.playeranimcore.animation.keyframe.BoneAnimation;
import com.zigythebird.playeranimcore.animation.keyframe.Keyframe;
import com.zigythebird.playeranimcore.animation.keyframe.KeyframeStack;
import com.zigythebird.playeranimcore.easing.EasingType;
import com.zigythebird.playeranimcore.enums.TransformType;
import com.zigythebird.playeranimcore.loading.UniversalAnimLoader;
import com.zigythebird.playeranimcore.math.Vec3f;
import com.zigythebird.playeranimcore.molang.MolangLoader;
import com.zigythebird.playeranimcore.util.JsonUtil;
import it.unimi.dsi.fastutil.floats.FloatObjectPair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnimationLoader
implements JsonDeserializer<Animation> {
    private static final List<List<Expression>> ZERO_ARRAY;
    private static final List<List<Expression>> ZERO_POINT_ONE_ARRAY;
    private static final List<List<Expression>> MINUS_ZERO_POINT_ONE_ARRAY;

    public Animation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject animationObj = json.getAsJsonObject();
        float length = animationObj.has("animation_length") ? JsonUtil.getAsFloat(animationObj, "animation_length") * 20.0f : -1.0f;
        Map<String, BoneAnimation> boneAnimations = AnimationLoader.bakeBoneAnimations(JsonUtil.getAsJsonObject(animationObj, "bones", new JsonObject()));
        if (length == -1.0f) {
            length = AnimationLoader.calculateAnimationLength(boneAnimations);
        }
        Animation.LoopType loopType = AnimationLoader.readLoopType(animationObj, length);
        Animation.Keyframes keyframes = (Animation.Keyframes)context.deserialize((JsonElement)animationObj, Animation.Keyframes.class);
        Map<String, String> parents = UniversalAnimLoader.getParents(JsonUtil.getAsJsonObject(animationObj, "parents", new JsonObject()));
        Map<String, Vec3f> bones = UniversalAnimLoader.getModel(JsonUtil.getAsJsonObject(animationObj, "model", new JsonObject()));
        ExtraAnimationData extraData = new ExtraAnimationData();
        if (animationObj.has("player_animation_library")) {
            extraData.fromJson(animationObj.getAsJsonObject("player_animation_library"), false);
        }
        return new Animation(extraData, length, loopType, boneAnimations, keyframes, bones, parents);
    }

    private static Animation.LoopType readLoopType(JsonObject animationObj, float length) throws JsonParseException {
        if (animationObj.has("loopTick")) {
            float returnTick = JsonUtil.getAsFloat(animationObj, "loopTick") * 20.0f;
            if (returnTick > length || returnTick < 0.0f) {
                throw new JsonParseException("The returnTick has to be a non-negative value smaller than the endTick value");
            }
            return Animation.LoopType.returnToTickLoop(returnTick);
        }
        return Animation.LoopType.fromJson(animationObj.get("loop"));
    }

    private static Map<String, BoneAnimation> bakeBoneAnimations(JsonObject bonesObj) {
        HashMap<String, BoneAnimation> animations = new HashMap<String, BoneAnimation>(bonesObj.size());
        for (Map.Entry entry : bonesObj.entrySet()) {
            JsonObject entryObj = ((JsonElement)entry.getValue()).getAsJsonObject();
            KeyframeStack scaleFrames = AnimationLoader.buildKeyframeStack(AnimationLoader.getKeyframes(entryObj.get("scale")), TransformType.SCALE);
            KeyframeStack positionFrames = AnimationLoader.buildKeyframeStack(AnimationLoader.getKeyframes(entryObj.get("position")), TransformType.POSITION);
            KeyframeStack rotationFrames = AnimationLoader.buildKeyframeStack(AnimationLoader.getKeyframes(entryObj.get("rotation")), TransformType.ROTATION);
            KeyframeStack bendFrames = AnimationLoader.buildKeyframeStack(AnimationLoader.getKeyframes(entryObj.get("bend")), TransformType.BEND);
            animations.put(UniversalAnimLoader.getCorrectPlayerBoneName((String)entry.getKey()), new BoneAnimation(rotationFrames, positionFrames, scaleFrames, bendFrames.xKeyframes()));
        }
        return animations;
    }

    private static List<FloatObjectPair<JsonElement>> getKeyframes(JsonElement element) {
        if (element == null) {
            return List.of();
        }
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            JsonArray array = new JsonArray(3);
            array.add((JsonElement)primitive);
            array.add((JsonElement)primitive);
            array.add((JsonElement)primitive);
            element = array;
        }
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            return ObjectArrayList.of((Object[])new FloatObjectPair[]{FloatObjectPair.of((float)0.0f, (Object)array)});
        }
        if (element instanceof JsonObject) {
            JsonObject obj = (JsonObject)element;
            if (obj.has("vector")) {
                return ObjectArrayList.of((Object[])new FloatObjectPair[]{FloatObjectPair.of((float)0.0f, (Object)obj)});
            }
            ObjectArrayList list = new ObjectArrayList();
            for (Map.Entry entry : obj.entrySet()) {
                JsonObject entryObj;
                float timestamp = AnimationLoader.readTimestamp((String)entry.getKey());
                if (timestamp == 0.0f && !list.isEmpty()) {
                    throw new JsonParseException("Invalid keyframe data - multiple starting keyframes?" + (String)entry.getKey());
                }
                Object v = entry.getValue();
                if (v instanceof JsonObject && !(entryObj = (JsonObject)v).has("vector")) {
                    AnimationLoader.addBedrockKeyframes(timestamp, entryObj, (List<FloatObjectPair<JsonElement>>)list);
                    continue;
                }
                list.add(FloatObjectPair.of((float)timestamp, (Object)((JsonElement)entry.getValue())));
            }
            return list;
        }
        throw new JsonParseException("Invalid object type provided to getTripletObj, got: " + String.valueOf(element));
    }

    private static JsonArray extractBedrockKeyframe(JsonElement keyframe) {
        if (keyframe.isJsonArray()) {
            return keyframe.getAsJsonArray();
        }
        if (!keyframe.isJsonObject()) {
            throw new JsonParseException("Invalid keyframe data - expected array or object, found " + String.valueOf(keyframe));
        }
        JsonObject keyframeObj = keyframe.getAsJsonObject();
        if (keyframeObj.has("vector")) {
            return keyframeObj.get("vector").getAsJsonArray();
        }
        if (keyframeObj.has("pre")) {
            return keyframeObj.get("pre").getAsJsonArray();
        }
        return keyframeObj.get("post").getAsJsonArray();
    }

    private static void addBedrockKeyframes(float timestamp, JsonObject keyframe, List<FloatObjectPair<JsonElement>> keyframes) {
        boolean addedFrame = false;
        if (keyframe.has("pre")) {
            addedFrame = true;
            JsonArray value = AnimationLoader.extractBedrockKeyframe(keyframe.get("pre"));
            JsonObject result = null;
            if (keyframe.has("easing")) {
                result = new JsonObject();
                result.add("vector", (JsonElement)value);
                result.add("easing", keyframe.get("easing"));
                if (keyframe.has("easingArgs")) {
                    result.add("easingArgs", keyframe.get("easingArgs"));
                }
            }
            keyframes.add((FloatObjectPair<JsonElement>)FloatObjectPair.of((float)(timestamp == 0.0f ? timestamp : timestamp - 0.001f), (Object)(result != null ? result : value)));
        }
        if (keyframe.has("post")) {
            JsonArray values = AnimationLoader.extractBedrockKeyframe(keyframe.get("post"));
            if (keyframe.has("lerp_mode")) {
                JsonObject keyframeObj = new JsonObject();
                keyframeObj.add("vector", (JsonElement)values);
                keyframeObj.add("easing", keyframe.get("lerp_mode"));
                keyframes.add((FloatObjectPair<JsonElement>)FloatObjectPair.of((float)timestamp, (Object)keyframeObj));
            } else {
                keyframes.add((FloatObjectPair<JsonElement>)FloatObjectPair.of((float)timestamp, (Object)values));
            }
            return;
        }
        if (!addedFrame) {
            throw new JsonParseException("Invalid keyframe data - expected array, found " + String.valueOf(keyframe));
        }
    }

    private static KeyframeStack buildKeyframeStack(List<FloatObjectPair<JsonElement>> entries, TransformType type) {
        if (entries.isEmpty()) {
            return new KeyframeStack();
        }
        ObjectArrayList xFrames = new ObjectArrayList();
        ObjectArrayList yFrames = new ObjectArrayList();
        ObjectArrayList zFrames = new ObjectArrayList();
        List<Expression> xPrev = null;
        List<Expression> yPrev = null;
        List<Expression> zPrev = null;
        FloatObjectPair<JsonElement> prevEntry = null;
        for (FloatObjectPair<JsonElement> entry : entries) {
            JsonObject obj;
            JsonArray array;
            JsonElement element = (JsonElement)entry.right();
            float prevTime = prevEntry != null ? prevEntry.leftFloat() : 0.0f;
            float curTime = entry.leftFloat();
            float timeDelta = curTime - prevTime;
            boolean isForRotation = type == TransformType.ROTATION || type == TransformType.BEND;
            FloatExpression defaultValue = type == TransformType.SCALE ? FloatExpression.ONE : FloatExpression.ZERO;
            JsonArray keyFrameVector = element instanceof JsonArray ? (array = (JsonArray)element) : JsonUtil.getAsJsonArray(element.getAsJsonObject(), "vector");
            List<Expression> xValue = MolangLoader.parseJson(isForRotation, keyFrameVector.get(0), defaultValue);
            List<Expression> yValue = MolangLoader.parseJson(isForRotation, keyFrameVector.get(1), defaultValue);
            List<Expression> zValue = MolangLoader.parseJson(isForRotation, keyFrameVector.get(2), defaultValue);
            JsonObject entryObj = element instanceof JsonObject ? (obj = (JsonObject)element) : null;
            EasingType easingType = entryObj != null && entryObj.has("easing") ? EasingType.fromJson(entryObj.get("easing")) : EasingType.LINEAR;
            ObjectArrayList easingArgs = entryObj != null && entryObj.has("easingArgs") ? JsonUtil.jsonArrayToList(JsonUtil.getAsJsonArray(entryObj, "easingArgs"), ele -> Collections.singletonList(FloatExpression.of(ele.getAsFloat()))) : new ObjectArrayList();
            boolean isBezier = EasingType.BEZIER == easingType;
            List<List<Expression>> leftValues = null;
            List<List<Expression>> rightValues = null;
            List<List<Expression>> leftTimes = null;
            List<List<Expression>> rightTimes = null;
            if (isBezier) {
                leftValues = entryObj.has("left") ? JsonUtil.jsonArrayToList(JsonUtil.getAsJsonArray(entryObj, "left"), ele -> Collections.singletonList(FloatExpression.of(ele.getAsDouble()))) : ZERO_ARRAY;
                rightValues = entryObj.has("right") ? JsonUtil.jsonArrayToList(JsonUtil.getAsJsonArray(entryObj, "right"), ele -> Collections.singletonList(FloatExpression.of(ele.getAsDouble()))) : ZERO_ARRAY;
                leftTimes = entryObj.has("left_time") ? JsonUtil.jsonArrayToList(JsonUtil.getAsJsonArray(entryObj, "left_time"), ele -> Collections.singletonList(FloatExpression.of(ele.getAsDouble()))) : MINUS_ZERO_POINT_ONE_ARRAY;
                rightTimes = entryObj.has("right_time") ? JsonUtil.jsonArrayToList(JsonUtil.getAsJsonArray(entryObj, "right_time"), ele -> Collections.singletonList(FloatExpression.of(ele.getAsDouble()))) : ZERO_POINT_ONE_ARRAY;
            }
            xFrames.add(new Keyframe(timeDelta * 20.0f, prevEntry == null ? xValue : xPrev, xValue, easingType, (List<List<Expression>>)(isBezier ? ObjectArrayList.of((Object[])new List[]{leftValues.get(0), leftTimes.get(0), rightValues.get(0), rightTimes.get(0)}) : easingArgs)));
            yFrames.add(new Keyframe(timeDelta * 20.0f, prevEntry == null ? yValue : yPrev, yValue, easingType, (List<List<Expression>>)(isBezier ? ObjectArrayList.of((Object[])new List[]{leftValues.get(1), leftTimes.get(1), rightValues.get(1), rightTimes.get(1)}) : easingArgs)));
            zFrames.add(new Keyframe(timeDelta * 20.0f, prevEntry == null ? zValue : zPrev, zValue, easingType, (List<List<Expression>>)(isBezier ? ObjectArrayList.of((Object[])new List[]{leftValues.get(2), leftTimes.get(2), rightValues.get(2), rightTimes.get(2)}) : easingArgs)));
            xPrev = xValue;
            yPrev = yValue;
            zPrev = zValue;
            prevEntry = entry;
        }
        return new KeyframeStack(AnimationLoader.addArgsForKeyframes((List<Keyframe>)xFrames), AnimationLoader.addArgsForKeyframes((List<Keyframe>)yFrames), AnimationLoader.addArgsForKeyframes((List<Keyframe>)zFrames));
    }

    private static List<Keyframe> addArgsForKeyframes(List<Keyframe> frames) {
        Keyframe frame;
        if (frames.size() == 1 && (frame = frames.getFirst()).easingType() != EasingType.LINEAR) {
            frames.set(0, new Keyframe(frame.length(), frame.startValue(), frame.endValue()));
            return frames;
        }
        for (int i = 0; i < frames.size(); ++i) {
            Keyframe frame2 = frames.get(i);
            if (frame2.easingType() == EasingType.CATMULLROM) {
                frames.set(i, new Keyframe(frame2.length(), frame2.startValue(), frame2.endValue(), frame2.easingType(), (List<List<Expression>>)ObjectArrayList.of((Object[])new List[]{i == 0 ? frame2.startValue() : frames.get(i - 1).endValue(), i + 1 >= frames.size() ? frame2.endValue() : frames.get(i + 1).endValue()})));
                continue;
            }
            if (frame2.easingType() != EasingType.BEZIER) continue;
            List<Expression> rightValue = frame2.easingArgs().get(2);
            List<Expression> rightTime = frame2.easingArgs().get(3);
            frame2.easingArgs().remove(2);
            frame2.easingArgs().remove(2);
            if (frames.size() <= i + 1) continue;
            Keyframe nextKeyframe = frames.get(i + 1);
            if (nextKeyframe.easingType() == EasingType.BEZIER) {
                nextKeyframe.easingArgs().add(rightValue);
                nextKeyframe.easingArgs().add(rightTime);
                continue;
            }
            frames.set(i + 1, new Keyframe(nextKeyframe.length(), nextKeyframe.startValue(), nextKeyframe.endValue(), EasingType.BEZIER_AFTER, (List<List<Expression>>)ObjectArrayList.of((Object[])new List[]{rightValue, rightTime})));
        }
        return frames;
    }

    public static float calculateAnimationLength(Map<String, BoneAnimation> boneAnimations) {
        float length = 0.0f;
        for (BoneAnimation animation : boneAnimations.values()) {
            length = Math.max(length, animation.rotationKeyFrames().getLastKeyframeTime());
            length = Math.max(length, animation.positionKeyFrames().getLastKeyframeTime());
            length = Math.max(length, animation.scaleKeyFrames().getLastKeyframeTime());
        }
        return length == 0.0f ? Float.MAX_VALUE : length;
    }

    private static float readTimestamp(String timestamp) {
        try {
            return Float.parseFloat(timestamp);
        }
        catch (Throwable th) {
            return 0.0f;
        }
    }

    static {
        List<FloatExpression> ZERO = Collections.singletonList(FloatExpression.of(0.0f));
        List<FloatExpression> ZERO_POINT_ONE = Collections.singletonList(FloatExpression.of(0.1));
        List<FloatExpression> MINUS_ZERO_POINT_ONE = Collections.singletonList(FloatExpression.of(-0.1));
        ZERO_ARRAY = ObjectArrayList.of((Object[])new List[]{ZERO, ZERO, ZERO});
        ZERO_POINT_ONE_ARRAY = ObjectArrayList.of((Object[])new List[]{ZERO_POINT_ONE, ZERO_POINT_ONE, ZERO_POINT_ONE});
        MINUS_ZERO_POINT_ONE_ARRAY = ObjectArrayList.of((Object[])new List[]{MINUS_ZERO_POINT_ONE, MINUS_ZERO_POINT_ONE, MINUS_ZERO_POINT_ONE});
    }
}

