/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network;

import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import java.util.function.Consumer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.network.ConfigurationTask;
import org.jetbrains.annotations.NotNull;

public class ConfigTask
implements ConfigurationTask {
    public static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type("emotes:config");

    public void start(@NotNull Consumer<Packet<?>> consumer) {
        NetData configData = new EmotePacket.Builder().configureToConfigExchange().build().data;
        configData.versions.put((byte)-128, (byte)1);
        try {
            EmotePacket packet = new EmotePacket.Builder(configData).build();
            consumer.accept(NetworkPlatformTools.playPacket(packet));
        }
        catch (Throwable e) {
            CommonData.LOGGER.warn("Failed to configure client!", e);
        }
    }

    @NotNull
    public ConfigurationTask.Type type() {
        return TYPE;
    }
}

