/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.emotePlay.instances;

import io.github.kosmx.emotes.main.emotePlay.instances.EmotecraftSoundEvents;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.SampledFloat;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoundDirectInstance
implements SoundInstance {
    private static final FloatProvider DEFAULT_FLOAT = ConstantFloat.of((float)1.0f);
    protected final Sound sound;
    protected final float volume;
    protected final float pitch;
    protected final Vec3 pos;

    public SoundDirectInstance(Identifier sound, float volume, float pitch, Vec3 pos) {
        this(new Sound(sound, (SampledFloat)DEFAULT_FLOAT, (SampledFloat)DEFAULT_FLOAT, 1, Sound.Type.FILE, false, false, 16), volume, pitch, pos);
    }

    public SoundDirectInstance(Sound sound, float volume, float pitch, Vec3 pos) {
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.pos = pos;
    }

    @NotNull
    public Identifier getIdentifier() {
        return this.sound.getLocation();
    }

    @Nullable
    public WeighedSoundEvents resolve(SoundManager manager) {
        return new EmotecraftSoundEvents(this.sound);
    }

    @NotNull
    public Sound getSound() {
        return this.sound;
    }

    @NotNull
    public SoundSource getSource() {
        return SoundSource.PLAYERS;
    }

    public boolean isLooping() {
        return false;
    }

    public boolean isRelative() {
        return false;
    }

    public int getDelay() {
        return 0;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public double getX() {
        return this.pos.x() + 0.5;
    }

    public double getY() {
        return this.pos.y() + 0.5;
    }

    public double getZ() {
        return this.pos.z() + 0.5;
    }

    @NotNull
    public SoundInstance.Attenuation getAttenuation() {
        return SoundInstance.Attenuation.LINEAR;
    }
}

