/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.gui.widgets;

import com.mojang.blaze3d.opengl.GlStateManager;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.gui.widgets.search.ISearchEngine;
import io.github.kosmx.emotes.arch.gui.widgets.search.VanillaSearch;
import io.github.kosmx.emotes.arch.screen.utils.BageUtils;
import io.github.kosmx.emotes.arch.screen.utils.PageButton;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.mc.McUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_10799;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3675;
import net.minecraft.class_4280;
import net.minecraft.class_513;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8132;
import net.minecraft.class_9848;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmoteListWidget
extends class_4280<ListEntry> {
    private static final List<class_2561> LAST_OPENED_PATH = new CopyOnWriteArrayList<class_2561>();
    private final FolderEntry mainFolder = new FolderEntry((class_2561)class_2561.method_43471((String)"emotecraft.folder.main"));
    private FolderEntry lastClickedFolder;
    private boolean compactMode;
    private final PageButton backButton = new PageButton(20, 20, class_513.field_45553, true, button -> {
        this.setLastFolder(null);
        if (this.lastClickedFolder == null) {
            this.method_44382(0.0);
        } else {
            this.method_25324((class_350.class_351)this.lastClickedFolder);
        }
    });

    public EmoteListWidget(class_310 minecraft, int width, int height, int y, int itemHeight) {
        super(minecraft, width, height, y, itemHeight);
        this.field_22744 = false;
        this.backButton.field_22763 = false;
    }

    public int method_25322() {
        if (this.compactMode) {
            return this.field_22758;
        }
        return this.field_22758 / 2;
    }

    protected int method_65507() {
        if (!this.compactMode) {
            return super.method_65507();
        }
        return this.method_46426() + this.method_25322() - 6;
    }

    protected void renderSelection(class_332 guiGraphics, ListEntry entry, int outerColor) {
        if (this.compactMode && this.method_44392()) {
            int j = entry.method_46426();
            int k = entry.method_46427();
            int l = j + entry.method_25368() - 8;
            int m = k + entry.method_25364();
            guiGraphics.method_25294(j, k, l, m, outerColor);
            guiGraphics.method_25294(j + 1, k + 1, l - 1, m - 1, -16777216);
        } else {
            super.method_44398(guiGraphics, (class_350.class_351)entry, outerColor);
        }
    }

    protected void renderItem(class_332 guiGraphics, int i, int j, float f, ListEntry entry) {
        try {
            super.method_44397(guiGraphics, i, j, f, (class_350.class_351)entry);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setEmotes(Iterable<EmoteHolder> list, boolean showInvalid) {
        class_2561 folderName;
        ListEntry child;
        this.mainFolder.entries.clear();
        for (EmoteHolder emoteHolder : list) {
            if (emoteHolder.folder.isEmpty()) {
                this.mainFolder.entries.put(emoteHolder.name, new EmoteEntry(emoteHolder));
                continue;
            }
            this.createFoldersTree(emoteHolder.folder).entries.put(emoteHolder.name, new EmoteEntry(emoteHolder));
        }
        if (showInvalid) {
            for (EmoteHolder emoteHolder : this.getEmptyEmotes()) {
                this.mainFolder.entries.put(emoteHolder.name, new EmoteEntry(emoteHolder));
            }
        }
        this.filter(VanillaSearch.INSTANCE, false, "");
        Iterator<EmoteHolder> iterator = LAST_OPENED_PATH.iterator();
        while (iterator.hasNext() && (child = Objects.requireNonNullElse(this.lastClickedFolder, this.mainFolder).entries.get(folderName = (class_2561)iterator.next())) instanceof FolderEntry) {
            FolderEntry folder;
            this.lastClickedFolder = folder = (FolderEntry)child;
            this.setLastFolder(folder);
        }
    }

    public void filter(ISearchEngine engine, boolean isSearchActive, String search) {
        this.method_25339();
        this.method_73370((class_350.class_351)new HeaderEntry(), 13);
        this.setSelected(null);
        engine.filter(this.getEmotes(isSearchActive).stream(), search).forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        this.method_65506();
    }

    public FolderEntry createFoldersTree(List<class_2561> folders) {
        FolderEntry last = this.mainFolder;
        for (class_2561 folder : folders) {
            last = last.getOrCreateFolder(folder);
        }
        return last;
    }

    public Iterable<EmoteHolder> getEmptyEmotes() {
        LinkedList<EmoteHolder> empties = new LinkedList<EmoteHolder>();
        for (Pair<UUID, class_3675.class_306> pair : PlatformTools.getConfig().emoteKeyMap) {
            if (EmoteHolder.list.containsKey(pair.left())) continue;
            empties.add(new EmoteHolder.Empty((UUID)pair.left()));
        }
        return empties;
    }

    public List<ListEntry> getEmotes(boolean isSearchActive) {
        ArrayList<ListEntry> emotes = new ArrayList<ListEntry>();
        this.mainFolder.collectEmotes(isSearchActive, emotes);
        emotes.sort(ListEntry::compareTo);
        return Collections.unmodifiableList(emotes);
    }

    public void method_57712(int width, class_8132 layout) {
        super.method_57712(width, layout);
        if (this.compactMode) {
            layout.method_48222();
            this.method_65506();
        }
    }

    public void method_73369(int width, int height, int x, int y) {
        super.method_73369(this.compactMode ? width / 3 : width, height, x, y);
    }

    @Nullable
    public EmoteHolder getFocusedEmote() {
        class_350.class_351 class_3512 = this.method_25336();
        if (class_3512 instanceof EmoteEntry) {
            EmoteEntry emote = (EmoteEntry)class_3512;
            return emote.getEmote();
        }
        return null;
    }

    @Nullable
    public ListEntry getHovered() {
        return (ListEntry)super.method_37019();
    }

    public void setSelected(@Nullable ListEntry selected) {
        super.method_25313((class_350.class_351)selected);
        if (selected instanceof FolderEntry) {
            FolderEntry folder;
            this.lastClickedFolder = folder = (FolderEntry)selected;
            this.setLastFolder(folder);
        }
    }

    public boolean setLastFolder(FolderEntry folder) {
        if (this.mainFolder.setLastFolder(folder)) {
            this.backButton.field_22763 = this.mainFolder.next != null;
            LAST_OPENED_PATH.clear();
            EmoteListWidget.updateLastOpenedPath(this.mainFolder.next);
            return true;
        }
        return false;
    }

    public void setCompactMode(boolean compactMode) {
        this.compactMode = compactMode;
    }

    public static class_5250 appendScreenPath(FolderEntry folder, class_5250 component) {
        component = component.method_10852(McUtils.SLASH).method_10852(class_5244.field_41874);
        if (folder.next != null) {
            return EmoteListWidget.appendScreenPath(folder.next, component.method_10852(folder.name).method_10852(class_5244.field_41874));
        }
        return component.method_10852((class_2561)folder.name.method_27661().method_27694(style -> style.method_10982(Boolean.valueOf(true))));
    }

    private static void updateLastOpenedPath(@Nullable FolderEntry folder) {
        if (folder == null) {
            return;
        }
        LAST_OPENED_PATH.add(folder.name);
        if (folder.next != null) {
            EmoteListWidget.updateLastOpenedPath(folder.next);
        }
    }

    public PageButton createBackButton() {
        return this.backButton;
    }

    public class FolderEntry
    extends ListEntry {
        public static final class_2960 FOLDER = McUtils.newIdentifier("textures/folder.png");
        public static final class_2960 FOLDER_OPEN = McUtils.newIdentifier("textures/folder_open.png");
        public static final class_2561 FOLDER_DESC = class_2561.method_43471((String)"emotecraft.folder");
        private final Map<class_2561, ListEntry> entries;
        private FolderEntry next;

        public FolderEntry(class_2561 name) {
            super(name, FOLDER_DESC, Collections.emptyList());
            this.entries = new HashMap<class_2561, ListEntry>();
        }

        @Override
        public void renderAdditional(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float tickDelta) {
            guiGraphics.method_25290(class_10799.field_56883, hovering ? FOLDER_OPEN : FOLDER, this.method_73380(), this.method_73382(), 0.0f, 0.0f, 32, 32, 32, 32);
        }

        @Override
        protected void collectEmotes(boolean isSearchActive, List<ListEntry> collection) {
            if (this.next == null || !this.entries.containsValue(this.next)) {
                for (ListEntry entry : this.entries.values()) {
                    if (entry instanceof FolderEntry) {
                        FolderEntry folder = (FolderEntry)entry;
                        boolean isInvalid = StringUtils.isBlank((CharSequence)this.name.getString());
                        if (!isInvalid) {
                            collection.add(folder);
                        }
                        if (!isSearchActive && !isInvalid) continue;
                        for (ListEntry folderEntry : folder.entries.values()) {
                            folderEntry.collectEmotes(isSearchActive, collection);
                        }
                        continue;
                    }
                    entry.collectEmotes(isSearchActive, collection);
                }
            } else {
                this.next.collectEmotes(isSearchActive, collection);
            }
        }

        public boolean setLastFolder(FolderEntry folder) {
            if (this.next != null) {
                if (folder == null && this.next.next == null) {
                    this.setSelectedFolder(null);
                    return true;
                }
                return this.next.setLastFolder(folder);
            }
            return this.setSelectedFolder(folder);
        }

        public boolean setSelectedFolder(FolderEntry folder) {
            if (folder == null || this.entries.containsValue(folder)) {
                this.next = folder;
                return true;
            }
            return false;
        }

        public FolderEntry getOrCreateFolder(class_2561 name) {
            return (FolderEntry)this.entries.computeIfAbsent(name, x$0 -> new FolderEntry((class_2561)x$0));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof FolderEntry)) return false;
            FolderEntry entry = (FolderEntry)obj;
            if (!this.name.equals((Object)entry.name)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(@NotNull ListEntry o) {
            if (o instanceof FolderEntry) {
                return super.compareTo(o);
            }
            return -1;
        }
    }

    public abstract class ListEntry
    extends class_4280.class_4281<ListEntry>
    implements Comparable<ListEntry> {
        public final class_2561 name;
        public final class_2561 description;
        public final List<class_2561> bages;

        public ListEntry(class_2561 name, class_2561 description, List<class_2561> bages) {
            this.name = name;
            this.description = description;
            this.bages = bages;
        }

        public void method_25343(class_332 matrices, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int maxX = this.method_73389() - (EmoteListWidget.this.compactMode && EmoteListWidget.this.method_44392() ? 7 : 0);
            matrices.method_44379(this.method_46426() - 1, this.method_46427() - 1, maxX, this.method_46427() + this.method_25364() + 1);
            if (hovered) {
                matrices.method_74037(this.method_25370() ? class_11875.field_62449 : class_11876.field_62455);
                matrices.method_25294(this.method_73380() - 1, this.method_73382() - 1, maxX, this.method_73386() + 1, class_9848.method_61324((int)128, (int)66, (int)66, (int)66));
            }
            int maxBadgesWidth = Math.max(maxX - ((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772.method_27525((class_5348)this.name), maxX / 3) - (this.method_73380() + 31);
            int badgeWidth = BageUtils.drawBadges(matrices, ((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772, this.bages, maxX, this.method_73382(), maxBadgesWidth, true);
            class_327 class_3272 = ((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772;
            int n = this.method_73380() + 31;
            int n2 = this.method_73380() + 31;
            int n3 = this.method_73382();
            int n4 = this.method_73382();
            Objects.requireNonNull(((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772);
            EmoteListWidget.method_49605((class_332)matrices, (class_327)class_3272, (class_2561)this.name, (int)n, (int)n2, (int)n3, (int)(maxX - badgeWidth), (int)(n4 + 9), (int)-1);
            matrices.method_27535(((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772, this.description, this.method_73380() + 31, this.method_73382() + 12, -8355712);
            this.renderAdditional(matrices, mouseX, mouseY, hovered, tickDelta);
            matrices.method_44380();
        }

        public abstract void renderAdditional(class_332 var1, int var2, int var3, boolean var4, float var5);

        @NotNull
        public class_2561 method_37006() {
            return this.name;
        }

        public boolean matches(String string) {
            return this.name.getString().toLowerCase().contains(string.toLowerCase());
        }

        protected abstract void collectEmotes(boolean var1, List<ListEntry> var2);

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        @Override
        public int compareTo(@NotNull ListEntry o) {
            return this.name.getString().compareTo(o.name.getString());
        }
    }

    public class EmoteEntry
    extends ListEntry {
        public final EmoteHolder emote;

        public EmoteEntry(EmoteHolder emote) {
            super(emote.name, emote.description, emote.bages);
            this.emote = emote;
        }

        @Override
        public void renderAdditional(class_332 matrices, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_2960 texture;
            if (!this.emote.author.getString().isEmpty()) {
                class_5250 text = class_2561.method_43471((String)"emotecraft.emote.author").method_27692(class_124.field_1065).method_10852(this.emote.author);
                matrices.method_27535(((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772, (class_2561)text, this.method_73380() + 31, this.method_73382() + 23, -8355712);
            }
            if ((texture = this.emote.getIconIdentifier()) != null) {
                GlStateManager._enableBlend();
                matrices.method_25302(class_10799.field_56883, texture, this.method_73380(), this.method_73382(), 0.0f, 0.0f, 32, 32, 256, 256, 256, 256);
                GlStateManager._disableBlend();
            }
        }

        public EmoteHolder getEmote() {
            return this.emote;
        }

        @Override
        @NotNull
        public class_2561 method_37006() {
            return this.emote.name;
        }

        @Override
        public boolean matches(String string) {
            return super.matches(string) || this.description.getString().toLowerCase().contains(string.toLowerCase()) || this.emote.fileName != null && this.emote.fileName.getString().toLowerCase().contains(string.toLowerCase()) || this.emote.author.getString().equalsIgnoreCase(string);
        }

        @Override
        protected void collectEmotes(boolean excludeFolders, List<ListEntry> collection) {
            collection.add(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof EmoteEntry)) return false;
            EmoteEntry entry = (EmoteEntry)obj;
            if (!this.emote.equals(entry.emote)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.emote.hashCode();
        }

        @Override
        public int compareTo(@NotNull ListEntry o) {
            if (o instanceof EmoteEntry) {
                return super.compareTo(o);
            }
            return 1;
        }
    }

    public class HeaderEntry
    extends ListEntry {
        public HeaderEntry() {
            super(class_5244.field_39003, class_5244.field_39003, Collections.emptyList());
        }

        @Override
        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_5250 path = EmoteListWidget.appendScreenPath(EmoteListWidget.this.mainFolder, class_2561.method_43473());
            if (EmoteListWidget.this.compactMode) {
                class_327 class_3272 = ((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772;
                int n = this.method_73380();
                int n2 = this.method_73380();
                int n3 = this.method_73382();
                int n4 = this.method_73389();
                int n5 = this.method_73382();
                Objects.requireNonNull(((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772);
                EmoteListWidget.method_49605((class_332)guiGraphics, (class_327)class_3272, (class_2561)((class_2561)path), (int)n, (int)n2, (int)n3, (int)n4, (int)(n5 + 9), (int)-1);
            } else {
                class_327 class_3273 = ((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772;
                int n = this.method_73380();
                int n6 = this.method_73382();
                int n7 = this.method_73389();
                int n8 = this.method_73382();
                Objects.requireNonNull(((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772);
                EmoteListWidget.method_52718((class_332)guiGraphics, (class_327)class_3273, (class_2561)((class_2561)path), (int)n, (int)n6, (int)n7, (int)(n8 + 9), (int)-1);
            }
        }

        @Override
        public void renderAdditional(class_332 matrices, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        }

        @Override
        protected void collectEmotes(boolean isSearchActive, List<ListEntry> collection) {
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof HeaderEntry;
        }

        @Override
        public int hashCode() {
            return 984359084;
        }

        @Override
        public int compareTo(@NotNull ListEntry o) {
            return 1;
        }

        @Override
        public boolean matches(String string) {
            return false;
        }
    }
}

