/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.emotePlay;

import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.main.emotePlay.instances.SoundDirectInstance;
import io.github.kosmx.emotes.main.emotePlay.instances.SoundEventInstance;
import java.io.File;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_243;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.nbs.model.NbsCustomInstrument;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.instrument.Instrument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstrumentConventer {
    public static class_1113 getInstrument(Note note, class_243 pos) {
        Instrument noteBlock;
        Instrument instrument = note.getInstrument();
        if (instrument instanceof MinecraftInstrument) {
            MinecraftInstrument instrument2 = (MinecraftInstrument)instrument;
            noteBlock = InstrumentConventer.convertToNoteBlock(instrument2.mcId());
            return InstrumentConventer.createForNoteBlock((class_2766)noteBlock, pos, note.getVolume(), note.getPitch());
        }
        noteBlock = note.getInstrument();
        if (noteBlock instanceof NbsCustomInstrument) {
            class_2960 sound;
            NbsCustomInstrument instrument3 = (NbsCustomInstrument)noteBlock;
            String file = instrument3.getSoundFilePathOr("").replace(File.separatorChar, '/');
            if (file.endsWith(".ogg")) {
                file = file.substring(0, file.length() - 4);
            }
            if ((sound = InstrumentConventer.parseSoundFile(class_310.method_1551().method_1478(), file)) != null) {
                return new SoundDirectInstance(sound, note.getVolume(), note.getPitch(), pos);
            }
            class_3414 event = InstrumentConventer.parseSoundName(instrument3.getNameOr(""));
            if (event != null) {
                return new SoundEventInstance(event, note.getVolume(), note.getPitch(), pos);
            }
            CommonData.LOGGER.warn("Failed parse custom instrument: name={}, file={}", (Object)instrument3.getNameOr(""), (Object)file);
            return new SoundDirectInstance(class_1144.field_5592, note.getVolume(), note.getPitch(), pos);
        }
        CommonData.LOGGER.warn("Unsupported instrument type: {}", (Object)note.getInstrument().getClass().getName());
        return InstrumentConventer.createForNoteBlock(class_2766.field_12648, pos, note.getVolume(), note.getPitch());
    }

    private static class_2766 convertToNoteBlock(int mcId) {
        class_2766[] instruments = class_2766.values();
        if (mcId >= 0 && mcId < instruments.length) {
            return instruments[mcId];
        }
        return class_2766.field_12648;
    }

    private static class_1113 createForNoteBlock(class_2766 instrument, class_243 pos, float volume, float pitch) {
        return new SoundEventInstance((class_3414)instrument.method_11886().comp_349(), volume, pitch, pos);
    }

    @Nullable
    public static class_2960 parseSoundFile(class_3300 manager, String file) {
        String path;
        class_2960 first = class_2960.method_12829((String)file);
        if (first != null && manager.method_14486(class_1111.field_40575.method_45112(first)).isPresent()) {
            return first;
        }
        int namespaceIndex = file.indexOf("/");
        String namespace = namespaceIndex != -1 ? file.substring(0, namespaceIndex) : file;
        class_2960 second = class_2960.method_43902((String)namespace, (String)(path = namespaceIndex != -1 && file.startsWith(namespace) ? file.substring(namespace.length() + 1) : file));
        if (second != null && manager.method_14486(class_1111.field_40575.method_45112(second)).isPresent()) {
            return second;
        }
        return null;
    }

    @Nullable
    public static class_3414 parseSoundName(@NotNull String name) {
        class_2960 first = class_2960.method_12829((String)name);
        if (first != null && class_7923.field_41172.method_10250(first)) {
            return (class_3414)class_7923.field_41172.method_63535(first);
        }
        if (name.contains(".firework.")) {
            return InstrumentConventer.parseSoundName(name.replace(".firework.", ".firework_rocket."));
        }
        return null;
    }
}

