/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.waxed;

import com.ninni.dye_depot.registry.DDDyes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.im_maker.waxed.common.block.WBlocks;
import net.im_maker.waxed.common.item.WItems;
import net.im_maker.waxed.common.particles.WParticles;
import net.im_maker.waxed.common.player.interactions.BlockInteractionHandler;
import net.im_maker.waxed.common.player.interactions.ShiningEffectForWaxedBlocks;
import net.im_maker.waxed.common.player.interactions.WaxingBlocks;
import net.im_maker.waxed.common.sounds.WSounds;
import net.im_maker.waxed.common.util.DataPackRegistrar;
import net.im_maker.waxed.common.util.WRecipeSerializers;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.suppsquared.SuppSquared;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Waxed
implements ModInitializer {
    public static final String MOD_ID = "waxed";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"waxed");
    private static final Function<class_1935, class_1799> FUNCTION = class_1799::new;
    public static List<class_1767> customColorOrder = new ArrayList<class_1767>(Arrays.asList(class_1767.field_7952, class_1767.field_7967, class_1767.field_7944, class_1767.field_7963, class_1767.field_7957, class_1767.field_7964, class_1767.field_7946, class_1767.field_7947, class_1767.field_7961, class_1767.field_7942, class_1767.field_7955, class_1767.field_7951, class_1767.field_7966, class_1767.field_7945, class_1767.field_7958, class_1767.field_7954));
    public static List<class_1767> customColorOrderR = new ArrayList<class_1767>(customColorOrder);

    public void onInitialize() {
        Waxed.isDyeDepotLoaded(FabricLoader.getInstance().isModLoaded("dye_depot"));
        DataPackRegistrar.loadBuiltinResourcePacks();
        WParticles.registerParticles();
        WBlocks.registerBlocks();
        WItems.registerItems();
        WSounds.registerSoundEvents();
        WRecipeSerializers.registerRecipeSerializers();
        WaxingBlocks.init();
        ShiningEffectForWaxedBlocks.register();
        BlockInteractionHandler.register();
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41059).register(Waxed::addToColoredBlocksTap);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(Waxed::addToNaturalBlocksTap);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(Waxed::addToFunctionalBlocksTap);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40195).register(Waxed::addToBuildingBlocksTap);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41062).register(Waxed::addToIngredientsTap);
    }

    public static void isDyeDepotLoaded(Boolean b) {
        block0: {
            if (!b.booleanValue()) break block0;
            customColorOrder = new ArrayList<class_1767>(Arrays.asList(class_1767.field_7952, class_1767.field_7967, class_1767.field_7944, class_1767.field_7963, class_1767.field_7957, DDDyes.MAROON.get(), DDDyes.ROSE.get(), class_1767.field_7964, DDDyes.CORAL.get(), DDDyes.GINGER.get(), class_1767.field_7946, DDDyes.TAN.get(), DDDyes.BEIGE.get(), class_1767.field_7947, DDDyes.AMBER.get(), DDDyes.OLIVE.get(), class_1767.field_7961, DDDyes.FOREST.get(), class_1767.field_7942, DDDyes.VERDANT.get(), DDDyes.TEAL.get(), class_1767.field_7955, DDDyes.MINT.get(), DDDyes.AQUA.get(), class_1767.field_7951, class_1767.field_7966, DDDyes.SLATE.get(), DDDyes.NAVY.get(), DDDyes.INDIGO.get(), class_1767.field_7945, class_1767.field_7958, class_1767.field_7954));
            customColorOrderR = new ArrayList<class_1767>(customColorOrder);
            Collections.reverse(customColorOrderR);
        }
    }

    public static void addToColoredBlocksTap(FabricItemGroupEntries entries) {
        if (FabricLoader.getInstance().isModLoaded("supplementaries")) {
            entries.addBefore((class_1935)((Supplier)ModRegistry.CANDLE_HOLDERS.get(class_1767.field_7952)).get(), new class_1935[]{WBlocks.SOUL_CANDLE_HOLDER});
        }
        if (FabricLoader.getInstance().isModLoaded("suppsquared")) {
            entries.addBefore((class_1935)((Supplier)SuppSquared.GOLDEN_CANDLE_HOLDERS.get(class_1767.field_7952)).get(), new class_1935[]{WBlocks.GOLD_SOUL_CANDLE_HOLDER});
        }
        entries.addAfter((class_1935)class_1802.field_27024, new class_1935[]{WBlocks.SOUL_CANDLE});
        entries.addAfter((class_1935)class_1802.field_27053, new class_1935[]{WBlocks.TALL_CANDLE});
        entries.addAfter((class_1935)WBlocks.TALL_CANDLE, new class_1935[]{WBlocks.SOUL_TALL_CANDLE});
        for (class_1767 color : customColorOrderR) {
            entries.addAfter((class_1935)WBlocks.SOUL_TALL_CANDLE, new class_1935[]{Waxed.getBlockFromString(color + "_tall_candle")});
        }
        entries.addBefore((class_1935)class_1802.field_27024, new class_1935[]{WBlocks.WAX_BLOCK, WBlocks.SOUL_WAX_BLOCK, WBlocks.WAX_PILLAR, WBlocks.SOUL_WAX_PILLAR});
        for (class_1767 color : customColorOrderR) {
            entries.addAfter((class_1935)WBlocks.SOUL_WAX_BLOCK, new class_1935[]{Waxed.getBlockFromString(color + "_wax_block")});
            entries.addAfter((class_1935)WBlocks.SOUL_WAX_PILLAR, new class_1935[]{Waxed.getBlockFromString(color + "_wax_pillar")});
            entries.addAfter((class_1935)class_1802.field_8222, new class_1935[]{Waxed.getBlockFromString("waxed_" + color + "_concrete_powder")});
        }
    }

    public static void addToNaturalBlocksTap(FabricItemGroupEntries entries) {
        entries.addAfter((class_1935)class_1802.field_8104, new class_1935[]{WBlocks.WAXED_TUBE_CORAL_BLOCK, WBlocks.WAXED_BRAIN_CORAL_BLOCK, WBlocks.WAXED_BUBBLE_CORAL_BLOCK, WBlocks.WAXED_FIRE_CORAL_BLOCK, WBlocks.WAXED_HORN_CORAL_BLOCK});
        entries.addAfter((class_1935)class_1802.field_8723, new class_1935[]{WBlocks.WAXED_TUBE_CORAL, WBlocks.WAXED_BRAIN_CORAL, WBlocks.WAXED_BUBBLE_CORAL, WBlocks.WAXED_FIRE_CORAL, WBlocks.WAXED_HORN_CORAL});
        entries.addAfter((class_1935)class_1802.field_8817, new class_1935[]{WBlocks.WAXED_TUBE_CORAL_FAN, WBlocks.WAXED_BRAIN_CORAL_FAN, WBlocks.WAXED_BUBBLE_CORAL_FAN, WBlocks.WAXED_FIRE_CORAL_FAN, WBlocks.WAXED_HORN_CORAL_FAN});
    }

    public static void addToFunctionalBlocksTap(FabricItemGroupEntries entries) {
        if (FabricLoader.getInstance().isModLoaded("supplementaries")) {
            entries.addBefore((class_1935)((Supplier)ModRegistry.CANDLE_HOLDERS.get(class_1767.field_7952)).get(), new class_1935[]{WBlocks.SOUL_CANDLE_HOLDER});
        }
        if (FabricLoader.getInstance().isModLoaded("suppsquared")) {
            entries.addBefore((class_1935)((Supplier)SuppSquared.GOLDEN_CANDLE_HOLDERS.get(class_1767.field_7952)).get(), new class_1935[]{WBlocks.GOLD_SOUL_CANDLE_HOLDER});
        }
        entries.addAfter((class_1935)class_1802.field_27024, new class_1935[]{WBlocks.SOUL_CANDLE});
        entries.addAfter((class_1935)class_1802.field_27053, new class_1935[]{WBlocks.TALL_CANDLE});
        entries.addAfter((class_1935)WBlocks.TALL_CANDLE, new class_1935[]{WBlocks.SOUL_TALL_CANDLE});
        for (class_1767 color : customColorOrderR) {
            entries.addAfter((class_1935)WBlocks.SOUL_TALL_CANDLE, new class_1935[]{Waxed.getBlockFromString(color + "_tall_candle")});
        }
    }

    public static void addToBuildingBlocksTap(FabricItemGroupEntries entries) {
        entries.addAfter((class_1935)class_1802.field_33406, new class_1935[]{WBlocks.WAXED_SAND, WBlocks.WAXED_RED_SAND, WBlocks.WAXED_GRAVEL, WBlocks.WAXED_ICE, WBlocks.WAXED_SPONGE});
        if (FabricLoader.getInstance().isModLoaded("supplementaries")) {
            entries.addAfter((class_1935)WBlocks.WAXED_SPONGE, new class_1935[]{WBlocks.WAXED_SUGAR_CUBE, WBlocks.WAXED_RAKED_GRAVEL});
        }
    }

    public static void addToIngredientsTap(FabricItemGroupEntries entries) {
        entries.addAfter((class_1935)class_1802.field_8276, new class_1935[]{WBlocks.WICK});
        entries.addAfter((class_1935)class_1802.field_20414, new class_1935[]{WItems.WAX});
    }

    public static class_2248 getBlockFromString(String block) {
        return Waxed.getBlockFromString(MOD_ID, block);
    }

    public static class_2248 getBlockFromString(String nameSpace, String block) {
        class_2960 blockLocation = new class_2960(nameSpace, block);
        return (class_2248)class_7923.field_41175.method_10223(blockLocation);
    }

    public static class_1792 getItemFromString(String item) {
        return Waxed.getItemFromString(MOD_ID, item);
    }

    public static class_1792 getItemFromString(String nameSpace, String item) {
        class_2960 itemLocation = new class_2960(nameSpace, item);
        return (class_1792)class_7923.field_41178.method_10223(itemLocation);
    }

    static {
        Collections.reverse(customColorOrderR);
    }
}

