/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.waxed.common.player.interactions;

import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.im_maker.waxed.common.util.WTags;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5945;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class ShiningEffectForWaxedBlocks {
    private static final Set<class_2338> renderedBlocks = new HashSet<class_2338>();
    private static final int RENDER_RADIUS = 5;
    private static final int[] textureCycle = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    private static int tickCounter = 0;

    public static void register() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(ShiningEffectForWaxedBlocks::render);
    }

    private static void render(WorldRenderContext context) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null || mc.field_1687 == null || mc.method_1493()) {
            return;
        }
        class_1799 heldItem = player.method_6047();
        class_1799 offhandItem = player.method_6079();
        if (!heldItem.method_31573(WTags.Items.CAN_WAX) && !offhandItem.method_31573(WTags.Items.CAN_WAX)) {
            return;
        }
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        double camX = cameraPos.method_10216();
        double camY = cameraPos.method_10214();
        double camZ = cameraPos.method_10215();
        class_4587 poseStack = context.matrixStack();
        class_4597.class_4598 bufferSource = mc.method_22940().method_23000();
        class_2338 playerPos = player.method_24515();
        class_2338 closestBlockPos = null;
        double closestDistanceSquared = Double.MAX_VALUE;
        for (int dx = -5; dx <= 5; ++dx) {
            for (int dy = -5; dy <= 5; ++dy) {
                for (int dz = -5; dz <= 5; ++dz) {
                    double ddz;
                    double ddy;
                    double ddx;
                    double blockDistanceSquared;
                    class_2338 blockPos;
                    class_2680 blockState;
                    double distanceSquared = dx * dx + dy * dy + dz * dz;
                    if (distanceSquared > 30.25 || !ShiningEffectForWaxedBlocks.isItWaxedBlock(blockState = mc.field_1687.method_8320(blockPos = playerPos.method_10069(dx, dy, dz))).booleanValue() || (blockDistanceSquared = (ddx = (double)blockPos.method_10263() - camX) * ddx + (ddy = (double)blockPos.method_10264() - camY) * ddy + (ddz = (double)blockPos.method_10260() - camZ) * ddz) > 1024.0) continue;
                    if (blockDistanceSquared < closestDistanceSquared) {
                        closestBlockPos = blockPos;
                        closestDistanceSquared = blockDistanceSquared;
                    }
                    poseStack.method_22903();
                    poseStack.method_22904((double)blockPos.method_10263() - camX, (double)blockPos.method_10264() - camY, (double)blockPos.method_10260() - camZ);
                    if (tickCounter % 80 == 0) {
                        class_5945.method_34682((class_1937)mc.field_1687, (class_2338)blockPos, (class_2394)class_2398.field_29643, (class_6017)class_6019.method_35017((int)0, (int)1));
                    }
                    poseStack.method_22909();
                }
            }
        }
        if (closestBlockPos != null && mc.field_1687.field_9236) {
            int cycleIndex = textureCycle[tickCounter / 10 % textureCycle.length];
            class_638 level = mc.field_1687;
            if (cycleIndex == 5 || cycleIndex == 10) {
                level.method_8396((class_1657)player, closestBlockPos, class_3417.field_26980, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
        bufferSource.method_22993();
        renderedBlocks.clear();
        ++tickCounter;
    }

    private static Boolean isItWaxedBlock(class_2680 blockState) {
        String blockId = class_7923.field_41175.method_10221((Object)blockState.method_26204()).method_12832();
        return blockId.contains("waxed_");
    }
}

