/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.waxed.common.player.interactions;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.ninni.dye_depot.registry.DDDyes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.im_maker.waxed.Waxed;
import net.im_maker.waxed.common.block.WBlocks;
import net.im_maker.waxed.common.item.WItems;
import net.im_maker.waxed.common.sounds.WSounds;
import net.im_maker.waxed.common.util.WTags;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_174;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3965;
import net.minecraft.class_5953;
import net.minecraft.class_5955;
import net.minecraft.class_7923;

public class WaxingBlocks {
    public static final Supplier<BiMap<class_2248, class_2248>> WAXABLES_SHOVEL = Suppliers.memoize(() -> {
        HashBiMap waxedBlocks = HashBiMap.create();
        waxedBlocks.put((Object)class_2246.field_10102, (Object)WBlocks.WAXED_SAND);
        waxedBlocks.put((Object)class_2246.field_10534, (Object)WBlocks.WAXED_RED_SAND);
        waxedBlocks.put((Object)class_2246.field_10255, (Object)WBlocks.WAXED_GRAVEL);
        waxedBlocks.put((Object)class_2246.field_10258, (Object)WBlocks.WAXED_SPONGE);
        for (class_1767 color : class_1767.values()) {
            String dyeID = "minecraft";
            if (FabricLoader.getInstance().isModLoaded("dye_depot")) {
                for (DDDyes dddcolor : DDDyes.values()) {
                    if (dddcolor.getName() != color.method_7792()) continue;
                    dyeID = "dye_depot";
                }
            }
            waxedBlocks.put((Object)Waxed.getBlockFromString(dyeID, color + "_concrete_powder"), (Object)Waxed.getBlockFromString("waxed_" + color + "_concrete_powder"));
        }
        if (FabricLoader.getInstance().isModLoaded("supplementaries")) {
            waxedBlocks.put((Object)((class_2248)ModRegistry.SUGAR_CUBE.get()), (Object)WBlocks.WAXED_SUGAR_CUBE);
            waxedBlocks.put((Object)((class_2248)ModRegistry.RAKED_GRAVEL.get()), (Object)WBlocks.WAXED_RAKED_GRAVEL);
        }
        waxedBlocks.putAll((Map)waxedBlocks);
        return waxedBlocks;
    });
    public static final Supplier<BiMap<class_2248, class_2248>> WAXABLES_MODDED_BLOCKS = Suppliers.memoize(() -> {
        class_2960 id;
        HashBiMap waxedBlocks = HashBiMap.create();
        ArrayList<class_2248> waxedModdedBlocks = new ArrayList<class_2248>();
        for (class_2248 block : class_7923.field_41175) {
            id = class_7923.field_41175.method_10221((Object)block);
            if (!id.method_12832().contains("waxed_") || id.method_12836().equals("waxed")) continue;
            waxedModdedBlocks.add(block);
        }
        Iterator iterator = waxedModdedBlocks.iterator();
        while (iterator.hasNext()) {
            class_2248 waxedBlock = (class_2248)iterator.next();
            id = class_7923.field_41175.method_10221((Object)waxedBlock);
            String unwaxedPath = id.method_12832().replace("waxed_", "");
            class_2248 unwaxedBlock = Waxed.getBlockFromString(id.method_12836(), unwaxedPath);
            if (unwaxedBlock == null) continue;
            if (!(unwaxedBlock instanceof class_5955)) {
                waxedBlocks.put((Object)unwaxedBlock, (Object)waxedBlock);
                continue;
            }
            iterator.remove();
        }
        waxedBlocks.putAll((Map)waxedBlocks);
        return waxedBlocks;
    });
    public static final Supplier<BiMap<class_2248, class_2248>> WAXABLES_MODDED_BLOCKS_WITH_COPPER = Suppliers.memoize(() -> {
        class_2960 id;
        HashBiMap waxedBlocks = HashBiMap.create();
        ArrayList<class_2248> waxedModdedBlocks = new ArrayList<class_2248>();
        for (class_2248 block : class_7923.field_41175) {
            id = class_7923.field_41175.method_10221((Object)block);
            if (!id.method_12832().contains("waxed_") || id.method_12836().equals("waxed")) continue;
            waxedModdedBlocks.add(block);
        }
        for (class_2248 waxedBlock : waxedModdedBlocks) {
            id = class_7923.field_41175.method_10221((Object)waxedBlock);
            String unwaxedPath = id.method_12832().replace("waxed_", "");
            class_2248 unwaxedBlock = Waxed.getBlockFromString(id.method_12836(), unwaxedPath);
            if (unwaxedBlock == class_2246.field_10124) {
                unwaxedBlock = Waxed.getBlockFromString("minecraft", unwaxedPath);
                if (unwaxedBlock == class_2246.field_10124) continue;
                waxedBlocks.put((Object)unwaxedBlock, (Object)waxedBlock);
                continue;
            }
            waxedBlocks.put((Object)unwaxedBlock, (Object)waxedBlock);
        }
        waxedBlocks.putAll((Map)waxedBlocks);
        return waxedBlocks;
    });
    public static final Supplier<BiMap<class_2248, class_2248>> WAXABLES_AXE = Suppliers.memoize(() -> {
        HashBiMap waxedBlocks = HashBiMap.create();
        waxedBlocks.put((Object)class_2246.field_10295, (Object)WBlocks.WAXED_ICE);
        waxedBlocks.put((Object)class_2246.field_10309, (Object)WBlocks.WAXED_TUBE_CORAL_BLOCK);
        waxedBlocks.put((Object)class_2246.field_10629, (Object)WBlocks.WAXED_BRAIN_CORAL_BLOCK);
        waxedBlocks.put((Object)class_2246.field_10000, (Object)WBlocks.WAXED_BUBBLE_CORAL_BLOCK);
        waxedBlocks.put((Object)class_2246.field_10516, (Object)WBlocks.WAXED_FIRE_CORAL_BLOCK);
        waxedBlocks.put((Object)class_2246.field_10464, (Object)WBlocks.WAXED_HORN_CORAL_BLOCK);
        waxedBlocks.put((Object)class_2246.field_10125, (Object)WBlocks.WAXED_TUBE_CORAL);
        waxedBlocks.put((Object)class_2246.field_10339, (Object)WBlocks.WAXED_BRAIN_CORAL);
        waxedBlocks.put((Object)class_2246.field_10134, (Object)WBlocks.WAXED_BUBBLE_CORAL);
        waxedBlocks.put((Object)class_2246.field_10618, (Object)WBlocks.WAXED_FIRE_CORAL);
        waxedBlocks.put((Object)class_2246.field_10169, (Object)WBlocks.WAXED_HORN_CORAL);
        waxedBlocks.put((Object)class_2246.field_10053, (Object)WBlocks.WAXED_TUBE_CORAL_FAN);
        waxedBlocks.put((Object)class_2246.field_10079, (Object)WBlocks.WAXED_BRAIN_CORAL_FAN);
        waxedBlocks.put((Object)class_2246.field_10427, (Object)WBlocks.WAXED_BUBBLE_CORAL_FAN);
        waxedBlocks.put((Object)class_2246.field_10551, (Object)WBlocks.WAXED_FIRE_CORAL_FAN);
        waxedBlocks.put((Object)class_2246.field_10005, (Object)WBlocks.WAXED_HORN_CORAL_FAN);
        waxedBlocks.put((Object)class_2246.field_10584, (Object)WBlocks.WAXED_TUBE_CORAL_WALL_FAN);
        waxedBlocks.put((Object)class_2246.field_10186, (Object)WBlocks.WAXED_BRAIN_CORAL_WALL_FAN);
        waxedBlocks.put((Object)class_2246.field_10447, (Object)WBlocks.WAXED_BUBBLE_CORAL_WALL_FAN);
        waxedBlocks.put((Object)class_2246.field_10498, (Object)WBlocks.WAXED_FIRE_CORAL_WALL_FAN);
        waxedBlocks.put((Object)class_2246.field_9976, (Object)WBlocks.WAXED_HORN_CORAL_WALL_FAN);
        waxedBlocks.putAll((Map)waxedBlocks);
        return waxedBlocks;
    });

    public static Optional<class_2248> getWaxedModdedBlocks(class_2248 block) {
        return Optional.ofNullable((class_2248)WAXABLES_MODDED_BLOCKS.get().get((Object)block));
    }

    public static Optional<class_2248> getVanillaWaxedCopperBlocks(class_2248 block) {
        return Optional.ofNullable((class_2248)((BiMap)class_5953.field_29560.get()).get((Object)block));
    }

    public static Optional<class_2248> getWaxedShovels(class_2248 block) {
        return Optional.ofNullable((class_2248)WAXABLES_SHOVEL.get().get((Object)block));
    }

    public static Optional<class_2248> getWaxedAxe(class_2248 block) {
        return Optional.ofNullable((class_2248)WAXABLES_AXE.get().get((Object)block));
    }

    public static Optional<class_2248> getUnwaxedShovels(class_2248 block) {
        return Optional.ofNullable((class_2248)WAXABLES_SHOVEL.get().inverse().get((Object)block));
    }

    public static Optional<class_2248> getUnwaxedAxe(class_2248 block) {
        return Optional.ofNullable((class_2248)WAXABLES_AXE.get().inverse().get((Object)block));
    }

    public static void init() {
        UseBlockCallback.EVENT.register(WaxingBlocks::handleBlockInteractions);
    }

    private static class_1269 handleBlockInteractions(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        class_1799 itemStack;
        class_2680 blockState;
        if (player.method_7325()) {
            return class_1269.field_5811;
        }
        class_2338 blockPos = hitResult.method_17777();
        class_1269 waxOnResult = WaxingBlocks.tryWaxOn(player, level, blockPos, blockState = level.method_8320(blockPos), itemStack = player.method_5998(hand));
        if (waxOnResult != class_1269.field_5811) {
            return waxOnResult;
        }
        class_1269 waxOffResult = WaxingBlocks.tryWaxOff(player, level, blockPos, blockState, itemStack);
        if (waxOffResult != class_1269.field_5811) {
            return waxOffResult;
        }
        return class_1269.field_5811;
    }

    private static class_1269 tryWaxOn(class_1657 player, class_1937 level, class_2338 blockPos, class_2680 blockState, class_1799 itemStack) {
        Optional<class_2248> waxedBlock1 = WaxingBlocks.getWaxedShovels(blockState.method_26204());
        Optional<class_2248> waxedBlock2 = WaxingBlocks.getWaxedAxe(blockState.method_26204());
        Optional<class_2248> waxedModdedBlock = WaxingBlocks.getWaxedModdedBlocks(blockState.method_26204());
        Optional<class_2248> waxedVanillaBlock = WaxingBlocks.getVanillaWaxedCopperBlocks(blockState.method_26204());
        if (itemStack.method_31573(WTags.Items.CAN_WAX) && (waxedBlock1.isPresent() || waxedBlock2.isPresent() || blockState.method_28498((class_2769)class_2741.field_12536) && (Integer)blockState.method_11654((class_2769)class_2741.field_12536) == 8)) {
            return WaxingBlocks.processWaxOn(player, level, blockPos, blockState, itemStack, waxedBlock1.orElse(null), waxedBlock2.orElse(null));
        }
        if (itemStack.method_31574(WItems.WAX) && (waxedModdedBlock.isPresent() || waxedVanillaBlock.isPresent())) {
            return WaxingBlocks.processWaxOnWithWax(player, level, blockPos, blockState, itemStack, waxedModdedBlock.orElse(null));
        }
        return class_1269.field_5811;
    }

    private static class_1269 processWaxOn(class_1657 player, class_1937 level, class_2338 blockPos, class_2680 blockState, class_1799 itemStack, class_2248 ... waxedBlocks) {
        class_3222 serverPlayer;
        if (player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            class_174.field_24478.method_23889(serverPlayer, blockPos, itemStack);
        }
        player.method_6104(class_1268.field_5808);
        if (!player.method_7337()) {
            itemStack.method_7934(1);
        }
        for (class_2248 waxedBlock : waxedBlocks) {
            if (waxedBlock == null) continue;
            level.method_8652(blockPos, waxedBlock.method_34725(blockState), 3);
            break;
        }
        if (player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            WaxingBlocks.grantAdvancement(serverPlayer, "minecraft:husbandry/wax_on");
        }
        level.method_8444(player, 3003, blockPos, 0);
        return class_1269.method_29236((boolean)level.method_8608());
    }

    private static class_1269 processWaxOnWithWax(class_1657 player, class_1937 level, class_2338 blockPos, class_2680 blockState, class_1799 itemStack, class_2248 waxedBlock) {
        class_3222 serverPlayer;
        if (waxedBlock == null) {
            return class_1269.field_5811;
        }
        if (player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            class_174.field_24478.method_23889(serverPlayer, blockPos, itemStack);
        }
        player.method_6104(class_1268.field_5808);
        if (!player.method_7337()) {
            itemStack.method_7934(1);
        }
        if (!level.method_8608()) {
            if (level.method_8320(blockPos).method_31709()) {
                class_2586 blockEntity = level.method_8321(blockPos);
                if (blockEntity != null) {
                    class_2487 data = blockEntity.method_38242();
                    level.method_8652(blockPos, class_2246.field_10124.method_9564(), 16);
                    level.method_8501(blockPos, waxedBlock.method_34725(blockState));
                    class_2586 newBlockEntity = level.method_8321(blockPos);
                    if (newBlockEntity != null) {
                        newBlockEntity.method_11014(data);
                        level.method_8438(newBlockEntity);
                    }
                }
            } else {
                level.method_8652(blockPos, waxedBlock.method_34725(blockState), 3);
            }
        }
        if (player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            WaxingBlocks.grantAdvancement(serverPlayer, "minecraft:husbandry/wax_on");
        }
        level.method_8444(player, 3003, blockPos, 0);
        return class_1269.method_29236((boolean)level.method_8608());
    }

    private static class_1269 tryWaxOff(class_1657 player, class_1937 level, class_2338 blockPos, class_2680 blockState, class_1799 itemStack) {
        Optional<class_2248> unwaxedBlock1 = WaxingBlocks.getUnwaxedShovels(blockState.method_26204());
        Optional<class_2248> unwaxedBlock2 = WaxingBlocks.getUnwaxedAxe(blockState.method_26204());
        if (itemStack.method_31573(class_3489.field_42615)) {
            if (unwaxedBlock1.isPresent()) {
                return WaxingBlocks.processWaxOff(player, level, blockPos, blockState, itemStack, unwaxedBlock1.get(), WSounds.SHOVEL_WAX_OFF);
            }
        } else if (itemStack.method_31573(class_3489.field_42612) && unwaxedBlock2.isPresent()) {
            return WaxingBlocks.processWaxOff(player, level, blockPos, blockState, itemStack, unwaxedBlock2.get(), class_3417.field_29542);
        }
        return class_1269.field_5811;
    }

    private static class_1269 processWaxOff(class_1657 player, class_1937 level, class_2338 blockPos, class_2680 blockState, class_1799 itemStack, class_2248 unwaxedBlock, class_3414 soundEvent) {
        class_3222 serverPlayer;
        if (player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            class_174.field_24478.method_23889(serverPlayer, blockPos, itemStack);
        }
        player.method_6104(class_1268.field_5808);
        if (!player.method_7337()) {
            itemStack.method_7956(1, (class_1309)player, p -> p.method_20236(class_1268.field_5808));
        }
        if (player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            WaxingBlocks.grantAdvancement(serverPlayer, "minecraft:husbandry/wax_off");
        }
        level.method_8652(blockPos, unwaxedBlock.method_34725(blockState), 3);
        level.method_8444(player, 3004, blockPos, 0);
        level.method_8396(null, blockPos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
        return class_1269.method_29236((boolean)level.method_8608());
    }

    private static void grantAdvancement(class_3222 player, String advancementId) {
        class_167 progress;
        class_161 advancement = player.field_13995.method_3851().method_12896(new class_2960(advancementId));
        if (advancement != null && !(progress = player.method_14236().method_12882(advancement)).method_740()) {
            for (String criteria : progress.method_731()) {
                player.method_14236().method_12878(advancement, criteria);
            }
        }
    }
}

