/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels;

import me.dartanman.duels.Metrics;
import me.dartanman.duels.commands.DuelCmd;
import me.dartanman.duels.commands.DuelTabCompleter;
import me.dartanman.duels.game.arenas.ArenaManager;
import me.dartanman.duels.game.kits.KitManager;
import me.dartanman.duels.listeners.ArenaListener;
import me.dartanman.duels.listeners.GameListener;
import me.dartanman.duels.listeners.PlayerListener;
import me.dartanman.duels.listeners.StatsListener;
import me.dartanman.duels.nbtapi.NBT;
import me.dartanman.duels.stats.StatisticsManager;
import me.dartanman.duels.stats.db.DatabaseType;
import me.dartanman.duels.utils.KitChecker;
import me.dartanman.duels.utils.PapiHook;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Duels
extends JavaPlugin {
    private ArenaManager arenaManager;
    private KitManager kitManager;
    private StatisticsManager statisticsManager;

    public void onEnable() {
        int pluginId = 12801;
        Metrics metrics = new Metrics(this, pluginId);
        if (!NBT.preloadApi()) {
            this.getLogger().warning("NBT-API wasn't initialized properly, disabling Duels!");
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PapiHook(this).register();
        } else {
            Bukkit.getLogger().warning("PlaceholderAPI not found! The plugin will still work, but you can't make leaderboards outside of the built-in leaderboard.");
        }
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.arenaManager = new ArenaManager(this);
        this.kitManager = new KitManager(this);
        this.setupStatisticsManager();
        this.getCommand("duel").setExecutor((CommandExecutor)new DuelCmd(this));
        this.getCommand("duel").setTabCompleter((TabCompleter)new DuelTabCompleter(this));
        this.getServer().getPluginManager().registerEvents((Listener)new ArenaListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GameListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new StatsListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        KitChecker.kitCheck(null);
    }

    private void setupStatisticsManager() {
        String storageType = this.getConfig().getString("Statistics.Storage-Type");
        assert (storageType != null);
        if (storageType.equalsIgnoreCase("sql") || storageType.equalsIgnoreCase("mysql")) {
            this.statisticsManager = new StatisticsManager(this, DatabaseType.SQL);
        } else if (storageType.equalsIgnoreCase("yaml") || storageType.equalsIgnoreCase("yml")) {
            this.statisticsManager = new StatisticsManager(this, DatabaseType.YAML);
        } else {
            Bukkit.getLogger().warning("Duels does not recognize the Storage Option '" + storageType + "'. Opting for YAML (flat-file) storage.");
            this.statisticsManager = new StatisticsManager(this, DatabaseType.YAML);
        }
    }

    public ArenaManager getArenaManager() {
        return this.arenaManager;
    }

    public KitManager getKitManager() {
        return this.kitManager;
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }
}

