/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.commands.subcommands;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.dartanman.duels.Duels;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public abstract class DuelsSubCommand {
    protected Duels plugin;
    protected String subCommand;
    protected String[] args;
    private static final List<DuelsSubCommand> subCommands = new ArrayList<DuelsSubCommand>();

    public static List<DuelsSubCommand> getSubCommands() {
        return subCommands;
    }

    public DuelsSubCommand(Duels plugin, String subCommand) {
        this.plugin = plugin;
        this.subCommand = subCommand;
        subCommands.add(this);
    }

    protected void unknownCommand(CommandSender sender) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.plugin.getConfig().getString("Messages.Unknown-Command"))));
    }

    protected void noPerm(CommandSender sender) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.plugin.getConfig().getString("Messages.No-Permission"))));
    }

    protected void incorrectArgs(CommandSender sender, String suggestion) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(Objects.requireNonNull(this.plugin.getConfig().getString("Messages.Incorrect-Args")).replace("<suggestion>", suggestion))));
    }

    public String getSubCommand() {
        return this.subCommand;
    }

    public boolean is(String string) {
        return string.equalsIgnoreCase(this.subCommand);
    }

    public abstract boolean execute(CommandSender var1, String[] var2);
}

