/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.commands.subcommands.duel;

import java.util.Objects;
import me.dartanman.duels.Duels;
import me.dartanman.duels.commands.subcommands.DuelsSubCommand;
import me.dartanman.duels.game.GameState;
import me.dartanman.duels.game.arenas.Arena;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class JoinDuelsSubCmd
extends DuelsSubCommand {
    public JoinDuelsSubCmd(Duels plugin) {
        super(plugin, "join");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!sender.hasPermission("duels.join")) {
            this.noPerm(sender);
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 0) {
                Arena playerArena = this.plugin.getArenaManager().getArena(player);
                if (playerArena != null) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.plugin.getConfig().getString("Messages.Already-Joined"))));
                    return true;
                }
                Arena available = this.findFirstArena();
                if (available == null) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.plugin.getConfig().getString("Messages.No-Available-Arena"))));
                    return true;
                }
                available.addPlayer(player);
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(Objects.requireNonNull(this.plugin.getConfig().getString("Messages.Joined-Arena")).replace("<arena_name>", available.getName()))));
                return true;
            }
            if (args.length == 1) {
                int id;
                Arena playerArena = this.plugin.getArenaManager().getArena(player);
                if (playerArena != null) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.plugin.getConfig().getString("Messages.Already-Joined"))));
                    return true;
                }
                try {
                    id = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(Objects.requireNonNull(this.plugin.getConfig().getString("Messages.Invalid-Arena-Id")).replace("<arg>", args[0]))));
                    return true;
                }
                Arena arena = this.plugin.getArenaManager().getArena(id);
                if (arena == null) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(Objects.requireNonNull(this.plugin.getConfig().getString("Messages.Invalid-Arena-Id")).replace("<arg>", args[0]))));
                    return true;
                }
                if (arena.getGameState() != GameState.IDLE) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(Objects.requireNonNull(this.plugin.getConfig().getString("Messages.Arena-Not-Available")).replace("<arg>", args[0]))));
                    return true;
                }
                arena.addPlayer(player);
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(Objects.requireNonNull(this.plugin.getConfig().getString("Messages.Joined-Arena")).replace("<arena_name>", arena.getName()))));
                return true;
            }
            this.incorrectArgs(sender, "/duels join [arena id]");
            return true;
        }
        sender.sendMessage(ChatColor.RED + "You must be a Player to do that!");
        return false;
    }

    private Arena findFirstArena() {
        for (Arena arena : this.plugin.getArenaManager().getArenaList()) {
            if (arena.getGameState() != GameState.IDLE) continue;
            return arena;
        }
        return null;
    }
}

