/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.commands.subcommands.duel;

import java.util.Objects;
import me.dartanman.duels.Duels;
import me.dartanman.duels.commands.subcommands.DuelsSubCommand;
import me.dartanman.duels.game.kits.Kit;
import me.dartanman.duels.game.kits.KitManager;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KitsDuelsSubCmd
extends DuelsSubCommand {
    public KitsDuelsSubCmd(Duels plugin) {
        super(plugin, "kits");
    }

    @Override
    public boolean is(String string) {
        return string.equalsIgnoreCase("kits") || string.equalsIgnoreCase("kit");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("list")) {
                    if (!sender.hasPermission("duels.kits.list")) {
                        this.noPerm(sender);
                        return true;
                    }
                    for (Kit kit : this.plugin.getKitManager().getKitList()) {
                        player.sendMessage("- " + kit.getName());
                    }
                    return true;
                }
                this.incorrectArgs((CommandSender)player, "/duels help");
                return true;
            }
            if (args.length == 2) {
                if (args[0].equalsIgnoreCase("create")) {
                    if (!sender.hasPermission("duels.kits.create")) {
                        this.noPerm(sender);
                        return true;
                    }
                    String kitName = args[1];
                    for (Kit kit : this.plugin.getKitManager().getKitList()) {
                        if (!kit.getName().equalsIgnoreCase(kitName)) continue;
                        player.sendMessage(ChatColor.RED + "A kit with that name already exists!");
                        return true;
                    }
                    this.plugin.getKitManager().createKit(kitName, player);
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.plugin.getConfig().getString("Messages.Kit-Created")).replace("<kit_name>", kitName)));
                    return true;
                }
                if (args[0].equalsIgnoreCase("delete")) {
                    if (!sender.hasPermission("duels.kits.delete")) {
                        this.noPerm(sender);
                        return true;
                    }
                    String kitName = args[1];
                    this.plugin.getKitManager().deleteKit(kitName);
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.plugin.getConfig().getString("Messages.Kit-Deleted")).replace("<kit_name>", kitName)));
                    return true;
                }
                if (args[0].equalsIgnoreCase("select")) {
                    if (!sender.hasPermission("duels.kits.select")) {
                        this.noPerm(sender);
                        return true;
                    }
                    String kitName = args[1];
                    Kit kit = this.plugin.getKitManager().getKit(kitName);
                    if (kit != null) {
                        KitManager.selectKit(player, kit.getName());
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.plugin.getConfig().getString("Messages.Kit-Selected")).replace("<kit_name>", kit.getName())));
                    }
                    return true;
                }
                this.incorrectArgs((CommandSender)player, "/duels kits <create/delete/select> <kit name>");
                return true;
            }
            this.incorrectArgs((CommandSender)player, "/duels help");
            return true;
        }
        sender.sendMessage(ChatColor.RED + "You must be a Player to do that!");
        return false;
    }
}

