/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.commands.subcommands.duel;

import me.dartanman.duels.Duels;
import me.dartanman.duels.commands.subcommands.DuelsSubCommand;
import me.dartanman.duels.game.GameState;
import me.dartanman.duels.game.arenas.Arena;
import me.dartanman.duels.utils.PlayerRestoration;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LeaveDuelsSubCmd
extends DuelsSubCommand {
    public LeaveDuelsSubCmd(Duels plugin) {
        super(plugin, "leave");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!sender.hasPermission("duels.leave")) {
            this.noPerm(sender);
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 0) {
                Arena arena = this.plugin.getArenaManager().getArena(player);
                if (arena == null) {
                    player.sendMessage(ChatColor.RED + "You are not currently in a Duel!");
                    return true;
                }
                PlayerRestoration.restorePlayer(player, true);
                if (arena.getGameState() == GameState.PLAYING) {
                    arena.getGame().kill(player);
                } else {
                    arena.removePlayer(player);
                }
                return true;
            }
            this.incorrectArgs(sender, "/duels leave");
            return true;
        }
        sender.sendMessage(ChatColor.RED + "You must be a Player to do that!");
        return false;
    }
}

