/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.commands.subcommands.stats;

import java.util.UUID;
import me.dartanman.duels.Duels;
import me.dartanman.duels.commands.subcommands.DuelsSubCommand;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GetStatsDuelsSubCmd
extends DuelsSubCommand {
    public GetStatsDuelsSubCmd(Duels plugin) {
        super(plugin, "stats");
    }

    private void sendStatsCard(CommandSender sender, UUID target, String name) {
        for (String line : this.plugin.getConfig().getStringList("Messages.Stats-Card")) {
            line = ChatColor.translateAlternateColorCodes((char)'&', (String)line.replace("<wins>", "" + this.plugin.getStatisticsManager().getStatsDB().getWins(target)).replace("<losses>", "" + this.plugin.getStatisticsManager().getStatsDB().getLosses(target)).replace("<kills>", "" + this.plugin.getStatisticsManager().getStatsDB().getKills(target)).replace("<deaths>", "" + this.plugin.getStatisticsManager().getStatsDB().getDeaths(target)).replace("<name>", name));
            sender.sendMessage(line);
        }
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!sender.hasPermission("duels.stats")) {
            this.noPerm(sender);
            return true;
        }
        if (args.length == 0) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.sendStatsCard(sender, player.getUniqueId(), player.getName());
                return true;
            }
            sender.sendMessage(ChatColor.RED + "You must be a Player to do that!");
            return false;
        }
        if (args.length == 1) {
            String targetName = args[0];
            Player target = Bukkit.getPlayer((String)targetName);
            if (target != null) {
                UUID uuid = target.getUniqueId();
                this.sendStatsCard(sender, uuid, target.getName());
                return true;
            }
            UUID uuid = this.plugin.getStatisticsManager().getStatsDB().getUUID(targetName);
            if (uuid != null) {
                this.sendStatsCard(sender, uuid, targetName);
                return true;
            }
            sender.sendMessage(ChatColor.RED + "Cannot find statistics for " + ChatColor.YELLOW + targetName);
            return true;
        }
        this.incorrectArgs(sender, "/duels stats [player]");
        return true;
    }
}

