/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.game;

import java.util.Objects;
import me.dartanman.duels.Duels;
import me.dartanman.duels.game.arenas.Arena;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Countdown
extends BukkitRunnable {
    private final Duels plugin;
    private final Arena arena;
    private int seconds;

    public Countdown(Duels plugin, Arena arena, int seconds) {
        this.plugin = plugin;
        this.arena = arena;
        this.seconds = seconds > 0 ? seconds : 15;
    }

    private void sendSeconds() {
        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.plugin.getConfig().getString("Messages.Countdown")));
        message = message.replace("<seconds>", "" + this.seconds);
        this.arena.sendMessage(message);
    }

    public void start() {
        if (this.seconds % 10 != 0) {
            this.sendSeconds();
        }
        this.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public void run() {
        if (this.seconds == 0) {
            this.cancel();
            this.arena.getGame().start();
        } else {
            if (this.seconds <= 5 || this.seconds % 10 == 0) {
                this.sendSeconds();
            }
            --this.seconds;
        }
    }
}

