/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.game;

import java.util.UUID;
import me.dartanman.duels.game.GameState;
import me.dartanman.duels.game.arenas.Arena;
import me.dartanman.duels.stats.db.StatisticsDatabase;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Game {
    private final Arena arena;

    public Game(Arena arena) {
        this.arena = arena;
    }

    public void start() {
        this.arena.setGameState(GameState.PLAYING);
        Player playerOne = Bukkit.getPlayer((UUID)this.arena.getPlayerOne());
        Player playerTwo = Bukkit.getPlayer((UUID)this.arena.getPlayerTwo());
        assert (playerOne != null);
        assert (playerTwo != null);
        playerOne.teleport(this.arena.getSpawnOne());
        playerTwo.teleport(this.arena.getSpawnTwo());
        this.applyKits();
    }

    private void applyKits() {
        Player playerOne = Bukkit.getPlayer((UUID)this.arena.getPlayerOne());
        Player playerTwo = Bukkit.getPlayer((UUID)this.arena.getPlayerTwo());
        assert (playerOne != null);
        assert (playerTwo != null);
        this.arena.getKitManager().giveKit(playerOne);
        this.arena.getKitManager().giveKit(playerTwo);
    }

    public void kill(Player player) {
        Player playerOne = Bukkit.getPlayer((UUID)this.arena.getPlayerOne());
        Player playerTwo = Bukkit.getPlayer((UUID)this.arena.getPlayerTwo());
        assert (playerOne != null);
        assert (playerTwo != null);
        StatisticsDatabase db = this.arena.getStatisticsDatabase();
        if (playerOne.getUniqueId().equals(player.getUniqueId())) {
            this.arena.sendMessage(playerTwo.getName() + " wins!");
            UUID winnerUUID = playerTwo.getUniqueId();
            UUID loserUUID = playerOne.getUniqueId();
            db.setWins(winnerUUID, db.getWins(winnerUUID) + 1);
            db.setLosses(loserUUID, db.getLosses(loserUUID) + 1);
        } else {
            this.arena.sendMessage(playerOne.getName() + " wins!");
            UUID winnerUUID = playerOne.getUniqueId();
            UUID loserUUID = playerTwo.getUniqueId();
            db.setWins(winnerUUID, db.getWins(winnerUUID) + 1);
            db.setLosses(loserUUID, db.getLosses(loserUUID) + 1);
        }
        this.arena.reset();
    }
}

