/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.game.arenas;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.dartanman.duels.Duels;
import me.dartanman.duels.game.Countdown;
import me.dartanman.duels.game.Game;
import me.dartanman.duels.game.GameState;
import me.dartanman.duels.game.arenas.ArenaConfig;
import me.dartanman.duels.game.kits.KitManager;
import me.dartanman.duels.stats.db.StatisticsDatabase;
import me.dartanman.duels.utils.PlayerRestoration;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Arena {
    private final Duels plugin;
    private final int id;
    private final String name;
    private GameState gameState;
    private final List<UUID> players;
    private final Location spawnOne;
    private final Location spawnTwo;
    private final Location lobby;
    private Game game;
    private Countdown countdown;
    private int countdownSeconds;

    public Arena(Duels plugin, int id, String name, Location spawnOne, Location spawnTwo, Location lobby, int countdownSeconds) {
        this.plugin = plugin;
        this.id = id;
        this.name = name;
        this.gameState = GameState.IDLE;
        this.spawnOne = spawnOne;
        this.spawnTwo = spawnTwo;
        this.lobby = lobby;
        this.players = new ArrayList<UUID>();
        this.game = new Game(this);
        this.countdownSeconds = countdownSeconds;
        this.countdown = new Countdown(plugin, this, countdownSeconds);
    }

    public Arena(Duels plugin, ArenaConfig arenaConfig) {
        this.plugin = plugin;
        this.id = arenaConfig.getId();
        this.name = arenaConfig.getName();
        this.gameState = GameState.IDLE;
        this.spawnOne = arenaConfig.getSpawnOne();
        this.spawnTwo = arenaConfig.getSpawnTwo();
        this.lobby = arenaConfig.getLobby();
        this.players = new ArrayList<UUID>();
        this.game = new Game(this);
        this.countdownSeconds = arenaConfig.getCountdownSeconds();
        this.countdown = new Countdown(plugin, this, arenaConfig.getCountdownSeconds());
    }

    public void reset() {
        this.game = new Game(this);
        this.countdown = new Countdown(this.plugin, this, this.countdownSeconds);
        Player p1 = Bukkit.getPlayer((UUID)this.getPlayerOne());
        Player p2 = Bukkit.getPlayer((UUID)this.getPlayerTwo());
        if (p1 != null) {
            PlayerRestoration.restorePlayer(p1, false);
        }
        if (p2 != null) {
            PlayerRestoration.restorePlayer(p2, false);
        }
        this.players.clear();
        this.gameState = GameState.IDLE;
    }

    public void start() {
        this.gameState = GameState.COUNTDOWN;
        this.countdown.start();
    }

    public void sendMessage(String message) {
        for (UUID uuid : this.players) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) continue;
            player.sendMessage(message);
        }
    }

    public KitManager getKitManager() {
        return this.plugin.getKitManager();
    }

    public StatisticsDatabase getStatisticsDatabase() {
        return this.plugin.getStatisticsManager().getStatsDB();
    }

    public void addPlayer(Player player) {
        PlayerRestoration.savePlayer(player);
        this.players.add(player.getUniqueId());
        player.teleport(this.lobby);
        player.setGameMode(GameMode.ADVENTURE);
        player.getInventory().clear();
        player.getInventory().setArmorContents(new ItemStack[4]);
        player.setMaxHealth(20.0);
        player.setHealth(20.0);
        player.setFoodLevel(20);
        if (this.players.size() == 2) {
            this.start();
        }
    }

    public void removePlayer(Player player) {
        this.players.remove(player.getUniqueId());
        if (this.gameState == GameState.COUNTDOWN) {
            this.countdown.cancel();
            this.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.plugin.getConfig().getString("Messages.Player-Left-Cancelled"))));
            this.gameState = GameState.IDLE;
        }
        this.countdown = new Countdown(this.plugin, this, this.countdownSeconds);
    }

    public List<UUID> getPlayers() {
        return this.players;
    }

    public Location getSpawnOne() {
        return this.spawnOne;
    }

    public Location getSpawnTwo() {
        return this.spawnTwo;
    }

    public Location getLobby() {
        return this.lobby;
    }

    public UUID getPlayerOne() {
        return this.players.get(0);
    }

    public UUID getPlayerTwo() {
        return this.players.get(1);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Game getGame() {
        return this.game;
    }

    public GameState getGameState() {
        return this.gameState;
    }

    public void setGameState(GameState gameState) {
        this.gameState = gameState;
    }
}

