/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.game.arenas;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.dartanman.duels.Duels;
import me.dartanman.duels.game.arenas.Arena;
import me.dartanman.duels.game.arenas.ArenaConfig;
import me.dartanman.duels.utils.ConfigUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class ArenaManager {
    private final Duels plugin;
    private final List<Arena> arenaList;

    public ArenaManager(Duels plugin) {
        this.plugin = plugin;
        this.arenaList = new ArrayList<Arena>();
        this.loadArenas();
    }

    private void loadArenas() {
        FileConfiguration config = this.plugin.getConfig();
        if (!config.contains("Arenas")) {
            return;
        }
        for (String arenaIdStr : Objects.requireNonNull(config.getConfigurationSection("Arenas")).getKeys(false)) {
            int id;
            String path = "Arenas." + arenaIdStr;
            try {
                id = Integer.parseInt(arenaIdStr);
            }
            catch (NumberFormatException e) {
                Bukkit.getLogger().severe("Failed to parse integer '" + arenaIdStr + "' from config.yml (arena id)");
                continue;
            }
            String name = this.plugin.getConfig().getString(path + ".Name");
            Location spawnOne = ConfigUtils.getLocation(path + ".Spawn-One");
            Location spawnTwo = ConfigUtils.getLocation(path + ".Spawn-Two");
            Location lobby = ConfigUtils.getLocation(path + ".Lobby");
            int countdownSeconds = this.plugin.getConfig().getInt(path + ".Countdown-Seconds");
            Arena arena = new Arena(this.plugin, id, name, spawnOne, spawnTwo, lobby, countdownSeconds);
            this.arenaList.add(arena);
        }
    }

    public void save(ArenaConfig arenaConfig) {
        int id = arenaConfig.getId();
        String idStr = String.valueOf(id);
        String name = arenaConfig.getName();
        Location spawnOne = arenaConfig.getSpawnOne();
        Location spawnTwo = arenaConfig.getSpawnTwo();
        Location lobby = arenaConfig.getLobby();
        int countdownSeconds = arenaConfig.getCountdownSeconds();
        this.plugin.getConfig().set("Arenas." + idStr + ".Name", (Object)name);
        this.plugin.getConfig().set("Arenas." + idStr + ".Countdown-Seconds", (Object)countdownSeconds);
        this.plugin.getConfig().set("Arenas." + idStr + ".Spawn-One.World", (Object)Objects.requireNonNull(spawnOne.getWorld()).getName());
        this.plugin.getConfig().set("Arenas." + idStr + ".Spawn-One.X", (Object)spawnOne.getX());
        this.plugin.getConfig().set("Arenas." + idStr + ".Spawn-One.Y", (Object)spawnOne.getY());
        this.plugin.getConfig().set("Arenas." + idStr + ".Spawn-One.Z", (Object)spawnOne.getZ());
        this.plugin.getConfig().set("Arenas." + idStr + ".Spawn-One.Yaw", (Object)Float.valueOf(spawnOne.getYaw()));
        this.plugin.getConfig().set("Arenas." + idStr + ".Spawn-One.Pitch", (Object)Float.valueOf(spawnOne.getPitch()));
        this.plugin.getConfig().set("Arenas." + idStr + ".Spawn-Two.World", (Object)Objects.requireNonNull(spawnTwo.getWorld()).getName());
        this.plugin.getConfig().set("Arenas." + idStr + ".Spawn-Two.X", (Object)spawnTwo.getX());
        this.plugin.getConfig().set("Arenas." + idStr + ".Spawn-Two.Y", (Object)spawnTwo.getY());
        this.plugin.getConfig().set("Arenas." + idStr + ".Spawn-Two.Z", (Object)spawnTwo.getZ());
        this.plugin.getConfig().set("Arenas." + idStr + ".Spawn-Two.Yaw", (Object)Float.valueOf(spawnTwo.getYaw()));
        this.plugin.getConfig().set("Arenas." + idStr + ".Spawn-Two.Pitch", (Object)Float.valueOf(spawnTwo.getPitch()));
        this.plugin.getConfig().set("Arenas." + idStr + ".Lobby.World", (Object)Objects.requireNonNull(lobby.getWorld()).getName());
        this.plugin.getConfig().set("Arenas." + idStr + ".Lobby.X", (Object)lobby.getX());
        this.plugin.getConfig().set("Arenas." + idStr + ".Lobby.Y", (Object)lobby.getY());
        this.plugin.getConfig().set("Arenas." + idStr + ".Lobby.Z", (Object)lobby.getZ());
        this.plugin.getConfig().set("Arenas." + idStr + ".Lobby.Yaw", (Object)Float.valueOf(lobby.getYaw()));
        this.plugin.getConfig().set("Arenas." + idStr + ".Lobby.Pitch", (Object)Float.valueOf(lobby.getPitch()));
        this.plugin.saveConfig();
        this.arenaList.add(new Arena(this.plugin, arenaConfig));
    }

    public Arena getArena(Player player) {
        UUID uuid = player.getUniqueId();
        for (Arena arena : this.arenaList) {
            if (!arena.getPlayers().contains(uuid)) continue;
            return arena;
        }
        return null;
    }

    public Arena getArena(int id) {
        for (Arena arena : this.arenaList) {
            if (arena.getId() != id) continue;
            return arena;
        }
        return null;
    }

    public List<Arena> getArenaList() {
        return this.arenaList;
    }

    public int getNextId() {
        int max = 0;
        for (Arena arena : this.arenaList) {
            int id = arena.getId();
            if (id <= max) continue;
            max = id;
        }
        return max + 1;
    }
}

