/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.game.kits;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.dartanman.duels.Duels;
import me.dartanman.duels.game.kits.Kit;
import me.dartanman.duels.utils.ItemSerializationUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class KitManager {
    public static final HashMap<UUID, String> kitMap = new HashMap();
    private final Duels plugin;
    private final List<Kit> kitList;

    public static void selectKit(Player player, String kit) {
        kitMap.put(player.getUniqueId(), kit);
    }

    public KitManager(Duels plugin) {
        this.plugin = plugin;
        this.kitList = new ArrayList<Kit>();
        this.loadKits();
    }

    public void giveKit(Player player) {
        Kit kit = this.getKit("Default");
        if (kitMap.containsKey(player.getUniqueId()) && (kit = this.getKit(kitMap.get(player.getUniqueId()))) == null) {
            kit = this.getKit("Default");
        }
        kit.apply(player);
    }

    private void loadKits() {
        FileConfiguration config = this.plugin.getConfig();
        if (!config.contains("Kits")) {
            return;
        }
        for (String kitIdStr : Objects.requireNonNull(config.getConfigurationSection("Kits")).getKeys(false)) {
            int id;
            String path = "Kits." + kitIdStr;
            try {
                id = Integer.parseInt(kitIdStr);
            }
            catch (NumberFormatException e) {
                Bukkit.getLogger().severe("Failed to parse integer '" + kitIdStr + "' from config.yml (kit id)");
                continue;
            }
            String name = this.plugin.getConfig().getString(path + ".Name");
            String helmetBase64 = this.plugin.getConfig().getString(path + ".Armor.Helmet");
            String chestplateBase64 = this.plugin.getConfig().getString(path + ".Armor.Chestplate");
            String leggingsBase64 = this.plugin.getConfig().getString(path + ".Armor.Leggings");
            String bootsBase64 = this.plugin.getConfig().getString(path + ".Armor.Boots");
            List inventoryBase64 = this.plugin.getConfig().getStringList(path + ".Inventory");
            assert (helmetBase64 != null);
            assert (chestplateBase64 != null);
            assert (leggingsBase64 != null);
            assert (bootsBase64 != null);
            ItemStack[] armor = new ItemStack[4];
            armor[3] = ItemSerializationUtils.deserialize(helmetBase64);
            armor[2] = ItemSerializationUtils.deserialize(chestplateBase64);
            armor[1] = ItemSerializationUtils.deserialize(leggingsBase64);
            armor[0] = ItemSerializationUtils.deserialize(bootsBase64);
            ItemStack[] inventory = new ItemStack[inventoryBase64.size()];
            int i = 0;
            for (String base64 : inventoryBase64) {
                inventory[i++] = ItemSerializationUtils.deserialize(base64);
            }
            this.kitList.add(new Kit(id, name, armor, inventory));
        }
    }

    public void deleteKit(String kitName) {
        Kit kit = this.getKit(kitName);
        if (kit != null) {
            this.plugin.getConfig().set("Kits." + kit.getId(), null);
            this.plugin.saveConfig();
            this.kitList.remove(kit);
        }
    }

    public Kit createKit(String kitName, Player player) {
        int id = this.getNextId();
        ItemStack helmet = player.getInventory().getHelmet();
        ItemStack chestplate = player.getInventory().getChestplate();
        ItemStack leggings = player.getInventory().getLeggings();
        ItemStack boots = player.getInventory().getBoots();
        if (helmet == null) {
            helmet = new ItemStack(Material.AIR);
        }
        if (chestplate == null) {
            chestplate = new ItemStack(Material.AIR);
        }
        if (leggings == null) {
            leggings = new ItemStack(Material.AIR);
        }
        if (boots == null) {
            boots = new ItemStack(Material.AIR);
        }
        ItemStack[] armor = new ItemStack[]{boots, leggings, chestplate, helmet};
        ItemStack[] inventory = player.getInventory().getContents();
        inventory[inventory.length - 2] = null;
        inventory[inventory.length - 3] = null;
        inventory[inventory.length - 4] = null;
        inventory[inventory.length - 5] = null;
        this.plugin.getConfig().set("Kits." + id + ".Name", (Object)kitName);
        this.plugin.getConfig().set("Kits." + id + ".Armor.Helmet", (Object)ItemSerializationUtils.serialize(helmet));
        this.plugin.getConfig().set("Kits." + id + ".Armor.Chestplate", (Object)ItemSerializationUtils.serialize(chestplate));
        this.plugin.getConfig().set("Kits." + id + ".Armor.Leggings", (Object)ItemSerializationUtils.serialize(leggings));
        this.plugin.getConfig().set("Kits." + id + ".Armor.Boots", (Object)ItemSerializationUtils.serialize(boots));
        ArrayList<String> invList = new ArrayList<String>();
        for (ItemStack item : inventory) {
            if (item == null) continue;
            invList.add(ItemSerializationUtils.serialize(item));
        }
        this.plugin.getConfig().set("Kits." + id + ".Inventory", invList);
        this.plugin.saveConfig();
        Kit kit = new Kit(id, kitName, armor, inventory);
        this.kitList.add(kit);
        return kit;
    }

    public Kit getKit(String kitName) {
        for (Kit kit : this.kitList) {
            if (!kit.getName().equalsIgnoreCase(kitName)) continue;
            return kit;
        }
        return null;
    }

    public List<Kit> getKitList() {
        return this.kitList;
    }

    public int getNextId() {
        int max = 0;
        for (Kit kit : this.kitList) {
            int id = kit.getId();
            if (id <= max) continue;
            max = id;
        }
        return max + 1;
    }
}

