/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.listeners;

import me.dartanman.duels.Duels;
import me.dartanman.duels.game.GameState;
import me.dartanman.duels.game.arenas.Arena;
import me.dartanman.duels.utils.PlayerRestoration;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ArenaListener
implements Listener {
    private final Duels plugin;

    public ArenaListener(Duels plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        PersistentDataContainer pdc = player.getPersistentDataContainer();
        if (pdc.has(new NamespacedKey((Plugin)this.plugin, "world"), PersistentDataType.STRING)) {
            String worldName = (String)pdc.get(new NamespacedKey((Plugin)this.plugin, "world"), PersistentDataType.STRING);
            int x = (Integer)pdc.get(new NamespacedKey((Plugin)this.plugin, "x"), PersistentDataType.INTEGER);
            int y = (Integer)pdc.get(new NamespacedKey((Plugin)this.plugin, "y"), PersistentDataType.INTEGER);
            int z = (Integer)pdc.get(new NamespacedKey((Plugin)this.plugin, "z"), PersistentDataType.INTEGER);
            assert (worldName != null);
            World world = Bukkit.getWorld((String)worldName);
            player.teleport(new Location(world, (double)x, (double)y, (double)z));
            pdc.remove(new NamespacedKey((Plugin)this.plugin, "world"));
            pdc.remove(new NamespacedKey((Plugin)this.plugin, "x"));
            pdc.remove(new NamespacedKey((Plugin)this.plugin, "y"));
            pdc.remove(new NamespacedKey((Plugin)this.plugin, "z"));
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        Arena arena = this.plugin.getArenaManager().getArena(player);
        if (arena != null) {
            PlayerRestoration.restorePlayer(player, true);
            if (arena.getGameState() == GameState.PLAYING) {
                arena.getGame().kill(player);
            } else {
                arena.removePlayer(player);
            }
        }
    }
}

