/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.listeners;

import java.util.UUID;
import me.dartanman.duels.Duels;
import me.dartanman.duels.game.GameState;
import me.dartanman.duels.game.arenas.Arena;
import me.dartanman.duels.stats.db.StatisticsDatabase;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class GameListener
implements Listener {
    private final Duels plugin;

    public GameListener(Duels plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onDeath(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Arena arena = this.plugin.getArenaManager().getArena(player);
            if (arena != null) {
                if (arena.getGameState() == GameState.PLAYING) {
                    double dmg = event.getFinalDamage();
                    double health = player.getHealth();
                    if (health - dmg <= 0.0) {
                        EntityDamageByEntityEvent subEvent;
                        Entity entity2;
                        StatisticsDatabase db = this.plugin.getStatisticsManager().getStatsDB();
                        if (event instanceof EntityDamageByEntityEvent && (entity2 = (subEvent = (EntityDamageByEntityEvent)event).getDamager()) instanceof Player) {
                            Player damager = (Player)entity2;
                            UUID duuid = damager.getUniqueId();
                            db.setKills(duuid, db.getKills(duuid) + 1);
                        }
                        arena.getGame().kill(player);
                        UUID uuid = player.getUniqueId();
                        db.setDeaths(uuid, db.getDeaths(uuid) + 1);
                        event.setCancelled(true);
                    }
                } else {
                    event.setCancelled(true);
                }
            }
        }
    }
}

