/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.nbtapi.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import javax.annotation.Nullable;
import me.dartanman.duels.nbtapi.NBTType;
import me.dartanman.duels.nbtapi.iface.ReadWriteNBT;
import me.dartanman.duels.nbtapi.iface.ReadWriteNBTCompoundList;
import me.dartanman.duels.nbtapi.iface.ReadableNBT;
import me.dartanman.duels.nbtapi.iface.ReadableNBTList;

public class GameprofileUtil {
    @Nullable
    public static GameProfile readGameProfile(ReadableNBT arg) {
        String string = null;
        UUID uUID = null;
        if (arg.hasTag("Name") && arg.getType("Name") == NBTType.NBTTagString) {
            string = arg.getString("Name");
        }
        if (arg.hasTag("Id") && arg.getType("Id") == NBTType.NBTTagIntArray && arg.getIntArray("Id").length == 4) {
            uUID = arg.getUUID("Id");
        }
        try {
            GameProfile gameProfile = new GameProfile(uUID, string);
            if (arg.hasTag("Properties") && arg.getType("Properties") == NBTType.NBTTagCompound) {
                ReadableNBT compoundTag = arg.getCompound("Properties");
                for (String string2 : compoundTag.getKeys()) {
                    ReadableNBTList<ReadWriteNBT> listTag = compoundTag.getCompoundList(string);
                    for (int i = 0; i < listTag.size(); ++i) {
                        ReadableNBT compoundTag2 = listTag.get(i);
                        String string3 = compoundTag2.getString("Value");
                        if (compoundTag2.hasTag("Signature") && compoundTag2.getType("Signature") == NBTType.NBTTagString) {
                            gameProfile.getProperties().put((Object)string2, (Object)new Property(string2, string3, compoundTag2.getString("Signature")));
                            continue;
                        }
                        gameProfile.getProperties().put((Object)string2, (Object)new Property(string2, string3));
                    }
                }
            }
            return gameProfile;
        }
        catch (Throwable var11) {
            return null;
        }
    }

    public static ReadWriteNBT writeGameProfile(ReadWriteNBT arg, GameProfile gameProfile) {
        if (gameProfile.getName() != null && !gameProfile.getName().isEmpty()) {
            arg.setString("Name", gameProfile.getName());
        }
        if (gameProfile.getId() != null) {
            arg.setUUID("Id", gameProfile.getId());
        }
        if (!gameProfile.getProperties().isEmpty()) {
            ReadWriteNBT compoundTag = arg.getOrCreateCompound("Properties");
            for (String string : gameProfile.getProperties().keySet()) {
                ReadWriteNBTCompoundList list = compoundTag.getCompoundList(string);
                for (Property property : gameProfile.getProperties().get((Object)string)) {
                    ReadWriteNBT tag = list.addCompound();
                    tag.setString("Value", property.getValue());
                    if (!property.hasSignature()) continue;
                    tag.setString("Signature", property.getSignature());
                }
            }
        }
        return arg;
    }
}

