/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.stats;

import java.io.File;
import java.io.IOException;
import me.dartanman.duels.Duels;
import me.dartanman.duels.stats.db.DatabaseType;
import me.dartanman.duels.stats.db.StatisticsDatabase;
import me.dartanman.duels.stats.db.impl.StatisticsDatabaseSQL;
import me.dartanman.duels.stats.db.impl.StatisticsDatabaseYAML;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class StatisticsManager {
    private final Duels plugin;
    private final FileConfiguration statsFile = new YamlConfiguration();
    private File statsF;
    private final StatisticsDatabase statsDB;

    public StatisticsManager(Duels plugin, DatabaseType dbType) {
        this.plugin = plugin;
        this.statsDB = this.connectToDatabase(dbType);
    }

    private StatisticsDatabase connectToDatabase(DatabaseType dbType) {
        if (dbType == DatabaseType.YAML) {
            Bukkit.getLogger().info("[Duels] Using YAML File storage for Statistics");
            this.createStatsConfig();
            this.saveStatsConfig();
            return new StatisticsDatabaseYAML(this);
        }
        if (dbType == DatabaseType.SQL) {
            Bukkit.getLogger().info("[Duels] Using SQL Database for Statistics");
            return new StatisticsDatabaseSQL(this.plugin, this);
        }
        return null;
    }

    public StatisticsDatabase getStatsDB() {
        return this.statsDB;
    }

    public FileConfiguration getStatsConfig() {
        return this.statsFile;
    }

    public void saveStatsConfig() {
        try {
            this.statsFile.save(this.statsF);
        }
        catch (IOException e) {
            e.printStackTrace();
            Bukkit.getLogger().warning("[Duels] Failed to save statistics.yml");
        }
    }

    private void createStatsConfig() {
        this.statsF = new File(this.plugin.getDataFolder(), "statistics.yml");
        this.saveRes(this.statsF, "statistics.yml");
        try {
            this.statsFile.load(this.statsF);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            Bukkit.getLogger().warning("[Duels] Failed to create statistics.yml");
        }
    }

    private void saveRes(File file, String name) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            this.plugin.saveResource(name, false);
        }
    }
}

