/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.stats.db.impl;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.UUID;
import me.dartanman.duels.Duels;
import me.dartanman.duels.stats.StatisticsManager;
import me.dartanman.duels.stats.db.StatisticsDatabase;
import org.bukkit.Bukkit;

public class StatisticsDatabaseSQL
implements StatisticsDatabase {
    private final StatisticsManager manager;
    private final Duels plugin;
    private Connection connection;

    public StatisticsDatabaseSQL(Duels plugin, StatisticsManager manager) {
        this.plugin = plugin;
        this.manager = manager;
        this.setup();
    }

    private void setup() {
        Connection connection = this.getConnection();
        try {
            PreparedStatement stmt = connection.prepareStatement("CREATE TABLE IF NOT EXISTS duels_player (Player_UUID VARCHAR(37) NOT NULL, Last_Known_Name VARCHAR(32) NOT NULL, Wins INT NOT NULL, Losses INT NOT NULL, Kills INT NOT NULL, Deaths INT NOT NULL, PRIMARY KEY ( Player_UUID ));");
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Duels experienced an error while attempting to create and/or locate a table in the SQL Database!");
            Bukkit.getLogger().severe(e.toString());
        }
    }

    private Connection getConnection() {
        String address = this.plugin.getConfig().getString("Statistics.SQL-Info.Address");
        String port = this.plugin.getConfig().getString("Statistics.SQL-Info.Port");
        String db = this.plugin.getConfig().getString("Statistics.SQL-Info.Database");
        String user = this.plugin.getConfig().getString("Statistics.SQL-Info.Username");
        String pass = this.plugin.getConfig().getString("Statistics.SQL-Info.Password");
        String DB_URL = "jdbc:mysql://" + address + ":" + port + "/" + db + "?characterEncoding=utf8";
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connection = DriverManager.getConnection(DB_URL, user, pass);
            }
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Duels experienced an error while attempting to connect to the SQL Database!");
            Bukkit.getLogger().severe(e.toString());
        }
        return this.connection;
    }

    @Override
    public int getWins(UUID uuid) {
        Connection connection = this.getConnection();
        int wins = 0;
        try {
            PreparedStatement stmt = connection.prepareStatement("SELECT Wins FROM duels_player WHERE Player_UUID = ?");
            stmt.setString(1, uuid.toString());
            ResultSet result = stmt.executeQuery();
            if (result.next()) {
                wins = result.getInt("Wins");
            }
            result.close();
            stmt.close();
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Duels experienced an error while attempting to retrieve a win-count from the SQL Database!");
            Bukkit.getLogger().severe(e.toString());
        }
        return wins;
    }

    @Override
    public int getLosses(UUID uuid) {
        Connection connection = this.getConnection();
        int losses = 0;
        try {
            PreparedStatement stmt = connection.prepareStatement("SELECT Losses FROM duels_player WHERE Player_UUID = ?");
            stmt.setString(1, uuid.toString());
            ResultSet result = stmt.executeQuery();
            if (result.next()) {
                losses = result.getInt("Losses");
            }
            result.close();
            stmt.close();
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Duels experienced an error while attempting to retrieve a loss-count from the SQL Database!");
            Bukkit.getLogger().severe(e.toString());
        }
        return losses;
    }

    @Override
    public int getKills(UUID uuid) {
        Connection connection = this.getConnection();
        int kills = 0;
        try {
            PreparedStatement stmt = connection.prepareStatement("SELECT Kills FROM duels_player WHERE Player_UUID = ?");
            stmt.setString(1, uuid.toString());
            ResultSet result = stmt.executeQuery();
            if (result.next()) {
                kills = result.getInt("Kills");
            }
            result.close();
            stmt.close();
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Duels experienced an error while attempting to retrieve a kill-count from the SQL Database!");
            Bukkit.getLogger().severe(e.toString());
        }
        return kills;
    }

    @Override
    public int getDeaths(UUID uuid) {
        Connection connection = this.getConnection();
        int deaths = 0;
        try {
            PreparedStatement stmt = connection.prepareStatement("SELECT Deaths FROM duels_player WHERE Player_UUID = ?");
            stmt.setString(1, uuid.toString());
            ResultSet result = stmt.executeQuery();
            if (result.next()) {
                deaths = result.getInt("Deaths");
            }
            result.close();
            stmt.close();
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Duels experienced an error while attempting to retrieve a death-count from the SQL Database!");
            Bukkit.getLogger().severe(e.toString());
        }
        return deaths;
    }

    @Override
    public void setWins(UUID uuid, int wins) {
        Connection connection = this.getConnection();
        try {
            PreparedStatement stmt = connection.prepareStatement("UPDATE duels_player SET Wins = ? WHERE Player_UUID = ?");
            stmt.setInt(1, wins);
            stmt.setString(2, uuid.toString());
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Duels experienced an error while attempting to set a win-count in the SQL Database!");
            Bukkit.getLogger().severe(e.toString());
        }
    }

    @Override
    public void setLosses(UUID uuid, int losses) {
        Connection connection = this.getConnection();
        try {
            PreparedStatement stmt = connection.prepareStatement("UPDATE duels_player SET Losses = ? WHERE Player_UUID = ?");
            stmt.setInt(1, losses);
            stmt.setString(2, uuid.toString());
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Duels experienced an error while attempting to set a loss-count in the SQL Database!");
            Bukkit.getLogger().severe(e.toString());
        }
    }

    @Override
    public void setKills(UUID uuid, int kills) {
        Connection connection = this.getConnection();
        try {
            PreparedStatement stmt = connection.prepareStatement("UPDATE duels_player SET Kills = ? WHERE Player_UUID = ?");
            stmt.setInt(1, kills);
            stmt.setString(2, uuid.toString());
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Duels experienced an error while attempting to set a kill-count in the SQL Database!");
            Bukkit.getLogger().severe(e.toString());
        }
    }

    @Override
    public void setDeaths(UUID uuid, int deaths) {
        Connection connection = this.getConnection();
        try {
            PreparedStatement stmt = connection.prepareStatement("UPDATE duels_player SET Deaths = ? WHERE Player_UUID = ?");
            stmt.setInt(1, deaths);
            stmt.setString(2, uuid.toString());
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Duels experienced an error while attempting to set a death-count in the SQL Database!");
            Bukkit.getLogger().severe(e.toString());
        }
    }

    @Override
    public void registerNewPlayer(UUID uuid, String name) {
        Connection connection = this.getConnection();
        try {
            PreparedStatement stmt = connection.prepareStatement("INSERT INTO duels_player VALUES (?, ?, 0, 0, 0, 0)");
            stmt.setString(1, uuid.toString());
            stmt.setString(2, name);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Duels experienced an error while attempting to register a player in the SQL Database!");
            Bukkit.getLogger().severe(e.toString());
        }
    }

    @Override
    public boolean isRegistered(UUID uuid) {
        String name = this.getLastKnownName(uuid);
        return !name.equals("[Unknown]");
    }

    @Override
    public UUID getUUID(String playerName) throws RuntimeException {
        Connection connection = this.getConnection();
        String uuidStr = "[Unknown]";
        try {
            PreparedStatement stmt = connection.prepareStatement("SELECT Player_UUID FROM duels_player WHERE Last_Known_Name = ?");
            stmt.setString(1, playerName);
            ResultSet result = stmt.executeQuery();
            if (result.next()) {
                uuidStr = result.getString("Player_UUID");
            }
            result.close();
            stmt.close();
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Duels experienced an error while attempting to retrieve a UUID from the SQL Database!");
            Bukkit.getLogger().severe(e.toString());
        }
        if (uuidStr.equals("[Unknown]")) {
            throw new RuntimeException("UUID could not be located");
        }
        return UUID.fromString(uuidStr);
    }

    @Override
    public String getLastKnownName(UUID uuid) {
        Connection connection = this.getConnection();
        String name = "[Unknown]";
        try {
            PreparedStatement stmt = connection.prepareStatement("SELECT Last_Known_Name FROM duels_player WHERE Player_UUID = ?");
            stmt.setString(1, uuid.toString());
            ResultSet result = stmt.executeQuery();
            if (result.next()) {
                name = result.getString("Last_Known_Name");
            }
            result.close();
            stmt.close();
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Duels experienced an error while attempting to retrieve a username from the SQL Database!");
            Bukkit.getLogger().severe(e.toString());
        }
        return name;
    }

    @Override
    public HashMap<UUID, Integer> getTopTenWins() {
        Connection connection = this.getConnection();
        HashMap<UUID, Integer> lbMap = new HashMap<UUID, Integer>();
        try {
            PreparedStatement stmt = connection.prepareStatement("SELECT Player_UUID, Wins FROM duels_player ORDER BY Wins desc LIMIT 10");
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                lbMap.put(UUID.fromString(result.getString("Player_UUID")), result.getInt("Wins"));
            }
            result.close();
            stmt.close();
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Duels experienced an error while attempting to retrieve top wins from the SQL Database!");
            Bukkit.getLogger().severe(e.toString());
        }
        return lbMap;
    }

    @Override
    public HashMap<UUID, Integer> getTopTenKills() {
        Connection connection = this.getConnection();
        HashMap<UUID, Integer> lbMap = new HashMap<UUID, Integer>();
        try {
            PreparedStatement stmt = connection.prepareStatement("SELECT Player_UUID, Kills FROM duels_player ORDER BY Kills desc LIMIT 10");
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                lbMap.put(UUID.fromString(result.getString("Player_UUID")), result.getInt("Kills"));
            }
            result.close();
            stmt.close();
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Duels experienced an error while attempting to retrieve top kills from the SQL Database!");
            Bukkit.getLogger().severe(e.toString());
        }
        return lbMap;
    }

    private static class Constants {
        public static final String CREATE_TABLE_STMT = "CREATE TABLE IF NOT EXISTS duels_player (Player_UUID VARCHAR(37) NOT NULL, Last_Known_Name VARCHAR(32) NOT NULL, Wins INT NOT NULL, Losses INT NOT NULL, Kills INT NOT NULL, Deaths INT NOT NULL, PRIMARY KEY ( Player_UUID ));";
        public static final String REGISTER_PLAYER_STMT = "INSERT INTO duels_player VALUES (?, ?, 0, 0, 0, 0)";
        public static final String GET_NAME_STMT = "SELECT Last_Known_Name FROM duels_player WHERE Player_UUID = ?";
        public static final String GET_UUID_STMT = "SELECT Player_UUID FROM duels_player WHERE Last_Known_Name = ?";
        public static final String GET_WINS_STMT = "SELECT Wins FROM duels_player WHERE Player_UUID = ?";
        public static final String GET_LOSSES_STMT = "SELECT Losses FROM duels_player WHERE Player_UUID = ?";
        public static final String GET_KILLS_STMT = "SELECT Kills FROM duels_player WHERE Player_UUID = ?";
        public static final String GET_DEATHS_STMT = "SELECT Deaths FROM duels_player WHERE Player_UUID = ?";
        public static final String SET_WINS_STMT = "UPDATE duels_player SET Wins = ? WHERE Player_UUID = ?";
        public static final String SET_LOSSES_STMT = "UPDATE duels_player SET Losses = ? WHERE Player_UUID = ?";
        public static final String SET_KILLS_STMT = "UPDATE duels_player SET Kills = ? WHERE Player_UUID = ?";
        public static final String SET_DEATHS_STMT = "UPDATE duels_player SET Deaths = ? WHERE Player_UUID = ?";
        public static final String GET_TOP_TEN_WINS = "SELECT Player_UUID, Wins FROM duels_player ORDER BY Wins desc LIMIT 10";
        public static final String GET_TOP_TEN_KILLS = "SELECT Player_UUID, Kills FROM duels_player ORDER BY Kills desc LIMIT 10";

        private Constants() {
        }
    }
}

