/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.stats.db.impl;

import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import me.dartanman.duels.stats.StatisticsManager;
import me.dartanman.duels.stats.db.StatisticsDatabase;

public class StatisticsDatabaseYAML
implements StatisticsDatabase {
    private final StatisticsManager manager;

    public StatisticsDatabaseYAML(StatisticsManager manager) {
        this.manager = manager;
    }

    @Override
    public int getWins(UUID uuid) {
        return this.manager.getStatsConfig().getInt("Statistics." + uuid.toString() + ".Wins");
    }

    @Override
    public int getLosses(UUID uuid) {
        return this.manager.getStatsConfig().getInt("Statistics." + uuid.toString() + ".Losses");
    }

    @Override
    public int getKills(UUID uuid) {
        return this.manager.getStatsConfig().getInt("Statistics." + uuid.toString() + ".Kills");
    }

    @Override
    public int getDeaths(UUID uuid) {
        return this.manager.getStatsConfig().getInt("Statistics." + uuid.toString() + ".Deaths");
    }

    @Override
    public void setWins(UUID uuid, int wins) {
        this.manager.getStatsConfig().set("Statistics." + uuid.toString() + ".Wins", (Object)wins);
        this.manager.saveStatsConfig();
    }

    @Override
    public void setLosses(UUID uuid, int losses) {
        this.manager.getStatsConfig().set("Statistics." + uuid.toString() + ".Losses", (Object)losses);
        this.manager.saveStatsConfig();
    }

    @Override
    public void setKills(UUID uuid, int kills) {
        this.manager.getStatsConfig().set("Statistics." + uuid.toString() + ".Kills", (Object)kills);
        this.manager.saveStatsConfig();
    }

    @Override
    public void setDeaths(UUID uuid, int deaths) {
        this.manager.getStatsConfig().set("Statistics." + uuid.toString() + ".Deaths", (Object)deaths);
        this.manager.saveStatsConfig();
    }

    @Override
    public void registerNewPlayer(UUID uuid, String name) {
        this.manager.getStatsConfig().set("Statistics." + uuid.toString() + ".Last-Known-Name", (Object)name);
        this.manager.saveStatsConfig();
        this.setWins(uuid, 0);
        this.setLosses(uuid, 0);
        this.setKills(uuid, 0);
        this.setDeaths(uuid, 0);
    }

    @Override
    public boolean isRegistered(UUID uuid) {
        return this.manager.getStatsConfig().contains("Statistics." + uuid.toString());
    }

    @Override
    public UUID getUUID(String playerName) {
        for (String uuidStr : Objects.requireNonNull(this.manager.getStatsConfig().getConfigurationSection("Statistics")).getKeys(false)) {
            if (!Objects.requireNonNull(this.manager.getStatsConfig().getString("Statistics." + uuidStr + ".Last-Known-Name")).equalsIgnoreCase(playerName)) continue;
            return UUID.fromString(uuidStr);
        }
        return null;
    }

    @Override
    public String getLastKnownName(UUID uuid) {
        for (String uuidStr : Objects.requireNonNull(this.manager.getStatsConfig().getConfigurationSection("Statistics")).getKeys(false)) {
            if (!uuidStr.equals(uuid.toString())) continue;
            return this.manager.getStatsConfig().getString("Statistics." + uuidStr + ".Last-Known-Name");
        }
        return null;
    }

    @Override
    public HashMap<UUID, Integer> getTopTenWins() {
        HashMap<UUID, Integer> allWins = new HashMap<UUID, Integer>();
        HashMap<UUID, Integer> topTenWins = new HashMap<UUID, Integer>();
        for (String uuidStr : Objects.requireNonNull(this.manager.getStatsConfig().getConfigurationSection("Statistics")).getKeys(false)) {
            UUID uuid = UUID.fromString(uuidStr);
            allWins.put(uuid, this.getWins(uuid));
        }
        int topAmt = Math.min(10, allWins.size());
        for (int i = 0; i < topAmt; ++i) {
            UUID maxUUID = null;
            int maxWins = -1;
            for (UUID uuid : allWins.keySet()) {
                int curWins = (Integer)allWins.get(uuid);
                if (curWins <= maxWins) continue;
                maxUUID = uuid;
                maxWins = curWins;
            }
            topTenWins.put(maxUUID, maxWins);
            allWins.remove(maxUUID);
        }
        return topTenWins;
    }

    @Override
    public HashMap<UUID, Integer> getTopTenKills() {
        HashMap<UUID, Integer> allKills = new HashMap<UUID, Integer>();
        HashMap<UUID, Integer> topTenKills = new HashMap<UUID, Integer>();
        for (String uuidStr : Objects.requireNonNull(this.manager.getStatsConfig().getConfigurationSection("Statistics")).getKeys(false)) {
            UUID uuid = UUID.fromString(uuidStr);
            allKills.put(uuid, this.getKills(uuid));
        }
        int topAmt = Math.min(10, allKills.size());
        for (int i = 0; i < topAmt; ++i) {
            UUID maxUUID = null;
            int maxKills = -1;
            for (UUID uuid : allKills.keySet()) {
                int curKills = (Integer)allKills.get(uuid);
                if (curKills <= maxKills) continue;
                maxUUID = uuid;
                maxKills = curKills;
            }
            topTenKills.put(maxUUID, maxKills);
            allKills.remove(maxUUID);
        }
        return topTenKills;
    }
}

