/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.utils;

import java.util.LinkedHashMap;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.dartanman.duels.Duels;
import me.dartanman.duels.stats.db.StatisticsDatabase;
import me.dartanman.duels.utils.MapSortingUtils;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class PapiHook
extends PlaceholderExpansion {
    private final Duels plugin;

    public PapiHook(Duels plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "duels";
    }

    @NotNull
    public String getAuthor() {
        return (String)this.plugin.getDescription().getAuthors().get(0);
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String params) {
        if (params.toLowerCase().startsWith("top_wins_")) {
            String[] split = params.split("_");
            String num = split[2];
            int place = -1;
            try {
                place = Integer.parseInt(num);
            }
            catch (NumberFormatException e) {
                return "Err: Format should be 'duels_top_wins_#' where '#' is a number between 1-10";
            }
            if (place > 10) {
                return "Err: Format should be 'duels_top_wins_#' where '#' is a number between 1-10";
            }
            StatisticsDatabase db = this.plugin.getStatisticsManager().getStatsDB();
            LinkedHashMap<UUID, Integer> winsMap = MapSortingUtils.sort(db.getTopTenWins());
            int i = 0;
            for (UUID uuid : winsMap.keySet()) {
                if (i != place - 1) continue;
                return db.getLastKnownName(uuid) + " (" + winsMap.get(uuid) + " wins)";
            }
            return "N/A";
        }
        if (params.toLowerCase().startsWith("top_kills_")) {
            String[] split = params.split("_");
            String num = split[2];
            int place = -1;
            try {
                place = Integer.parseInt(num);
            }
            catch (NumberFormatException e) {
                return "Err: Format should be 'duels_top_kills_#' where '#' is a number between 1-10";
            }
            if (place > 10) {
                return "Err: Format should be 'duels_top_kills_#' where '#' is a number between 1-10";
            }
            StatisticsDatabase db = this.plugin.getStatisticsManager().getStatsDB();
            LinkedHashMap<UUID, Integer> killsMap = MapSortingUtils.sort(db.getTopTenKills());
            int i = 0;
            for (UUID uuid : killsMap.keySet()) {
                if (i != place - 1) continue;
                return db.getLastKnownName(uuid) + " (" + killsMap.get(uuid) + " kills)";
            }
            return "N/A";
        }
        if (params.equalsIgnoreCase("your_kills")) {
            StatisticsDatabase db = this.plugin.getStatisticsManager().getStatsDB();
            int kills = db.getKills(player.getUniqueId());
            return "" + kills;
        }
        if (params.equalsIgnoreCase("your_wins")) {
            StatisticsDatabase db = this.plugin.getStatisticsManager().getStatsDB();
            int wins = db.getWins(player.getUniqueId());
            return "" + wins;
        }
        return null;
    }
}

