/*
 * Decompiled with CFR 0.152.
 */
package me.dartanman.duels.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import me.dartanman.duels.Duels;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;

public class PlayerRestoration {
    private static final HashMap<UUID, SavedPlayerInfo> savedInfo = new HashMap();

    public static void savePlayer(Player player) {
        new SavedPlayerInfo(player);
    }

    public static void restorePlayer(Player player, boolean quitting) {
        if (savedInfo.containsKey(player.getUniqueId())) {
            savedInfo.get(player.getUniqueId()).restore(quitting);
        }
        savedInfo.remove(player.getUniqueId());
    }

    private static class SavedPlayerInfo {
        private UUID uuid;
        private Location location;
        private GameMode gameMode;
        private ItemStack[] inventoryContents;
        private ItemStack[] armorContents;
        private int xpLevel;
        private double health;
        private double maxHealth;
        private Collection<PotionEffect> potionEffects;

        protected SavedPlayerInfo(Player player) {
            if (player == null) {
                return;
            }
            Duels plugin = (Duels)JavaPlugin.getPlugin(Duels.class);
            this.uuid = player.getUniqueId();
            this.location = player.getLocation();
            player.getPersistentDataContainer().set(new NamespacedKey((Plugin)plugin, "world"), PersistentDataType.STRING, (Object)Objects.requireNonNull(this.location.getWorld()).getName());
            player.getPersistentDataContainer().set(new NamespacedKey((Plugin)plugin, "x"), PersistentDataType.INTEGER, (Object)this.location.getBlockX());
            player.getPersistentDataContainer().set(new NamespacedKey((Plugin)plugin, "y"), PersistentDataType.INTEGER, (Object)this.location.getBlockY());
            player.getPersistentDataContainer().set(new NamespacedKey((Plugin)plugin, "z"), PersistentDataType.INTEGER, (Object)this.location.getBlockZ());
            this.gameMode = player.getGameMode();
            this.inventoryContents = player.getInventory().getContents();
            this.armorContents = player.getInventory().getArmorContents();
            this.xpLevel = player.getLevel();
            this.health = player.getHealth();
            this.maxHealth = player.getMaxHealth();
            this.potionEffects = player.getActivePotionEffects();
            savedInfo.put(this.uuid, this);
        }

        protected Player getPlayer() {
            return Bukkit.getPlayer((UUID)this.uuid);
        }

        protected void restore(boolean quitting) {
            this.getPlayer().teleport(this.location);
            this.getPlayer().setGameMode(this.gameMode);
            this.getPlayer().getInventory().setContents(this.inventoryContents);
            this.getPlayer().getInventory().setArmorContents(this.armorContents);
            this.getPlayer().setLevel(this.xpLevel);
            this.getPlayer().setMaxHealth(this.maxHealth);
            this.getPlayer().setHealth(this.health);
            for (PotionEffect effect : this.potionEffects) {
                this.getPlayer().addPotionEffect(effect);
            }
            if (!quitting) {
                Duels plugin = (Duels)JavaPlugin.getPlugin(Duels.class);
                this.getPlayer().getPersistentDataContainer().remove(new NamespacedKey((Plugin)plugin, "world"));
                this.getPlayer().getPersistentDataContainer().remove(new NamespacedKey((Plugin)plugin, "x"));
                this.getPlayer().getPersistentDataContainer().remove(new NamespacedKey((Plugin)plugin, "y"));
                this.getPlayer().getPersistentDataContainer().remove(new NamespacedKey((Plugin)plugin, "z"));
            }
            savedInfo.remove(this.uuid);
        }
    }
}

