/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.clovskins.client.api;

import com.google.gson.JsonObject;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1068;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_8685;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.toast.ToastBuilder;
import ru.kelcuprum.alinlib.info.Player;
import ru.kelcuprum.alinlib.utils.GsonHelper;
import ru.kelcuprum.clovskins.client.ClovSkins;
import ru.kelcuprum.clovskins.client.api.MojangAPI;

public class SkinOption {
    public String name;
    public String skin;
    public String cape;
    public class_8685.class_7920 model;
    public class_8685 playerSkin;
    public SkinType type;
    public File file;
    public static HashMap<String, BufferedImage> resourceLocationMap = new HashMap();
    public static HashMap<String, Boolean> urls = new HashMap();

    public SkinOption(String name, String skin, String cape, class_8685.class_7920 model, SkinType type, File file) {
        this.name = name;
        this.skin = skin;
        this.cape = cape;
        this.model = model;
        this.type = type;
        this.file = file;
    }

    public SkinOption(String name, class_8685 playerSkin, File file) {
        this.name = name;
        this.playerSkin = playerSkin;
        this.skin = playerSkin.comp_1911();
        this.cape = "";
        this.model = playerSkin.comp_1629();
        this.type = SkinType.URL;
        this.file = file;
    }

    public class_8685 getPlayerSkin() throws IOException {
        class_2960 skin = this.playerSkin == null ? this.getTextureSkin() : this.playerSkin.comp_1626();
        class_2960 cape = this.playerSkin == null ? this.getTextureCape() : this.playerSkin.comp_1627();
        class_2960 elytra = this.playerSkin == null ? this.getTextureCape() : this.playerSkin.comp_1628();
        return new class_8685(skin, this.name, cape, elytra, this.model, true);
    }

    public class_2960 getTextureSkin() throws IOException {
        class_2960 location = GuiUtils.getResourceLocation((String)"clovskins", (String)("skins_" + (this.file == null ? this.name.toLowerCase() : this.file.getName())));
        if (this.skin.isBlank()) {
            return class_1068.method_4649();
        }
        if (!ClovSkins.cacheResourceLocations.containsKey(this.skin)) {
            BufferedImage image = this.getSourceSkin();
            if (image == null) {
                return class_1068.method_4649();
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", byteArrayOutputStream);
            ByteArrayInputStream is = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            class_1011 nativeImage = class_1011.method_4309((InputStream)is);
            class_310.method_1551().execute(() -> {
                class_1043 texture = new class_1043(() -> this.name, nativeImage);
                class_310.method_1551().method_1531().method_4616(location, (class_1044)texture);
            });
            ClovSkins.cacheResourceLocations.put(this.skin, location);
        }
        return location;
    }

    public void register2DSkinRender(BufferedImage bufferedImage) throws IOException {
        class_2960 location = GuiUtils.getResourceLocation((String)"skin", (String)this.file.getName());
        BufferedImage bufferedImage1 = new BufferedImage(40, 68, 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage1, "png", byteArrayOutputStream);
        ByteArrayInputStream is = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        class_1011 nativeImage = class_1011.method_4309((InputStream)is);
        class_310.method_1551().execute(() -> {
            class_1043 texture = new class_1043(() -> this.file.getName(), nativeImage);
            class_310.method_1551().method_1531().method_4616(location, (class_1044)texture);
        });
    }

    public class_2960 getTextureCape() {
        return ClovSkins.capes.getOrDefault(this.cape, null);
    }

    public BufferedImage getSourceSkin() throws IOException {
        BufferedImage image = this.getTexture();
        if (image == null) {
            return null;
        }
        if (image.getWidth() > 64 || image.getHeight() > 64) {
            throw new RuntimeException("Too high skin resolution!");
        }
        return image;
    }

    public BufferedImage getTexture() {
        if (resourceLocationMap.containsKey(this.skin)) {
            return resourceLocationMap.get(this.skin);
        }
        if (!urls.getOrDefault(this.skin, false).booleanValue()) {
            urls.put(this.skin, true);
            new Thread(() -> {
                BufferedImage image = null;
                try {
                    switch (this.type.ordinal()) {
                        case 1: {
                            image = ImageIO.read(new URL(this.skin));
                            break;
                        }
                        case 0: {
                            image = ImageIO.read(new File(this.skin));
                            break;
                        }
                        case 2: {
                            try {
                                JsonObject json = MojangAPI.getSkinURL(this.skin);
                                if (json == null) {
                                    return;
                                }
                                this.model = GsonHelper.jsonElementIsNull((String)"metadata.model", (JsonObject)json) ? class_8685.class_7920.field_41123 : class_8685.class_7920.field_41122;
                                image = ImageIO.read(new URL(GsonHelper.getStringInJSON((String)"url", (JsonObject)json, (String)"https://textures.minecraft.net/texture/d5c4ee5ce20aed9e33e866c66caa37178606234b3721084bf01d13320fb2eb3f")));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            break;
                        }
                        case 3: {
                            byte[] what = Base64.getDecoder().decode(this.skin);
                            ByteArrayInputStream hell = new ByteArrayInputStream(what);
                            image = ImageIO.read(hell);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                resourceLocationMap.put(this.skin, image);
            }).start();
        }
        return null;
    }

    public SkinOption setSkinTexture(SkinType type, String skin) {
        this.type = type;
        ClovSkins.cacheResourceLocations.remove(skin);
        this.skin = skin;
        return this;
    }

    public SkinOption setCape(String cape) {
        this.cape = cape;
        return this;
    }

    public void save() throws IOException {
        if (this.file == null) {
            throw new RuntimeException("File == null");
        }
        Files.writeString(this.file.toPath(), (CharSequence)this.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public void delete() throws IOException {
        if (this.file == null) {
            throw new RuntimeException("File == null");
        }
        Files.delete(this.file.toPath());
    }

    public void uploadToMojangAPI() throws IOException {
        if (!ClovSkins.config.getBoolean("UPLOAD_TO_MOJANG", true)) {
            return;
        }
        if (Player.isLicenseAccount()) {
            this.uploadSkinToMojangAPI();
            if (this.cape.isBlank()) {
                this.hideCapeToMojangAPI();
            } else {
                this.activeCapeToMojangAPI();
            }
            if (AlinLib.MINECRAFT.field_1687 != null && !AlinLib.MINECRAFT.method_47392() && !AlinLib.MINECRAFT.method_1542()) {
                new ToastBuilder().setTitle((class_2561)class_2561.method_43470((String)"ClovSkins")).setMessage((class_2561)class_2561.method_43471((String)"clovskins.upload.multiplayer")).setType(ToastBuilder.Type.WARN).setDisplayTime(15000).buildAndShow();
            }
            new ToastBuilder().setTitle((class_2561)class_2561.method_43470((String)"ClovSkins")).setMessage((class_2561)class_2561.method_43469((String)"clovskins.upload.done", (Object[])new Object[]{this.name})).buildAndShow();
        } else {
            ClovSkins.logger.debug("\u041d\u0435 \u0447\u0435\u0442 \u043d\u0435 \u0445\u043e\u0447\u0443");
        }
    }

    public void uploadSkinToMojangAPI() throws IOException {
        if (!ClovSkins.config.getBoolean("UPLOAD_TO_MOJANG", true)) {
            return;
        }
        String accessToken = AlinLib.MINECRAFT.method_1548().method_1674();
        HttpPost http = new HttpPost("https://api.minecraftservices.com/minecraft/profile/skins");
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody("variant", this.model.method_52856().equals("default") ? "classic" : "slim");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.getSourceSkin(), "png", byteArrayOutputStream);
        File file = new File(ClovSkins.getPath() + "/temp/" + System.currentTimeMillis() + ".png");
        Files.write(file.toPath(), byteArrayOutputStream.toByteArray(), new OpenOption[0]);
        builder.addBinaryBody("file", file);
        http.setEntity(builder.build());
        http.addHeader("Authorization", "Bearer " + accessToken);
        HttpResponse response = httpClient.execute((HttpUriRequest)http);
        if (response.getStatusLine().getStatusCode() != 200) {
            file.delete();
            throw new RuntimeException("[SKIN] " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
        }
        ClovSkins.logger.log("ok");
        file.delete();
    }

    public void activeCapeToMojangAPI() throws IOException {
        if (!ClovSkins.config.getBoolean("UPLOAD_TO_MOJANG", true)) {
            return;
        }
        String accessToken = AlinLib.MINECRAFT.method_1548().method_1674();
        HttpPut http = new HttpPut("https://api.minecraftservices.com/minecraft/profile/capes/active");
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("capeId", this.cape);
        http.setEntity((HttpEntity)new StringEntity(jsonObject.toString()));
        http.addHeader("Authorization", "Bearer " + accessToken);
        http.addHeader("Content-Type", "application/json");
        HttpResponse response = httpClient.execute((HttpUriRequest)http);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("[CAPE] " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
        }
        ClovSkins.logger.log("ok");
    }

    public void hideCapeToMojangAPI() throws IOException {
        if (!ClovSkins.config.getBoolean("UPLOAD_TO_MOJANG", true)) {
            return;
        }
        String accessToken = AlinLib.MINECRAFT.method_1548().method_1674();
        HttpDelete http = new HttpDelete("https://api.minecraftservices.com/minecraft/profile/capes/active");
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        http.addHeader("Authorization", "Bearer " + accessToken);
        HttpResponse response = httpClient.execute((HttpUriRequest)http);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("[CAPE] " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
        }
        ClovSkins.logger.log("ok");
    }

    public JsonObject toJSON() {
        return this.toJSON(false);
    }

    public JsonObject toJSON(boolean isServer) {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        json.addProperty("skin", this.skin);
        json.addProperty("cape", this.cape);
        json.addProperty("type", this.type == SkinType.URL ? "url" : (this.type == SkinType.FILE ? "file" : (this.type == SkinType.BASE64 ? "base_64" : "nickname")));
        if (isServer) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.getTexture(), "png", os);
                String name = Base64.getEncoder().encodeToString(os.toByteArray());
                json.addProperty("type", "base_64");
                json.addProperty("skin", name);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        json.addProperty("model", this.model.method_52856());
        return json;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public static SkinOption getSkinOption(File file) throws IOException {
        JsonObject json = class_3518.method_15285((String)Files.readString(file.toPath()));
        SkinType skinType = switch (GsonHelper.getStringInJSON((String)"type", (JsonObject)json, (String)"file")) {
            case "url" -> SkinType.URL;
            case "nickname" -> SkinType.NICKNAME;
            case "base_64" -> SkinType.BASE64;
            default -> SkinType.FILE;
        };
        return new SkinOption(GsonHelper.getStringInJSON((String)"name", (JsonObject)json, (String)"Player skin"), GsonHelper.getStringInJSON((String)"skin", (JsonObject)json, (String)""), GsonHelper.getStringInJSON((String)"cape", (JsonObject)json, (String)""), class_8685.class_7920.method_52857((String)GsonHelper.getStringInJSON((String)"model", (JsonObject)json, (String)"default")), skinType, file);
    }

    public static SkinOption getSkinOption(JsonObject json, File file) {
        SkinType skinType = switch (GsonHelper.getStringInJSON((String)"type", (JsonObject)json, (String)"file")) {
            case "url" -> SkinType.URL;
            case "nickname" -> SkinType.NICKNAME;
            case "base_64" -> SkinType.BASE64;
            default -> SkinType.FILE;
        };
        return new SkinOption(GsonHelper.getStringInJSON((String)"name", (JsonObject)json, (String)"Player skin"), GsonHelper.getStringInJSON((String)"skin", (JsonObject)json, (String)""), GsonHelper.getStringInJSON((String)"cape", (JsonObject)json, (String)""), class_8685.class_7920.method_52857((String)GsonHelper.getStringInJSON((String)"model", (JsonObject)json, (String)"default")), skinType, file);
    }

    public static enum SkinType {
        FILE((class_2561)class_2561.method_43471((String)"clovskins.types.file")),
        URL((class_2561)class_2561.method_43471((String)"clovskins.types.url")),
        NICKNAME((class_2561)class_2561.method_43471((String)"clovskins.types.nickname")),
        BASE64((class_2561)class_2561.method_43470((String)"Base64"));

        final class_2561 name;

        private SkinType(class_2561 name) {
            this.name = name;
        }
    }
}

