/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.clovskins.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpRequest;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1068;
import net.minecraft.class_128;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_437;
import net.minecraft.class_440;
import net.minecraft.class_7920;
import net.minecraft.class_8685;
import net.minecraft.class_8710;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.AlinLogger;
import ru.kelcuprum.alinlib.WebAPI;
import ru.kelcuprum.alinlib.api.events.client.ClientLifecycleEvents;
import ru.kelcuprum.alinlib.config.Config;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.Icons;
import ru.kelcuprum.alinlib.gui.toast.ToastBuilder;
import ru.kelcuprum.alinlib.info.Player;
import ru.kelcuprum.alinlib.utils.GsonHelper;
import ru.kelcuprum.clovskins.client.api.SkinOption;
import ru.kelcuprum.clovskins.client.gui.screen.SkinCustomScreen;
import ru.kelcuprum.clovskins.client.gui.style.VanillaLikeStyle;
import ru.kelcuprum.clovskins.common.packets.HellolPacketPayload;
import ru.kelcuprum.clovskins.common.packets.SkinPresetPacketPayload;

public class ClovSkins
implements ClientModInitializer {
    public static Config pathConfig = new Config("config/ClovSkins/path.config.json");
    public static Config config = new Config(ClovSkins.getPath() + "/config.json");
    public static AlinLogger logger = new AlinLogger("ClovSkins");
    public static class_8685 defaultSkin = class_1068.method_62620();
    public static String cape;
    public static HashMap<String, class_2960> cacheResourceLocations;
    public static SkinOption currentSkin;
    public static SkinOption safeSkinOption;
    public static HashMap<String, SkinOption> skinOptions;
    public static VanillaLikeStyle vanillaLikeStyle;
    public static float TICKS;
    public static HashMap<UUID, SkinOption> playerSkins;
    public static boolean connectedSupportedServer;
    public static HashMap<String, class_2960> capes;
    public static HashMap<String, String> capesAliases;

    public static String getPath() {
        String path = pathConfig.getBoolean("USE_GLOBAL", false) && !FabricLoader.getInstance().isDevelopmentEnvironment() ? (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("win") ? pathConfig.getString("PATH", "{HOME}/ClovSkins") : pathConfig.getString("PATH.UNIX", "/home/${USER}/ClovSkins")) : "config/ClovSkins";
        path = path.replace("{HOME}", System.getProperty("user.home")).replace("{USER}", System.getProperty("user.name"));
        return path;
    }

    public void onInitializeClient() {
        if (AlinLib.isAprilFool()) {
            logger.log("Welcome to the circus!");
        } else {
            logger.log("Welcome to hell!");
        }
        this.checkFolders();
        ClientLifecycleEvents.CLIENT_FULL_STARTED.register(s -> {
            try {
                defaultSkin = class_1068.method_52854((GameProfile)AlinLib.MINECRAFT.method_53462());
                this.loadCapes();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.loadSkins();
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                new ToastBuilder().setTitle((class_2561)class_2561.method_43471((String)"clovskins")).setMessage((class_2561)class_2561.method_43471((String)"clovskins.warning.test_mode")).setIcon(Icons.WARNING).setType(ToastBuilder.Type.WARN).setDisplayTime(10000).buildAndShow();
            }
        });
        ClientPlayConnectionEvents.JOIN.register((s, s1, s2) -> {
            ClientPlayNetworking.send((class_8710)new HellolPacketPayload("peepohuy"));
            ClientPlayNetworking.send((class_8710)new SkinPresetPacketPayload(currentSkin.toJSON(true).toString()));
        });
        ClientPlayConnectionEvents.DISCONNECT.register((s, s1) -> {
            playerSkins.clear();
            connectedSupportedServer = false;
        });
        ClientPlayNetworking.registerGlobalReceiver(HellolPacketPayload.ID, (packet, context) -> {
            connectedSupportedServer = true;
            ClientPlayNetworking.send((class_8710)new SkinPresetPacketPayload(currentSkin.toJSON(true).toString()));
        });
        ClientPlayNetworking.registerGlobalReceiver(SkinPresetPacketPayload.ID, (packet, context) -> {
            JsonObject jsonObject = class_3518.method_15285((String)packet.json());
            UUID uuid = UUID.fromString(jsonObject.get("player").getAsString());
            SkinOption skinOption = SkinOption.getSkinOption(jsonObject, null);
            playerSkins.put(uuid, skinOption);
            logger.log("%s - %s", new Object[]{uuid.toString(), skinOption.toString()});
            new Thread(() -> {
                try {
                    Thread.sleep(2000L);
                    SkinOption.urls.remove(skinOption.skin);
                    SkinOption.resourceLocationMap.remove(skinOption.skin);
                    AlinLib.MINECRAFT.method_1582().field_45634.cleanUp();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
        });
    }

    public void checkFolders() {
        File file = new File(ClovSkins.getPath() + "/skins");
        File fileTemo = new File(ClovSkins.getPath() + "/temp");
        if (!file.exists()) {
            try {
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                AlinLib.MINECRAFT.method_1494(new class_128("Exception while creating a folder", exception.getCause()));
            }
        }
        if (!fileTemo.exists()) {
            try {
                Files.createDirectories(fileTemo.toPath(), new FileAttribute[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                AlinLib.MINECRAFT.method_1494(new class_128("Exception while creating a folder", exception.getCause()));
            }
        }
    }

    public void loadSkins() {
        SkinOption defaultSkin;
        if (Player.isLicenseAccount()) {
            JsonObject defaultSkinData = new JsonObject();
            defaultSkinData.addProperty("name", Player.getName());
            defaultSkinData.addProperty("skin", Player.getName());
            defaultSkinData.addProperty("cape", cape);
            defaultSkinData.addProperty("type", "nickname");
            defaultSkin = SkinOption.getSkinOption(defaultSkinData, new File(ClovSkins.getPath() + "/skins/default.json"));
        } else {
            defaultSkin = new SkinOption("Default skin", "MHF_Steve", "", class_7920.field_41122, SkinOption.SkinType.NICKNAME, new File(ClovSkins.getPath() + "/skins/default.json"));
        }
        try {
            defaultSkin.getTexture();
        }
        catch (Exception defaultSkinData) {
            // empty catch block
        }
        skinOptions.put("default", defaultSkin);
        File skins = new File(ClovSkins.getPath() + "/skins");
        if (!skins.exists() || !skins.isDirectory()) {
            return;
        }
        for (File file : skins.listFiles()) {
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".json")) continue;
            try {
                SkinOption skinOption = SkinOption.getSkinOption(file);
                skinOption.getTexture();
                skinOptions.put(file.getName().substring(0, file.getName().length() - 5), skinOption);
            }
            catch (Exception ex) {
                logger.log("Error during file load");
                ex.printStackTrace();
            }
        }
        currentSkin = skinOptions.getOrDefault(config.getString("SELECTED", "default"), null);
        if (currentSkin == null) {
            currentSkin = skinOptions.get("default");
            config.setString("SELECTED", "default");
        }
    }

    public void loadCapes() throws IOException, InterruptedException {
        if (Player.isLicenseAccount()) {
            JsonObject jsonObject = WebAPI.getJsonObject((HttpRequest.Builder)HttpRequest.newBuilder(URI.create("https://api.minecraftservices.com/minecraft/profile")).header("Authorization", "Bearer " + AlinLib.MINECRAFT.method_1548().method_1674()));
            logger.log(jsonObject.toString());
            if (!GsonHelper.jsonElementIsNull((String)"capes", (JsonObject)jsonObject)) {
                for (JsonElement element : jsonObject.getAsJsonArray("capes")) {
                    JsonObject data = (JsonObject)element;
                    String name = GsonHelper.getStringInJSON((String)"alias", (JsonObject)data, (String)"");
                    String id = GsonHelper.getStringInJSON((String)"id", (JsonObject)data, (String)"");
                    String url = GsonHelper.getStringInJSON((String)"url", (JsonObject)data, (String)"");
                    if (GsonHelper.getStringInJSON((String)"state", (JsonObject)data, (String)"INACTIVE").equalsIgnoreCase("active")) {
                        cape = id;
                    }
                    class_2960 location = GuiUtils.getResourceLocation((String)"clovskins", (String)("cape_" + id.toLowerCase().replace("-", "_")));
                    capesAliases.put(id, name);
                    BufferedImage image = ImageIO.read(new URL(url));
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)image, "png", byteArrayOutputStream);
                    ByteArrayInputStream is = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    class_1011 nativeImage = class_1011.method_4309((InputStream)is);
                    class_1043 texture = new class_1043(() -> name, nativeImage);
                    class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4616(location, (class_1044)texture));
                    cacheResourceLocations.put(url, location);
                    capes.put(id, location);
                }
            }
        } else if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            capes.put("test", GuiUtils.getResourceLocation((String)"clovskins", (String)"cape/test.png"));
            capesAliases.put("test", "\u0422\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u043f\u043b\u0430\u0449");
        }
    }

    public static class_437 getSkinCustom(class_437 parent) {
        return config.getBoolean("MENU.CHANGE_DEFAULT_UI", true) ? new SkinCustomScreen(parent, AlinLib.MINECRAFT.field_1690) : new class_440(parent, AlinLib.MINECRAFT.field_1690);
    }

    static {
        cacheResourceLocations = new HashMap();
        currentSkin = null;
        safeSkinOption = new SkinOption("default", "MHF_Steve", "", class_7920.field_41122, SkinOption.SkinType.NICKNAME, new File(ClovSkins.getPath() + "/skins/safe.temp.json"));
        skinOptions = new HashMap();
        vanillaLikeStyle = new VanillaLikeStyle();
        TICKS = 0.0f;
        playerSkins = new HashMap();
        connectedSupportedServer = false;
        capes = new HashMap();
        capesAliases = new HashMap();
    }
}

