/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.clovskins.server.objects;

import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import ru.kelcuprum.alinlib.utils.GsonHelper;

public class SkinOption {
    public String name;
    public String skin;
    public String cape;
    public String model;
    public SkinType type;

    public SkinOption(String name, String skin, String cape, String model, SkinType type) {
        this.name = name;
        this.skin = skin;
        this.cape = cape;
        this.model = model;
        this.type = type;
    }

    public JsonObject toJSON() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        json.addProperty("skin", this.skin);
        json.addProperty("cape", this.cape);
        json.addProperty("type", this.type == SkinType.URL ? "url" : (this.type == SkinType.FILE ? "file" : (this.type == SkinType.BASE64 ? "base_64" : "nickname")));
        json.addProperty("model", this.model);
        return json;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public static SkinOption getSkinOption(JsonObject json) {
        SkinType skinType = switch (GsonHelper.getStringInJSON((String)"type", (JsonObject)json, (String)"file")) {
            case "url" -> SkinType.URL;
            case "nickname" -> SkinType.NICKNAME;
            case "base_64" -> SkinType.BASE64;
            default -> SkinType.FILE;
        };
        return new SkinOption(GsonHelper.getStringInJSON((String)"name", (JsonObject)json, (String)"Player skin"), GsonHelper.getStringInJSON((String)"skin", (JsonObject)json, (String)""), GsonHelper.getStringInJSON((String)"cape", (JsonObject)json, (String)""), GsonHelper.getStringInJSON((String)"model", (JsonObject)json, (String)"default"), skinType);
    }

    public static enum SkinType {
        FILE((class_2561)class_2561.method_43471((String)"clovskins.types.file")),
        URL((class_2561)class_2561.method_43471((String)"clovskins.types.url")),
        NICKNAME((class_2561)class_2561.method_43471((String)"clovskins.types.nickname")),
        BASE64((class_2561)class_2561.method_43470((String)"Base64"));

        final class_2561 name;

        private SkinType(class_2561 name) {
            this.name = name;
        }
    }
}

