/*
 * Decompiled with CFR 0.152.
 */
package com.overcontrol1.mcreatormemfix;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import com.overcontrol1.mcreatormemfix.ModConfigEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public record ModConfig(List<ModConfigEntry> entries, int spec, long hash) {
    public static final String FILE_NAME = "mcreator_mem_fix.json";
    public static final Path PATH = FMLPaths.CONFIGDIR.get().resolve("mcreator_mem_fix.json");
    public static final int CURRENT_SPEC = 0;
    public static boolean REQUIRES_REGENERATION = false;
    public static boolean REGENERATION_LOCKED = false;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static ModConfig instance;

    public static ModConfig instance() {
        return instance;
    }

    public static void clear() {
        instance = null;
    }

    public static void load() {
        if (!Files.exists(PATH, new LinkOption[0])) {
            REQUIRES_REGENERATION = true;
            instance = new ModConfig(List.of(), -1, 0L);
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(PATH);){
            long hash;
            JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonPrimitive specJson = object.getAsJsonPrimitive("spec");
            int spec = specJson == null ? -1 : specJson.getAsInt();
            JsonPrimitive lockedJson = object.getAsJsonPrimitive("locked");
            REGENERATION_LOCKED = lockedJson != null && lockedJson.getAsBoolean();
            ArrayList<ModConfigEntry> entries = new ArrayList<ModConfigEntry>();
            JsonArray mods = object.getAsJsonArray("mods");
            for (JsonElement e : mods) {
                JsonObject o = e.getAsJsonObject();
                entries.add(new ModConfigEntry(o.get("package").getAsJsonPrimitive().getAsString(), o.get("className").getAsJsonPrimitive().getAsString()));
            }
            JsonPrimitive hashJson = object.getAsJsonPrimitive("hash");
            if (hashJson == null) {
                REQUIRES_REGENERATION = true;
                hash = -1L;
            } else {
                hash = Long.parseLong(hashJson.getAsString(), 16);
            }
            instance = new ModConfig(entries, spec, hash);
        }
        catch (IOException | IllegalStateException e) {
            throw new RuntimeException("[MCreatorMemFix] Error occurred loading config: %s".formatted(e));
        }
    }

    public void save() {
        JsonArray modsArray = new JsonArray();
        for (ModConfigEntry entry : this.entries) {
            JsonObject object = new JsonObject();
            object.addProperty("package", entry.packageName());
            object.addProperty("className", entry.className());
            modsArray.add((JsonElement)object);
        }
        JsonObject outerObject = new JsonObject();
        outerObject.add("mods", (JsonElement)modsArray);
        outerObject.addProperty("spec", (Number)this.spec);
        outerObject.addProperty("hash", Long.toHexString(this.hash));
        try (JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(PATH, new OpenOption[0]));){
            gson.toJson((JsonElement)outerObject, writer);
        }
        catch (IOException e) {
            throw new RuntimeException("[MCreatorMemFix] Error occurred saving config: %s".formatted(e));
        }
    }
}

