/*
 * Decompiled with CFR 0.152.
 */
package com.overcontrol1.mcreatormemfix.asm;

import com.overcontrol1.mcreatormemfix.ModConfig;
import com.overcontrol1.mcreatormemfix.ModConfigEntry;
import com.overcontrol1.mcreatormemfix.Reflections;
import com.overcontrol1.mcreatormemfix.asm.DefaultVariableClassWriter;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.spongepowered.asm.service.MixinService;

public class MCreatorVariableTransformer
implements ILaunchPluginService {
    private static final EnumSet<ILaunchPluginService.Phase> YAY = EnumSet.of(ILaunchPluginService.Phase.BEFORE);
    private static final EnumSet<ILaunchPluginService.Phase> NAY = EnumSet.noneOf(ILaunchPluginService.Phase.class);
    private static final Map<String, VariableTransformationProfile> transformationProfiles = new Object2ObjectArrayMap();
    private static final String STORAGE_INTERNAL_CLASS_NAME = "com/overcontrol1/mcreatormemfix/MCreatorPlayerVariablesStorage";

    public MCreatorVariableTransformer() {
        ModConfig.load();
        for (ModConfigEntry entry : ModConfig.instance().entries()) {
            this.generateTransformationProfile(entry);
        }
    }

    public String name() {
        return "mcreator_mem_fix";
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        if (classType.getInternalName().equals(STORAGE_INTERNAL_CLASS_NAME)) {
            return YAY;
        }
        if (isEmpty) {
            return NAY;
        }
        for (ModConfigEntry entry : ModConfig.instance().entries()) {
            if (!classType.getClassName().startsWith(entry.packageName())) continue;
            return YAY;
        }
        return NAY;
    }

    public boolean processClass(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType) {
        if (classType.getInternalName().equals(STORAGE_INTERNAL_CLASS_NAME)) {
            this.processStorageClass(classNode, classType);
            return true;
        }
        VariableTransformationProfile variableTransformationProfile = this.getGeneratedMetadata(classType);
        boolean modified = false;
        for (MethodNode method : classNode.methods) {
            InsnList insns = method.instructions;
            for (int i = 0; i < insns.size(); ++i) {
                AbstractInsnNode abstractInsnNode;
                AbstractInsnNode abstractInsnNode2;
                AbstractInsnNode dup;
                AbstractInsnNode insn = insns.get(i);
                if (!(insn instanceof TypeInsnNode)) continue;
                TypeInsnNode typeInsn = (TypeInsnNode)insn;
                if (insn.getOpcode() != 187 || !typeInsn.desc.equals(variableTransformationProfile.innerClassInternalName) || (dup = MCreatorVariableTransformer.nextCodeInsn(insn)).getOpcode() != 89 || !((abstractInsnNode2 = MCreatorVariableTransformer.nextCodeInsn(dup)) instanceof MethodInsnNode)) continue;
                MethodInsnNode ctor = (MethodInsnNode)abstractInsnNode2;
                if (!ctor.name.equals("<init>") || !ctor.owner.equals(typeInsn.desc) || !((abstractInsnNode = MCreatorVariableTransformer.nextCodeInsn((AbstractInsnNode)ctor)) instanceof MethodInsnNode)) continue;
                MethodInsnNode orElse = (MethodInsnNode)abstractInsnNode;
                if (!orElse.name.equals("orElse") || !orElse.desc.equals("(Ljava/lang/Object;)Ljava/lang/Object;")) continue;
                modified = true;
                insns.remove((AbstractInsnNode)ctor);
                insns.remove(dup);
                insns.remove((AbstractInsnNode)typeInsn);
                MethodInsnNode staticCall = MCreatorVariableTransformer.staticCall(variableTransformationProfile.lowercaseModName);
                insns.insertBefore((AbstractInsnNode)orElse, (AbstractInsnNode)staticCall);
                orElse.name = "orElseGet";
                orElse.desc = "(Lnet/minecraftforge/common/util/NonNullSupplier;)Ljava/lang/Object;";
                i = Math.max(i - 3, 0);
            }
        }
        return modified;
    }

    private void processStorageClass(ClassNode classNode, Type classType) {
        for (VariableTransformationProfile profile : transformationProfiles.values()) {
            MethodNode supplierMethod = DefaultVariableClassWriter.createStaticSupplierMethod(classType.getInternalName(), profile.lowercaseModName, profile.innerClassInternalName);
            MethodNode lambda = DefaultVariableClassWriter.createLambda(classType.getInternalName(), profile.lowercaseModName, profile.innerClassInternalName);
            FieldNode staticField = DefaultVariableClassWriter.createField(classType.getInternalName(), profile.lowercaseModName, profile.innerClassInternalName);
            boolean hasProcessedClinit = false;
            for (MethodNode methodNode : classNode.methods) {
                if (!methodNode.name.equals("<clinit>")) continue;
                DefaultVariableClassWriter.addFieldInit(methodNode, classType.getInternalName(), profile.lowercaseModName, profile.innerClassInternalName);
                hasProcessedClinit = true;
                break;
            }
            if (!hasProcessedClinit) {
                MethodNode clinit = DefaultVariableClassWriter.createClinit();
                clinit.instructions.add((AbstractInsnNode)new LabelNode());
                clinit.instructions.add((AbstractInsnNode)new InsnNode(177));
                DefaultVariableClassWriter.addFieldInit(clinit, classType.getInternalName(), profile.lowercaseModName, profile.innerClassInternalName);
                classNode.methods.add(clinit);
            }
            classNode.methods.add(supplierMethod);
            classNode.methods.add(lambda);
            classNode.fields.add(staticField);
        }
    }

    private VariableTransformationProfile getGeneratedMetadata(Type classType) {
        ModConfigEntry chosenEntry = null;
        ModConfig config = ModConfig.instance();
        List<ModConfigEntry> entries = config.entries();
        for (ModConfigEntry entry : entries) {
            if (!classType.getClassName().startsWith(entry.packageName())) continue;
            chosenEntry = entry;
            break;
        }
        if (chosenEntry == null) {
            throw new IllegalStateException("Something went wrong generating a template storage.");
        }
        VariableTransformationProfile profile = transformationProfiles.get(chosenEntry.packageName());
        if (profile != null) {
            return profile;
        }
        throw new IllegalStateException("Something went wrong. Tried to get a generated variable storage when none existed for " + chosenEntry.packageName() + ". This might mean a malformed config. Loaded config: %s, template profiles: %s".formatted(entries, transformationProfiles));
    }

    private void generateTransformationProfile(ModConfigEntry entry) {
        String outerClassName = entry.packageName() + ".network." + entry.className() + "ModVariables";
        String outerClassInternalName = outerClassName.replace('.', '/');
        String innerClassInternalName = outerClassInternalName + "$PlayerVariables";
        try {
            MixinService.getService().getBytecodeProvider().getClassNode(innerClassInternalName);
        }
        catch (IOException | ClassNotFoundException e) {
            return;
        }
        transformationProfiles.put(entry.packageName(), new VariableTransformationProfile(outerClassName, outerClassInternalName, innerClassInternalName, entry.className().toLowerCase()));
    }

    private static MethodInsnNode staticCall(String lowercaseClassName) {
        return new MethodInsnNode(184, STORAGE_INTERNAL_CLASS_NAME, "get_variables_" + lowercaseClassName, "()Lnet/minecraftforge/common/util/NonNullSupplier;", false);
    }

    private static AbstractInsnNode nextCodeInsn(AbstractInsnNode insn) {
        AbstractInsnNode next = insn.getNext();
        while (!MCreatorVariableTransformer.isCodeInsn(next)) {
            next = next.getNext();
        }
        return next;
    }

    private static boolean isCodeInsn(AbstractInsnNode insn) {
        int type = insn.getType();
        return type != 8 && type != 15 && type != 14;
    }

    private static void dumpClassNode(ClassNode classNode, Type classType) {
        String[] dirs = classType.getInternalName().split("/");
        dirs[dirs.length - 1] = dirs[dirs.length - 1] + ".class";
        String[] trimmedDirs = Arrays.copyOf(dirs, dirs.length - 1);
        Path dirPath = Path.of("transformed_classes", trimmedDirs);
        Path filePath = dirPath.resolve(dirs[dirs.length - 1]);
        try {
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try (BufferedOutputStream fileWriter = new BufferedOutputStream(Files.newOutputStream(filePath, new OpenOption[0]));){
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            byte[] bytecode = classWriter.toByteArray();
            fileWriter.write(bytecode);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void inject() throws Throwable {
        LaunchPluginHandler handler = Reflections.HANDLE.findVarHandle(Launcher.class, "launchPlugins", LaunchPluginHandler.class).get(Launcher.INSTANCE);
        Map plugins = Reflections.HANDLE.findVarHandle(LaunchPluginHandler.class, "plugins", Map.class).get(handler);
        MCreatorVariableTransformer transformer = new MCreatorVariableTransformer();
        plugins.put(transformer.name(), transformer);
    }

    private record VariableTransformationProfile(String outerClassName, String outerClassInternalName, String innerClassInternalName, String lowercaseModName) {
    }
}

