/*
 * Decompiled with CFR 0.152.
 */
package com.overcontrol1.mcreatormemfix;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.overcontrol1.mcreatormemfix.asm.MCreatorVariableTransformer;
import it.unimi.dsi.fastutil.Pair;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.service.MixinService;

@Mod(value="mcreator_mem_fix")
public class MCreatorMemFix {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"MCreatorMemFix");
    public static final String MOD_ID = "mcreator_mem_fix";
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public MCreatorMemFix(FMLJavaModLoadingContext ctx) {
        ctx.getModEventBus().addListener(this::onCommonSetup);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        if (MCreatorVariableTransformer.NEEDS_SCANNING) {
            ArrayList<Pair<String, String>> mcreatorMods = new ArrayList<Pair<String, String>>();
            ModList.get().forEachModContainer((id, container) -> {
                Object mod = container.getMod();
                Class<?> clazz = mod.getClass();
                String simpleName = clazz.getSimpleName();
                String packageName = clazz.getPackageName();
                String variablePackageName = packageName + ".network." + simpleName + "Variables";
                try {
                    MixinService.getService().getBytecodeProvider().getClassNode(variablePackageName);
                    String simpleNameWithoutMod = simpleName.substring(0, simpleName.length() - 3);
                    mcreatorMods.add(Pair.of((Object)packageName, (Object)simpleNameWithoutMod));
                }
                catch (IOException | ClassNotFoundException exception) {
                    // empty catch block
                }
            });
            this.outputToFile(mcreatorMods);
            LOGGER.warn("[MCreatorMemFix] Scanned {} new MCreator mods in this environment. RESTART RECOMMENDED.", (Object)mcreatorMods.size());
        }
    }

    private void outputToFile(List<Pair<String, String>> mcreatorMods) {
        Path path = MCreatorVariableTransformer.CONFIG_PATH;
        JsonArray modsArray = new JsonArray();
        for (Pair<String, String> packageClassNamePair : mcreatorMods) {
            JsonObject object = new JsonObject();
            object.addProperty("package", (String)packageClassNamePair.first());
            object.addProperty("className", (String)packageClassNamePair.right());
            modsArray.add((JsonElement)object);
        }
        JsonObject outerObject = new JsonObject();
        outerObject.add("mods", (JsonElement)modsArray);
        try (JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(path, new OpenOption[0]));){
            gson.toJson((JsonElement)outerObject, writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

