/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.github.stainlessstasis.alert.AlertHandler;
import io.github.stainlessstasis.core.CobblemonSpawnAlerts;
import io.github.stainlessstasis.core.CommandRegistry;
import io.github.stainlessstasis.network.AlertDataPacket;
import io.github.stainlessstasis.network.DespawnDataPacket;
import io.github.stainlessstasis.network.ModLoadedPacket;
import io.github.stainlessstasis.network.PacketHandlers;
import io.github.stainlessstasis.network.PokemonDataPacket;
import io.github.stainlessstasis.util.EvsUtil;
import io.github.stainlessstasis.util.MessageUtils;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class CSAFabricClient
implements ClientModInitializer {
    public static boolean doesServerHaveMod = false;

    public void onInitializeClient() {
        CobblemonSpawnAlerts.initClient();
        ClientPlayConnectionEvents.DISCONNECT.register(this::onDisconnect);
        ClientLifecycleEvents.CLIENT_STOPPING.register(this::onClientStop);
        ClientPlayConnectionEvents.JOIN.register(this::onJoin);
        ClientEntityEvents.ENTITY_LOAD.register(this::onEntityLoad);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, context) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"csa").then(ClientCommandManager.literal((String)"reload").executes(ctx -> CommandRegistry.handleReloadCommand()))).then(ClientCommandManager.literal((String)"openconfig").executes(ctx -> CommandRegistry.handleOpenConfigCommand()))).then(ClientCommandManager.literal((String)"glow").then(ClientCommandManager.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String uuidString = (String)ctx.getArgument("uuid", String.class);
            return CommandRegistry.handleGlowCommand(uuidString);
        })))));
        ClientPlayNetworking.registerGlobalReceiver(PokemonDataPacket.ID, (payload, context) -> context.client().execute(() -> PacketHandlers.handlePokemonDataPacket(payload.pokemonNetworkID(), payload.ivs(), payload.evYield(), payload.nature(), payload.ability())));
        ClientPlayNetworking.registerGlobalReceiver(AlertDataPacket.ID, (payload, context) -> context.client().execute(() -> PacketHandlers.handleAlertDataPacket(payload)));
        ClientPlayNetworking.registerGlobalReceiver(DespawnDataPacket.ID, (payload, context) -> context.client().execute(() -> PacketHandlers.handleDespawnDataPacket(payload)));
        ClientPlayNetworking.registerGlobalReceiver(ModLoadedPacket.ID, (payload, context) -> context.client().execute(() -> {
            doesServerHaveMod = true;
        }));
    }

    private void onJoin(class_634 clientPacketListener, PacketSender packetSender, class_310 minecraft) {
        if (!minecraft.method_47392() && CobblemonSpawnAlerts.CLIENT_CONFIG_MANAGER.getMainConfig().multiplayerWarning()) {
            MessageUtils.sendTranslated("cobblemon-spawn-alerts.multiplayer_warning", new Object[0]);
        }
    }

    private void onClientStop(class_310 minecraft) {
        AlertHandler.clearCache();
        EvsUtil.clearCache();
        doesServerHaveMod = false;
    }

    private void onDisconnect(class_634 clientPacketListener, class_310 minecraft) {
        AlertHandler.clearCache();
        EvsUtil.clearCache();
        doesServerHaveMod = false;
    }

    private void onEntityLoad(class_1297 entity, class_638 clientLevel) {
        if (entity instanceof PokemonEntity) {
            PokemonEntity pe = (PokemonEntity)entity;
            if (!doesServerHaveMod) {
                AlertHandler.alertClientside(pe);
            }
        }
    }
}

