/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis.alert;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.pokedex.PokedexEntryProgress;
import com.cobblemon.mod.common.api.pokedex.SpeciesDexRecord;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.storage.player.client.ClientPokedexManager;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.EVs;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.mojang.datafixers.util.Pair;
import io.github.stainlessstasis.alert.DespawnReason;
import io.github.stainlessstasis.alert.StatDisplayMode;
import io.github.stainlessstasis.config.MainConfig;
import io.github.stainlessstasis.config.MessageTemplates;
import io.github.stainlessstasis.config.PokemonConfig;
import io.github.stainlessstasis.core.CobblemonSpawnAlerts;
import io.github.stainlessstasis.network.AlertDataPacket;
import io.github.stainlessstasis.network.DespawnDataPacket;
import io.github.stainlessstasis.network.PokemonSpawnData;
import io.github.stainlessstasis.network.PokemonStats;
import io.github.stainlessstasis.network.PokemonTraits;
import io.github.stainlessstasis.platform.Platform;
import io.github.stainlessstasis.platform.Services;
import io.github.stainlessstasis.util.BiomeUtil;
import io.github.stainlessstasis.util.ComponentUtil;
import io.github.stainlessstasis.util.EvsUtil;
import io.github.stainlessstasis.util.HiddenAbilityUtil;
import io.github.stainlessstasis.util.MessageUtils;
import io.github.stainlessstasis.util.PokemonNameUtil;
import io.github.stainlessstasis.util.RarityUtil;
import io.github.stainlessstasis.util.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import org.joml.Vector3f;

public class AlertHandler {
    private static final HashSet<UUID> alreadyAlerted = new HashSet();

    public static void clearCache() {
        alreadyAlerted.clear();
    }

    public static void alertClientside(PokemonEntity pokemonEntity) {
        EVs defaultEVYield = EvsUtil.getYield(pokemonEntity.getPokemon().getSpecies().getNationalPokedexNumber());
        AlertHandler.alertClientside(pokemonEntity, defaultEVYield);
    }

    public static void alertClientside(PokemonEntity pokemonEntity, EVs evYield) {
        if (pokemonEntity.method_6139() != null) {
            return;
        }
        String nearestPlayerName = "N/A";
        class_746 class_7462 = class_310.method_1551().field_1724;
        if (class_7462 instanceof class_1657) {
            class_746 player = class_7462;
            nearestPlayerName = player.method_5477().getString();
        }
        Pokemon pokemon = pokemonEntity.getPokemon();
        String pokemonName = PokemonNameUtil.getTranslatedName(pokemon);
        int dexId = pokemon.getSpecies().getNationalPokedexNumber();
        AlertHandler.alert(new AlertDataPacket(new PokemonSpawnData(pokemonName, pokemon.getUuid(), pokemonEntity.method_19538().method_46409(), pokemon.getSpecies().getNationalPokedexNumber(), nearestPlayerName, BiomeUtil.getBiomeKeyFromCoords(pokemonEntity.method_37908(), pokemonEntity.method_19538())), new PokemonStats(pokemon.getLevel(), pokemon.getIvs(), evYield), new PokemonTraits(pokemon.getShiny(), RarityUtil.isLegendary(dexId), RarityUtil.isMythical(dexId), RarityUtil.isUltraBeast(dexId), RarityUtil.isParadox(dexId), RarityUtil.isStarter(dexId)), pokemon.getNature().getName().method_12832(), pokemon.getAbility().getName(), pokemon.getGender().name()));
    }

    public static void alert(AlertDataPacket alertData) {
        String message;
        boolean shouldAlertNotInConfig;
        int level;
        class_746 class_7462 = class_310.method_1551().field_1724;
        if (!(class_7462 instanceof class_1657)) {
            return;
        }
        class_746 player = class_7462;
        if (CobblemonSpawnAlerts.CLIENT_CONFIG_MANAGER.isReloading()) {
            return;
        }
        if (alreadyAlerted.contains(alertData.spawnData().pokemonUUID())) {
            return;
        }
        MainConfig mainConfig = CobblemonSpawnAlerts.CLIENT_CONFIG_MANAGER.getMainConfig();
        ClientPokedexManager dex = CobblemonClient.INSTANCE.getClientPokedexData();
        String pokemonName = PokemonNameUtil.getTranslatedName(alertData.spawnData().translatedPokemonName());
        Pair<Boolean, PokemonConfig.PokemonSpecificConfig> result = AlertHandler.getConfigForPokemon(pokemonName);
        boolean isInConfig = (Boolean)result.getFirst();
        PokemonConfig.PokemonSpecificConfig pokemonConfig = (PokemonConfig.PokemonSpecificConfig)result.getSecond();
        if (!pokemonConfig.enabled()) {
            return;
        }
        boolean isShiny = alertData.traits().isShiny();
        boolean isLegend = alertData.traits().isLegendary();
        boolean isMythical = alertData.traits().isMythical();
        boolean isUltra = alertData.traits().isUltraBeast();
        boolean isParadox = alertData.traits().isParadox();
        boolean isStarter = alertData.traits().isStarter();
        boolean isInDex = false;
        boolean isCaught = false;
        boolean shouldAlertShiny = isInConfig ? isShiny && pokemonConfig.alertShiny() || mainConfig.alertAllShinies() : isShiny && mainConfig.alertAllShinies();
        boolean shouldAlertLegend = isLegend && mainConfig.alertAllLegendaries();
        boolean shouldAlertMythical = isMythical && mainConfig.alertAllMythicals();
        boolean shouldAlertUltra = isUltra && mainConfig.alertAllUltraBeasts();
        boolean shouldAlertParadox = isParadox && mainConfig.alertAllParadox();
        boolean shouldAlertStarter = isStarter && mainConfig.alertAllStarter();
        boolean shouldAlertNotInDex = mainConfig.alertAllNotInDex();
        boolean shouldAlertUncaught = mainConfig.alertAllUncaught();
        Species species = PokemonSpecies.INSTANCE.getByPokedexNumber(alertData.spawnData().dexId(), "cobblemon");
        SpeciesDexRecord record = dex.getSpeciesRecord(species.resourceIdentifier);
        if (record != null) {
            shouldAlertNotInDex = false;
            isInDex = true;
            if (record.hasAtLeast(PokedexEntryProgress.CAUGHT)) {
                shouldAlertUncaught = false;
                isCaught = true;
            }
        }
        boolean shouldAlertHA = HiddenAbilityUtil.hasHiddenAbility(species, alertData.abilityID());
        MainConfig.IVHunting ivHunting = mainConfig.ivHunting();
        MainConfig.EVHunting evHunting = mainConfig.evHunting();
        boolean shouldAlertIVs = false;
        if (ivHunting.enabled()) {
            IVs ivs = alertData.stats().ivs();
            boolean meetsMinReqs = false;
            if (ivHunting.requireAllMinimumsMet()) {
                if (!(ivHunting.minHp() > 0 && ivs.get((Stat)Stats.HP) < ivHunting.minHp() || ivHunting.minAtk() > 0 && ivs.get((Stat)Stats.ATTACK) < ivHunting.minAtk() || ivHunting.minDef() > 0 && ivs.get((Stat)Stats.DEFENCE) < ivHunting.minDef() || ivHunting.minSpAtk() > 0 && ivs.get((Stat)Stats.SPECIAL_ATTACK) < ivHunting.minSpAtk() || ivHunting.minSpDef() > 0 && ivs.get((Stat)Stats.SPECIAL_DEFENCE) < ivHunting.minSpDef() || ivHunting.minSpeed() > 0 && ivs.get((Stat)Stats.SPEED) < ivHunting.minSpeed())) {
                    meetsMinReqs = true;
                }
            } else if (ivHunting.minHp() > 0 && ivs.get((Stat)Stats.HP) >= ivHunting.minHp() || ivHunting.minAtk() > 0 && ivs.get((Stat)Stats.ATTACK) >= ivHunting.minAtk() || ivHunting.minDef() > 0 && ivs.get((Stat)Stats.DEFENCE) >= ivHunting.minDef() || ivHunting.minSpAtk() > 0 && ivs.get((Stat)Stats.SPECIAL_ATTACK) >= ivHunting.minSpAtk() || ivHunting.minSpDef() > 0 && ivs.get((Stat)Stats.SPECIAL_DEFENCE) >= ivHunting.minSpDef() || ivHunting.minSpeed() > 0 && ivs.get((Stat)Stats.SPEED) >= ivHunting.minSpeed()) {
                meetsMinReqs = true;
            }
            AtomicInteger numPerfect = new AtomicInteger();
            ivs.forEach(iv -> {
                if ((Integer)iv.getValue() >= 31) {
                    numPerfect.getAndIncrement();
                }
            });
            shouldAlertIVs = numPerfect.get() >= ivHunting.minPerfectIVs() && meetsMinReqs;
        }
        boolean shouldAlertEVs = false;
        if (evHunting.enabled()) {
            EVs evs = alertData.stats().evYield();
            shouldAlertEVs = evHunting.minHp() > 0 && evs.get((Stat)Stats.HP) >= evHunting.minHp() || evHunting.minAtk() > 0 && evs.get((Stat)Stats.ATTACK) >= evHunting.minAtk() || evHunting.minDef() > 0 && evs.get((Stat)Stats.DEFENCE) >= evHunting.minDef() || evHunting.minSpAtk() > 0 && evs.get((Stat)Stats.SPECIAL_ATTACK) >= evHunting.minSpAtk() || evHunting.minSpDef() > 0 && evs.get((Stat)Stats.SPECIAL_DEFENCE) >= evHunting.minSpDef() || evHunting.minSpeed() > 0 && evs.get((Stat)Stats.SPEED) >= evHunting.minSpeed();
        }
        MainConfig.LevelFilter levelFilter = mainConfig.levelFilter();
        boolean passesLevelFilter = true;
        if (levelFilter.enabled() && ((level = alertData.stats().level()) < levelFilter.minLevel() || level > levelFilter.maxLevel())) {
            passesLevelFilter = false;
        }
        boolean shouldAlertInConfig = pokemonConfig.alwaysAlert() || shouldAlertShiny;
        boolean bl = shouldAlertNotInConfig = passesLevelFilter && (shouldAlertShiny || shouldAlertLegend || shouldAlertMythical || shouldAlertUltra || shouldAlertParadox || shouldAlertStarter || shouldAlertNotInDex || shouldAlertUncaught || mainConfig.alertEverything() || shouldAlertIVs || shouldAlertEVs || shouldAlertHA);
        if (isInConfig ? !shouldAlertInConfig : !shouldAlertNotInConfig) {
            return;
        }
        alreadyAlerted.add(alertData.spawnData().pokemonUUID());
        if (!Objects.equals(pokemonConfig.customAlertSound(), "")) {
            String[] split = StringUtil.splitIdentifier(pokemonConfig.customAlertSound());
            if (!split[0].equals("NO NAMESPACE")) {
                class_2960 resourceLocation = class_2960.method_60655((String)split[0], (String)split[1]);
                class_3414 sound = class_3414.method_47909((class_2960)resourceLocation, (float)-1.0f);
                player.method_17356(sound, class_3419.field_15250, 1.0f, 1.0f);
            } else {
                player.method_43496(ComponentUtil.convertFromAdventure(MessageUtils.getTranslated("cobblemon-spawn-alerts.outdated_sound", new Object[0])));
            }
        } else {
            HashMap<String, Boolean> traits = new HashMap<String, Boolean>();
            traits.put("shiny", isShiny);
            traits.put("legendary", isLegend);
            traits.put("mythical", isMythical);
            traits.put("ultrabeast", isUltra);
            traits.put("paradox", isParadox);
            traits.put("starter", isStarter);
            traits.put("unregistered", !isInDex);
            traits.put("uncaught", !isCaught);
            traits.put("ivs", shouldAlertIVs);
            traits.put("evs", shouldAlertEVs);
            for (String soundTrait : pokemonConfig.sounds().keySet()) {
                String soundID = pokemonConfig.sounds().get(soundTrait);
                if (!((Boolean)traits.get(soundTrait)).booleanValue() || soundID.isEmpty()) continue;
                String[] split = StringUtil.splitIdentifier(soundID);
                if (!split[0].equals("NO NAMESPACE")) {
                    class_2960 resourceLocation = class_2960.method_60655((String)split[0], (String)split[1]);
                    class_3414 sound = class_3414.method_47909((class_2960)resourceLocation, (float)-1.0f);
                    player.method_17356(sound, class_3419.field_15250, 1.0f, 1.0f);
                    continue;
                }
                player.method_43496(ComponentUtil.convertFromAdventure(MessageUtils.getTranslated("cobblemon-spawn-alerts.outdated_sound", new Object[0])));
            }
        }
        if (pokemonConfig.autoGlow()) {
            CobblemonSpawnAlerts.glowing.add(alertData.spawnData().pokemonUUID());
        }
        if (!Objects.equals(pokemonConfig.customAlertMessage(), "")) {
            message = AlertHandler.applyDynamicReplacements(pokemonConfig.customAlertMessage(), pokemonConfig, alertData);
            MessageUtils.sendTranslated(message, new Object[0]);
            return;
        }
        message = MessageUtils.getTranslated(CobblemonSpawnAlerts.CLIENT_CONFIG_MANAGER.getMessageTemplates().fullSpawnMessage(), new Object[0]);
        message = AlertHandler.applyDynamicReplacements(message, pokemonConfig, alertData);
        class_2561 component = ComponentUtil.convertFromAdventure(message);
        player.method_43496(component);
    }

    public static void alertDespawned(DespawnDataPacket despawnData) {
        class_746 class_7462 = class_310.method_1551().field_1724;
        if (!(class_7462 instanceof class_1657)) {
            return;
        }
        class_746 player = class_7462;
        if (CobblemonSpawnAlerts.CLIENT_CONFIG_MANAGER.isReloading()) {
            return;
        }
        MessageTemplates messageTemplates = CobblemonSpawnAlerts.CLIENT_CONFIG_MANAGER.getMessageTemplates();
        String message = MessageUtils.getTranslated(CobblemonSpawnAlerts.CLIENT_CONFIG_MANAGER.getMessageTemplates().despawnMessage(), new Object[0]);
        message = switch (DespawnReason.valueOf(despawnData.despawnReason())) {
            default -> throw new MatchException(null, null);
            case DespawnReason.CAPTURED -> message.replace("{despawned}", class_2561.method_43469((String)messageTemplates.despawnReason_Captured(), (Object[])new Object[]{despawnData.playerName()}).getString());
            case DespawnReason.DESPAWNED -> message.replace("{despawned}", class_2561.method_43471((String)messageTemplates.despawnReason_Despawned()).getString());
            case DespawnReason.FAINTED -> message.replace("{despawned}", class_2561.method_43469((String)messageTemplates.despawnReason_Fainted(), (Object[])new Object[]{despawnData.playerName()}).getString());
        };
        message = AlertHandler.applyDynamicReplacements(message, (PokemonConfig.PokemonSpecificConfig)AlertHandler.getConfigForPokemon(despawnData.spawnData().translatedPokemonName()).getSecond(), new AlertDataPacket(despawnData.spawnData(), new PokemonStats(-1, IVs.createRandomIVs((int)0), EVs.createEmpty()), despawnData.traits(), Natures.INSTANCE.getNAUGHTY().getName().method_12832(), Abilities.INSTANCE.get("levitate").create(false, Priority.LOWEST).getName(), Gender.GENDERLESS.name()));
        class_2561 component = ComponentUtil.convertFromAdventure(message);
        player.method_43496(component);
    }

    public static Pair<Boolean, PokemonConfig.PokemonSpecificConfig> getConfigForPokemon(String pokemonName) {
        Set<String> pokemonNames = CobblemonSpawnAlerts.CLIENT_CONFIG_MANAGER.getPokemonConfig().pokemonConfigs().keySet();
        String fixedPokemonName = PokemonNameUtil.fixName(pokemonName);
        for (String name : pokemonNames) {
            PokemonConfig.PokemonSpecificConfig pokemonSpecificConfig;
            String fixedName;
            if (name.startsWith("default") || !(fixedName = name.toLowerCase().replaceAll("[ _-]", "")).contains(fixedPokemonName) || !((pokemonSpecificConfig = CobblemonSpawnAlerts.CLIENT_CONFIG_MANAGER.getPokemonConfig().pokemonConfigs().get(name)) instanceof PokemonConfig.PokemonSpecificConfig)) continue;
            PokemonConfig.PokemonSpecificConfig _config = pokemonSpecificConfig;
            return Pair.of((Object)true, (Object)_config);
        }
        PokemonConfig.PokemonSpecificConfig pokemonSpecificConfig = CobblemonSpawnAlerts.CLIENT_CONFIG_MANAGER.getPokemonConfig().pokemonConfigs().get("default (You can modify anything BELOW this, but dont delete it!)");
        if (pokemonSpecificConfig instanceof PokemonConfig.PokemonSpecificConfig) {
            PokemonConfig.PokemonSpecificConfig _config = pokemonSpecificConfig;
            return Pair.of((Object)false, (Object)_config);
        }
        CobblemonSpawnAlerts.LOGGER.warn("No default config found in `pokemon.json`, creating a new one.");
        return Pair.of((Object)false, (Object)PokemonConfig.PokemonSpecificConfig.createDefault());
    }

    public static String applyDynamicReplacements(String message, PokemonConfig.PokemonSpecificConfig config, AlertDataPacket alertData) {
        String configMessage;
        boolean shouldAlertHA;
        String configMessage2;
        boolean isHoverEnabled;
        boolean shouldAlertShiny;
        MessageTemplates messageTemplates = CobblemonSpawnAlerts.CLIENT_CONFIG_MANAGER.getMessageTemplates();
        int level = alertData.stats().level();
        IVs ivs = alertData.stats().ivs();
        EVs evYield = alertData.stats().evYield();
        Nature nature = Natures.INSTANCE.getNature(alertData.natureID());
        AbilityTemplate ability = Abilities.INSTANCE.get(alertData.abilityID());
        Gender gender = Gender.valueOf((String)alertData.genderID());
        String nearestPlayer = alertData.spawnData().nearestPlayerName();
        String pokemonName = PokemonNameUtil.getTranslatedName(alertData.spawnData().translatedPokemonName());
        message = ((String)message).replace("{name}", pokemonName);
        message = ((String)message).replace("{name_lower}", pokemonName.toLowerCase());
        message = ((String)message).replace("{name_upper}", pokemonName.toUpperCase());
        Object hoverText = "";
        Map<String, StatDisplayMode> displayModes = config.statDisplayModes();
        StatDisplayMode levelDisplayMode = displayModes.get("level");
        StatDisplayMode ivsDisplayMode = displayModes.get("ivs");
        StatDisplayMode evsDisplayMode = displayModes.get("evs");
        StatDisplayMode natureDisplayMode = displayModes.get("nature");
        StatDisplayMode abilityDisplayMode = displayModes.get("ability");
        StatDisplayMode genderDisplayMode = displayModes.get("gender");
        StatDisplayMode coordinatesDisplayMode = displayModes.get("coordinates");
        StatDisplayMode biomeDisplayMode = displayModes.get("biome");
        StatDisplayMode nearestPlayerDisplayMode = displayModes.get("nearestPlayer");
        boolean bl = shouldAlertShiny = config.alertShiny() && alertData.traits().isShiny();
        if (shouldAlertShiny) {
            message = ((String)message).replace("{shiny}", class_2561.method_43471((String)messageTemplates.shiny()).getString());
            message = ((String)message).replace("{shiny_unformatted}", class_2561.method_43471((String)messageTemplates.shiny_unformatted()).getString());
        }
        message = ((String)message).replace("{shiny}", "");
        message = ((String)message).replace("{shiny_unformatted}", "");
        if (config.showLegendary()) {
            int dexId = alertData.spawnData().dexId();
            if (RarityUtil.isLegendary(dexId)) {
                message = ((String)message).replace("{legendary}", class_2561.method_43471((String)messageTemplates.legendary()).getString());
                message = ((String)message).replace("{legendary_unformatted}", class_2561.method_43471((String)messageTemplates.legendary_unformatted()).getString());
            } else if (RarityUtil.isMythical(dexId)) {
                message = ((String)message).replace("{legendary}", class_2561.method_43471((String)messageTemplates.mythical()).getString());
                message = ((String)message).replace("{legendary_unformatted}", class_2561.method_43471((String)messageTemplates.mythical_unformatted()).getString());
            } else if (RarityUtil.isUltraBeast(dexId)) {
                message = ((String)message).replace("{legendary}", class_2561.method_43471((String)messageTemplates.ultrabeast()).getString());
                message = ((String)message).replace("{legendary_unformatted}", class_2561.method_43471((String)messageTemplates.ultrabeast_unformatted()).getString());
            } else if (RarityUtil.isParadox(dexId)) {
                message = ((String)message).replace("{legendary}", class_2561.method_43471((String)messageTemplates.paradox()).getString());
                message = ((String)message).replace("{legendary_unformatted}", class_2561.method_43471((String)messageTemplates.paradox_unformatted()).getString());
            }
        }
        message = ((String)message).replace("{legendary}", "");
        message = ((String)message).replace("{legendary_unformatted}", "");
        if (levelDisplayMode != StatDisplayMode.DISABLED) {
            isHoverEnabled = levelDisplayMode == StatDisplayMode.HOVER;
            configMessage2 = isHoverEnabled ? messageTemplates.level_hover() : messageTemplates.level();
            String levelMessage = class_2561.method_43469((String)configMessage2, (Object[])new Object[]{level}).getString();
            if (isHoverEnabled) {
                hoverText = (String)hoverText + levelMessage + "\n";
            } else {
                message = ((String)message).replace("{level}", levelMessage);
            }
            message = ((String)message).replace("{level_unformatted}", class_2561.method_43469((String)messageTemplates.level_unformatted(), (Object[])new Object[]{level}).getString());
        }
        message = ((String)message).replace("{level}", "");
        message = ((String)message).replace("{level_unformatted}", "");
        if (ivsDisplayMode != StatDisplayMode.DISABLED) {
            String ivsMessage;
            isHoverEnabled = ivsDisplayMode == StatDisplayMode.HOVER;
            configMessage2 = isHoverEnabled ? messageTemplates.ivs_hover() : messageTemplates.ivs();
            String string = ivsMessage = Services.PLATFORM.doesServerHaveMod() ? class_2561.method_43469((String)configMessage2, (Object[])new Object[]{ivs.get((Stat)Stats.HP), ivs.get((Stat)Stats.ATTACK), ivs.get((Stat)Stats.DEFENCE), ivs.get((Stat)Stats.SPECIAL_ATTACK), ivs.get((Stat)Stats.SPECIAL_DEFENCE), ivs.get((Stat)Stats.SPEED)}).getString() : class_2561.method_43469((String)configMessage2, (Object[])new Object[]{"-", "-", "-", "-", "-", "-"}).getString();
            if (isHoverEnabled) {
                hoverText = (String)hoverText + ivsMessage + "\n";
            } else {
                message = ((String)message).replace("{ivs}", ivsMessage);
            }
            String ivsUnformatted = Services.PLATFORM.doesServerHaveMod() ? class_2561.method_43469((String)messageTemplates.ivs_unformatted(), (Object[])new Object[]{ivs.get((Stat)Stats.HP), ivs.get((Stat)Stats.ATTACK), ivs.get((Stat)Stats.DEFENCE), ivs.get((Stat)Stats.SPECIAL_ATTACK), ivs.get((Stat)Stats.SPECIAL_DEFENCE), ivs.get((Stat)Stats.SPEED)}).getString() : class_2561.method_43469((String)messageTemplates.evs_unformatted(), (Object[])new Object[]{"-", "-", "-", "-", "-", "-"}).getString();
            message = ((String)message).replace("{ivs_unformatted}", ivsUnformatted);
        }
        message = ((String)message).replace("{ivs}", "");
        message = ((String)message).replace("{ivs_unformatted}", "");
        if (evsDisplayMode != StatDisplayMode.DISABLED) {
            isHoverEnabled = evsDisplayMode == StatDisplayMode.HOVER;
            configMessage2 = isHoverEnabled ? messageTemplates.evs_hover() : messageTemplates.evs();
            String evsMessage = class_2561.method_43469((String)configMessage2, (Object[])new Object[]{evYield.get((Stat)Stats.HP), evYield.get((Stat)Stats.ATTACK), evYield.get((Stat)Stats.DEFENCE), evYield.get((Stat)Stats.SPECIAL_ATTACK), evYield.get((Stat)Stats.SPECIAL_DEFENCE), evYield.get((Stat)Stats.SPEED)}).getString();
            if (isHoverEnabled) {
                hoverText = (String)hoverText + evsMessage + "\n";
            } else {
                message = ((String)message).replace("{evs}", evsMessage);
            }
            String evsUnformatted = class_2561.method_43469((String)messageTemplates.evs_unformatted(), (Object[])new Object[]{evYield.get((Stat)Stats.HP), evYield.get((Stat)Stats.ATTACK), evYield.get((Stat)Stats.DEFENCE), evYield.get((Stat)Stats.SPECIAL_ATTACK), evYield.get((Stat)Stats.SPECIAL_DEFENCE), evYield.get((Stat)Stats.SPEED)}).getString();
            message = ((String)message).replace("{evs_unformatted}", evsUnformatted);
        }
        message = ((String)message).replace("{evs}", "");
        message = ((String)message).replace("{evs_unformatted}", "");
        if (natureDisplayMode != StatDisplayMode.DISABLED) {
            isHoverEnabled = natureDisplayMode == StatDisplayMode.HOVER;
            configMessage2 = isHoverEnabled ? messageTemplates.nature_hover() : messageTemplates.nature();
            String natureString = nature != null ? MiscUtilsKt.asTranslated((String)nature.getDisplayName()).getString() : "N/A";
            natureString = StringUtil.capitalize(natureString);
            natureString = AlertHandler.replaceIfNotAvailable(natureString);
            String natureMessage = class_2561.method_43469((String)configMessage2, (Object[])new Object[]{natureString}).getString();
            if (isHoverEnabled) {
                hoverText = (String)hoverText + natureMessage + "\n";
            } else {
                message = ((String)message).replace("{nature}", natureMessage);
            }
            String natureUnformatted = AlertHandler.replaceIfNotAvailable(class_2561.method_43469((String)messageTemplates.nature_unformatted(), (Object[])new Object[]{natureString}).getString());
            message = ((String)message).replace("{nature_unformatted}", natureUnformatted);
        }
        message = ((String)message).replace("{nature}", "");
        message = ((String)message).replace("{nature_unformatted}", "");
        if (abilityDisplayMode != StatDisplayMode.DISABLED) {
            isHoverEnabled = abilityDisplayMode == StatDisplayMode.HOVER;
            configMessage2 = isHoverEnabled ? messageTemplates.ability_hover() : messageTemplates.ability();
            String abilityString = ability != null ? StringUtil.capitalize(MiscUtilsKt.asTranslated((String)ability.getDisplayName()).getString()) : "N/A";
            abilityString = AlertHandler.replaceIfNotAvailable(abilityString);
            String abilityMessage = class_2561.method_43469((String)configMessage2, (Object[])new Object[]{abilityString}).getString();
            if (isHoverEnabled) {
                hoverText = (String)hoverText + abilityMessage + "\n";
            } else {
                message = ((String)message).replace("{ability}", abilityMessage);
            }
            String abilityUnformatted = AlertHandler.replaceIfNotAvailable(class_2561.method_43469((String)messageTemplates.ability_unformatted(), (Object[])new Object[]{abilityString}).getString());
            message = ((String)message).replace("{ability_unformatted}", abilityUnformatted);
        }
        message = ((String)message).replace("{ability}", "");
        message = ((String)message).replace("{ability_unformatted}", "");
        boolean bl2 = shouldAlertHA = config.alertHiddenAbility() && HiddenAbilityUtil.hasHiddenAbility(alertData.spawnData().dexId(), alertData.abilityID());
        if (shouldAlertHA) {
            message = ((String)message).replace("{HA}", class_2561.method_43471((String)messageTemplates.hidden_ability()).getString());
            message = ((String)message).replace("{HA_unformatted}", class_2561.method_43471((String)messageTemplates.hidden_ability_unformatted()).getString());
        }
        message = ((String)message).replace("{HA}", "");
        message = ((String)message).replace("{HA_unformatted}", "");
        if (genderDisplayMode != StatDisplayMode.DISABLED) {
            boolean isHoverEnabled2 = genderDisplayMode == StatDisplayMode.HOVER;
            String genderSymbol = switch (gender) {
                default -> throw new MatchException(null, null);
                case Gender.MALE -> messageTemplates.male();
                case Gender.FEMALE -> messageTemplates.female();
                case Gender.GENDERLESS -> messageTemplates.genderless();
            };
            String genderName = StringUtil.capitalize(gender.toString().toLowerCase());
            String genderString = class_2561.method_43469((String)genderSymbol, (Object[])new Object[]{genderName}).getString();
            String configMessage3 = isHoverEnabled2 ? messageTemplates.gender_hover() : messageTemplates.gender();
            String genderMessage = class_2561.method_43469((String)configMessage3, (Object[])new Object[]{genderString}).getString();
            if (isHoverEnabled2) {
                hoverText = (String)hoverText + genderMessage + "\n";
            } else {
                message = ((String)message).replace("{gender}", genderMessage);
            }
            message = ((String)message).replace("{gender_unformatted}", class_2561.method_43469((String)messageTemplates.gender_unformatted(), (Object[])new Object[]{genderName}).getString());
        }
        message = ((String)message).replace("{gender}", "");
        message = ((String)message).replace("{gender_unformatted}", "");
        Vector3f coords = new Vector3f(alertData.spawnData().position().x, alertData.spawnData().position().y, alertData.spawnData().position().z);
        if (coordinatesDisplayMode != StatDisplayMode.DISABLED) {
            boolean isHoverEnabled3 = coordinatesDisplayMode == StatDisplayMode.HOVER;
            configMessage = isHoverEnabled3 ? messageTemplates.coords_hover() : messageTemplates.coords();
            String coordsMessage = class_2561.method_43469((String)configMessage, (Object[])new Object[]{(int)coords.x, (int)coords.y, (int)coords.z}).getString();
            if (isHoverEnabled3) {
                hoverText = (String)hoverText + coordsMessage + "\n";
            } else {
                message = ((String)message).replace("{coords}", coordsMessage);
            }
            message = ((String)message).replace("{coords_unformatted}", class_2561.method_43469((String)messageTemplates.coords_unformatted(), (Object[])new Object[]{(int)coords.x, (int)coords.y, (int)coords.z}).getString());
        }
        message = ((String)message).replace("{coords}", "");
        message = ((String)message).replace("{coords_unformatted}", "");
        if (biomeDisplayMode != StatDisplayMode.DISABLED && class_310.method_1551().field_1687 != null) {
            boolean isHoverEnabled4 = biomeDisplayMode == StatDisplayMode.HOVER;
            String biomeName = class_2561.method_43471((String)alertData.spawnData().biomeKey()).getString();
            biomeName = StringUtil.makeBeautiful(biomeName);
            String configMessage4 = isHoverEnabled4 ? messageTemplates.biome_hover() : messageTemplates.biome();
            String biomeMessage = class_2561.method_43469((String)configMessage4, (Object[])new Object[]{biomeName}).getString();
            if (isHoverEnabled4) {
                hoverText = (String)hoverText + biomeMessage + "\n";
            } else {
                message = ((String)message).replace("{biome}", biomeMessage);
            }
            message = ((String)message).replace("{biome_unformatted}", class_2561.method_43469((String)messageTemplates.biome_unformatted(), (Object[])new Object[]{biomeName}).getString());
        }
        message = ((String)message).replace("{biome}", "");
        message = ((String)message).replace("{biome_unformatted}", "");
        if (nearestPlayerDisplayMode != StatDisplayMode.DISABLED) {
            boolean isHoverEnabled5 = nearestPlayerDisplayMode == StatDisplayMode.HOVER;
            configMessage = isHoverEnabled5 ? messageTemplates.nearest_player_hover() : messageTemplates.nearest_player();
            String nearestPlayerMessage = class_2561.method_43469((String)configMessage, (Object[])new Object[]{nearestPlayer}).getString();
            if (isHoverEnabled5) {
                hoverText = (String)hoverText + nearestPlayerMessage + "\n";
            } else {
                message = ((String)message).replace("{nearest_player}", nearestPlayerMessage);
            }
            message = ((String)message).replace("{nearest_player_unformatted}", class_2561.method_43469((String)messageTemplates.nearest_player_unformatted(), (Object[])new Object[]{nearestPlayer}).getString());
        }
        message = ((String)message).replace("{nearest_player}", "");
        message = ((String)message).replace("{nearest_player_unformatted}", "");
        hoverText = (String)hoverText + "<green>Click to toggle glow</green>";
        message = "<hover:show_text:\"" + (String)hoverText + "\">" + (String)message + "</hover>";
        message = Services.PLATFORM.getPlatform() == Platform.FABRIC ? "<click:run_command:/csa glow " + alertData.spawnData().pokemonUUID().toString() + ">" + (String)message + "</click>" : "<click:suggest_command:/csa glow " + alertData.spawnData().pokemonUUID().toString() + ">" + (String)message + "</click>";
        return message;
    }

    private static String replaceIfNotAvailable(String string) {
        if (!Services.PLATFORM.doesServerHaveMod()) {
            return "N/A";
        }
        return string;
    }
}

