/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis.core;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.EVs;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.stat.CobblemonStatProvider;
import io.github.stainlessstasis.alert.DespawnReason;
import io.github.stainlessstasis.config.ClientConfigManager;
import io.github.stainlessstasis.config.CommonConfigManager;
import io.github.stainlessstasis.config.ServerConfig;
import io.github.stainlessstasis.network.AlertDataPacket;
import io.github.stainlessstasis.network.DespawnDataPacket;
import io.github.stainlessstasis.network.PokemonDataPacket;
import io.github.stainlessstasis.network.PokemonSpawnData;
import io.github.stainlessstasis.network.PokemonStats;
import io.github.stainlessstasis.network.PokemonTraits;
import io.github.stainlessstasis.platform.Services;
import io.github.stainlessstasis.util.BiomeUtil;
import io.github.stainlessstasis.util.EvsUtil;
import io.github.stainlessstasis.util.PokemonNameUtil;
import io.github.stainlessstasis.util.RarityUtil;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.StreamSupport;
import kotlin.Unit;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CobblemonSpawnAlerts {
    public static final String MOD_ID = "cobblemon_spawn_alerts";
    public static final String MOD_VERSION = "1.10.0";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cobblemon_spawn_alerts");
    public static final CommonConfigManager COMMON_CONFIG_MANAGER = new CommonConfigManager();
    public static final ClientConfigManager CLIENT_CONFIG_MANAGER = new ClientConfigManager();
    public static final String DEFAULT_POKEMON_CONFIG_NAME = "default (You can modify anything BELOW this, but dont delete it!)";
    public static Set<UUID> globallyAlerted = new HashSet<UUID>();
    public static Set<UUID> despawned = new HashSet<UUID>();
    public static Set<UUID> glowing = new HashSet<UUID>();

    public static void initServer() {
        LOGGER.info("CobblemonSpawnAlerts server initializing...");
        COMMON_CONFIG_MANAGER.loadConfig();
        CobblemonEvents.POKEMON_ENTITY_SPAWN.subscribe(Priority.NORMAL, evt -> {
            Services.PLATFORM.onPokemonSpawned((PokemonEntity)evt.getEntity());
            return Unit.INSTANCE;
        });
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.NORMAL, evt -> {
            if (globallyAlerted.contains(evt.getPokemon().getUuid())) {
                Services.PLATFORM.onPokemonDespawned(evt.getPlayer().method_37908(), evt.getPokemon(), evt.getPlayer().method_5477().getString(), DespawnReason.CAPTURED);
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.BATTLE_FAINTED.subscribe(Priority.NORMAL, evt -> {
            class_1657 player;
            Pokemon pokemon = evt.getKilled().getEntity().getPokemon();
            if (pokemon.getOwnerUUID() != null || !evt.getBattle().isPvW() || !globallyAlerted.contains(pokemon.getUuid())) {
                return Unit.INSTANCE;
            }
            Optional uuid = StreamSupport.stream(evt.getBattle().getPlayerUUIDs().spliterator(), false).findFirst();
            String playerName = "N/A";
            if (uuid.isPresent() && (player = evt.getKilled().getEntity().method_37908().method_18470((UUID)uuid.get())) != null) {
                playerName = player.method_5477().getString();
            }
            Services.PLATFORM.onPokemonDespawned(evt.getKilled().getEntity().method_37908(), pokemon, playerName, DespawnReason.FAINTED);
            return Unit.INSTANCE;
        });
    }

    public static void initClient() {
        LOGGER.info("CobblemonSpawnAlerts client initializing...");
        CLIENT_CONFIG_MANAGER.loadConfig();
    }

    public static PokemonDataPacket createPokemonData(PokemonEntity pokemonEntity) {
        ServerConfig config = COMMON_CONFIG_MANAGER.getServerConfig();
        Pokemon pokemon = pokemonEntity.getPokemon();
        IVs ivs = config.broadcastIVs() ? pokemon.getIvs() : CobblemonStatProvider.INSTANCE.createEmptyIVs(0);
        Nature nature = config.broadcastNature() ? pokemon.getNature() : Natures.NAUGHTY;
        Ability ability = config.broadcastAbility() ? pokemon.getAbility() : Abilities.get((String)"levitate").create(false, Priority.LOWEST);
        EVs finalEvYield = CobblemonStatProvider.INSTANCE.createEmptyEVs();
        if (config.broadcastEVs()) {
            finalEvYield = EvsUtil.getEVsFromYield(pokemon.getForm().getEvYield());
        }
        return new PokemonDataPacket(pokemonEntity.method_5628(), ivs, finalEvYield, nature, ability);
    }

    public static AlertDataPacket createAlertData(PokemonEntity pokemonEntity) {
        ServerConfig config = COMMON_CONFIG_MANAGER.getServerConfig();
        Pokemon pokemon = pokemonEntity.getPokemon();
        String pokemonName = PokemonNameUtil.getTranslationKey(pokemon);
        boolean shouldAlertShiny = pokemon.getShiny() && config.alertShinies();
        boolean shouldAlertLegend = pokemon.isLegendary() && config.alertLegendaries();
        boolean shouldAlertMythical = pokemon.isMythical() && config.alertMythicals();
        boolean shouldAlertUltra = pokemon.isUltraBeast() && config.alertUltraBeasts();
        boolean shouldAlertParadox = pokemon.hasLabels(new String[]{"paradox"}) && config.alertParadox();
        boolean shouldAlertStarter = RarityUtil.isStarter(pokemon.getSpecies().getNationalPokedexNumber()) && config.alertStarters();
        IVs ivs = config.broadcastIVs() ? pokemon.getIvs() : IVs.createRandomIVs((int)0);
        EVs evYield = config.broadcastEVs() ? EvsUtil.getEVsFromYield(pokemonEntity.getForm().getEvYield()) : EVs.createEmpty();
        String nature = config.broadcastNature() ? pokemon.getNature().getName().method_12832() : Natures.NAUGHTY.getName().method_12832();
        String ability = config.broadcastAbility() ? pokemon.getAbility().getName() : Abilities.get((String)"levitate").create(false, Priority.LOWEST).getName();
        String nearestPlayerName = "N/A";
        class_1657 class_16572 = pokemonEntity.method_37908().method_18460((class_1297)pokemonEntity, 128.0);
        if (class_16572 instanceof class_1657) {
            class_1657 player = class_16572;
            nearestPlayerName = player.method_5477().getString();
        }
        return new AlertDataPacket(new PokemonSpawnData(pokemonName, pokemon.getUuid(), pokemonEntity.method_19538().method_46409(), pokemon.getSpecies().getNationalPokedexNumber(), nearestPlayerName, BiomeUtil.getBiomeKeyFromCoords(pokemonEntity.method_37908(), pokemonEntity.method_19538())), new PokemonStats(pokemon.getLevel(), ivs, evYield), new PokemonTraits(shouldAlertShiny, shouldAlertLegend, shouldAlertMythical, shouldAlertUltra, shouldAlertParadox, shouldAlertStarter), nature, ability, pokemon.getGender().name());
    }

    public static DespawnDataPacket createDespawnData(Pokemon pokemon, String playerName, DespawnReason despawnReason) {
        ServerConfig config = COMMON_CONFIG_MANAGER.getServerConfig();
        String pokemonName = PokemonNameUtil.getTranslationKey(pokemon);
        boolean shouldAlertShiny = pokemon.getShiny() && config.alertShinies();
        boolean shouldAlertLegend = pokemon.isLegendary() && config.alertLegendaries();
        boolean shouldAlertMythical = pokemon.isMythical() && config.alertMythicals();
        boolean shouldAlertUltra = pokemon.isUltraBeast() && config.alertUltraBeasts();
        boolean shouldAlertParadox = pokemon.hasLabels(new String[]{"paradox"}) && config.alertParadox();
        boolean shouldAlertStarter = RarityUtil.isStarter(pokemon.getSpecies().getNationalPokedexNumber()) && config.alertStarters();
        return new DespawnDataPacket(playerName, new PokemonSpawnData(pokemonName, pokemon.getUuid(), new Vector3f(0.0f, 0.0f, 0.0f), pokemon.getSpecies().getNationalPokedexNumber(), "N/A", "N/A"), new PokemonTraits(shouldAlertShiny, shouldAlertLegend, shouldAlertMythical, shouldAlertUltra, shouldAlertParadox, shouldAlertStarter), despawnReason.name());
    }
}

