/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis.platform;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import io.github.stainlessstasis.alert.DespawnReason;
import io.github.stainlessstasis.core.CobblemonSpawnAlerts;
import io.github.stainlessstasis.platform.Platform;
import java.nio.file.Path;
import net.minecraft.class_1937;

public interface IPlatformHelper {
    public Platform getPlatform();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    default public String getEnvironmentName() {
        return this.isDevelopmentEnvironment() ? "development" : "production";
    }

    public Path getConfigDir();

    public void onPokemonSpawned(PokemonEntity var1);

    default public void onPokemonDespawned(class_1937 _level, Pokemon pokemon, String playerName, DespawnReason despawnReason) {
        CobblemonSpawnAlerts.globallyAlerted.remove(pokemon.getUuid());
        if (despawnReason != DespawnReason.DESPAWNED) {
            CobblemonSpawnAlerts.despawned.add(pokemon.getUuid());
        } else {
            CobblemonSpawnAlerts.despawned.remove(pokemon.getUuid());
            CobblemonSpawnAlerts.glowing.remove(pokemon.getUuid());
        }
    }

    public boolean doesServerHaveMod();
}

